/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderStateDelegator;
import org.lobobrowser.html.style.WordInfo;

public class FontStyleRenderState
extends RenderStateDelegator {
    private final int style;
    private Font iFont;
    private FontMetrics iFontMetrics;
    Map iWordInfoMap = null;

    public FontStyleRenderState(RenderState prevRenderState, int style) {
        super(prevRenderState);
        this.style = style;
    }

    public Font getFont() {
        Font f10 = this.iFont;
        if (f10 != null) {
            return f10;
        }
        Font parentFont = this.prevRenderState.getFont();
        this.iFont = f10 = parentFont.deriveFont(this.style | parentFont.getStyle());
        return f10;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm2 = this.iFontMetrics;
        if (fm2 == null) {
            this.iFontMetrics = fm2 = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fm2;
    }

    public void invalidate() {
        this.prevRenderState.invalidate();
        this.iFont = null;
        this.iFontMetrics = null;
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
    }

    public final WordInfo getWordInfo(String word) {
        FontMetrics fm2;
        WordInfo wi2;
        HashMap<String, WordInfo> map = this.iWordInfoMap;
        if (map == null) {
            this.iWordInfoMap = map = new HashMap<String, WordInfo>(1);
        }
        if ((wi2 = (WordInfo)map.get(word)) != null) {
            return wi2;
        }
        wi2 = new WordInfo();
        wi2.fontMetrics = fm2 = this.getFontMetrics();
        wi2.ascentPlusLeading = fm2.getAscent() + fm2.getLeading();
        wi2.descent = fm2.getDescent();
        wi2.height = fm2.getHeight();
        wi2.width = fm2.stringWidth(word);
        map.put(word, wi2);
        return wi2;
    }
}

