/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.File;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.InputContext;
import org.w3c.dom.html2.HTMLInputElement;

public class HTMLInputElementImpl
extends HTMLBaseInputElement
implements HTMLInputElement {
    private boolean defaultChecked;

    public HTMLInputElementImpl(String name) {
        super(name);
    }

    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultChecked = defaultChecked;
    }

    public boolean getChecked() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? false : ic2.getChecked();
    }

    public void setChecked(boolean checked) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setChecked(checked);
        }
    }

    public int getMaxLength() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? 0 : ic2.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setMaxLength(maxLength);
        }
    }

    public int getSize() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? 0 : ic2.getControlSize();
    }

    public void setSize(int size) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setControlSize(size);
        }
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getType() {
        String type = this.getAttribute("type");
        return type == null ? null : type.toLowerCase();
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getUseMap() {
        return this.getAttribute("usemap");
    }

    public void setUseMap(String useMap) {
        this.setAttribute("usemap", useMap);
    }

    public void click() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.click();
        }
    }

    public boolean isSubmittableWithEnterKey() {
        String type = this.getType();
        return type == null || "".equals(type) || "text".equals(type) || "password".equals(type);
    }

    public boolean isSubmittableWithPress() {
        String type = this.getType();
        return "submit".equals(type) || "image".equals(type);
    }

    public boolean isSubmitInput() {
        String type = this.getType();
        return "submit".equals(type);
    }

    public boolean isImageInput() {
        String type = this.getType();
        return "image".equals(type);
    }

    public boolean isResetInput() {
        String type = this.getType();
        return "reset".equals(type);
    }

    void resetInput() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.resetInput();
        }
    }

    protected FormInput[] getFormInputs() {
        String type = this.getType();
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (type == null) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("text".equals(type) || "password".equals(type) || "hidden".equals(type) || "".equals(type)) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("submit".equals(type)) {
            return null;
        }
        if ("radio".equals(type) || "checkbox".equals(type)) {
            if (this.getChecked()) {
                String value = this.getValue();
                if (value == null || value.length() == 0) {
                    value = "on";
                }
                return new FormInput[]{new FormInput(name, value)};
            }
            return null;
        }
        if ("image".equals(type)) {
            return null;
        }
        if ("file".equals(type)) {
            File file = this.getFileValue();
            if (file == null) {
                return null;
            }
            return new FormInput[]{new FormInput(name, file)};
        }
        return null;
    }
}

