/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLIFrameElement;

public class HTMLIFrameElementImpl
extends HTMLAbstractUIElement
implements HTMLIFrameElement,
FrameNode {
    private volatile BrowserFrame browserFrame;

    public HTMLIFrameElementImpl(String name) {
        super(name);
    }

    public void setBrowserFrame(BrowserFrame frame) {
        String src;
        this.browserFrame = frame;
        if (frame != null && (src = this.getAttribute("src")) != null) {
            try {
                frame.loadURL(this.getFullURL(src));
            }
            catch (MalformedURLException mfu) {
                this.warn("setBrowserFrame(): Unable to navigate to src.", mfu);
            }
        }
    }

    public BrowserFrame getBrowserFrame() {
        return this.browserFrame;
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public Document getContentDocument() {
        BrowserFrame frame = this.browserFrame;
        if (frame == null) {
            return null;
        }
        return frame.getContentDocument();
    }

    public String getFrameBorder() {
        return this.getAttribute("frameborder");
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public String getLongDesc() {
        return this.getAttribute("longdesc");
    }

    public String getMarginHeight() {
        return this.getAttribute("marginheight");
    }

    public String getMarginWidth() {
        return this.getAttribute("marginwidth");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getScrolling() {
        return this.getAttribute("scrolling");
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public void setFrameBorder(String frameBorder) {
        this.setAttribute("frameborder", frameBorder);
    }

    public void setHeight(String height) {
        this.setAttribute("height", height);
    }

    public void setLongDesc(String longDesc) {
        this.setAttribute("longdesc", longDesc);
    }

    public void setMarginHeight(String marginHeight) {
        this.setAttribute("marginHeight", marginHeight);
    }

    public void setMarginWidth(String marginWidth) {
        this.setAttribute("marginWidth", marginWidth);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setScrolling(String scrolling) {
        this.setAttribute("scrolling", scrolling);
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    protected void assignAttributeField(String normalName, String value) {
        if ("src".equals(normalName)) {
            BrowserFrame frame = this.browserFrame;
            if (frame != null) {
                try {
                    frame.loadURL(this.getFullURL(value));
                }
                catch (MalformedURLException mfu) {
                    this.warn("assignAttributeField(): Unable to navigate to src.", mfu);
                }
            }
        } else {
            super.assignAttributeField(normalName, value);
        }
    }
}

