/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.style.CSS2PropertiesContext;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.Strings;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement,
CSS2PropertiesContext {
    private final boolean noStyleSheet;
    private volatile CSS2PropertiesImpl currentStyleDeclarationState;
    private volatile CSS2PropertiesImpl localStyleDeclarationState;

    public HTMLElementImpl(String name, boolean noStyleSheet) {
        super(name);
        this.noStyleSheet = noStyleSheet;
    }

    public HTMLElementImpl(String name) {
        super(name);
        this.noStyleSheet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetLocalStyle() {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.currentStyleDeclarationState = null;
            this.localStyleDeclarationState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetStyle(boolean deep) {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ArrayList nl2;
            this.currentStyleDeclarationState = null;
            if (deep && (nl2 = this.nodeList) != null) {
                Iterator i10 = nl2.iterator();
                while (i10.hasNext()) {
                    Object node = i10.next();
                    if (!(node instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)node).forgetStyle(deep);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSS2PropertiesImpl getCurrentStyle() {
        CSS2PropertiesImpl sds;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            sds = this.currentStyleDeclarationState;
            if (sds != null) {
                return sds;
            }
        }
        sds = this.addStyleSheetDeclarations(sds);
        CSS2PropertiesImpl localStyle = this.getStyle();
        if (sds == null) {
            sds = new CSS2PropertiesImpl(this);
            sds.setLocalStyleProperties(localStyle);
        } else {
            sds.setLocalStyleProperties(localStyle);
        }
        HTMLElementImpl hTMLElementImpl2 = this;
        synchronized (hTMLElementImpl2) {
            CSS2PropertiesImpl setProps = this.currentStyleDeclarationState;
            if (setProps != null) {
                return setProps;
            }
            this.currentStyleDeclarationState = sds;
            return sds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSS2PropertiesImpl getStyle() {
        CSS2PropertiesImpl sds;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            sds = this.localStyleDeclarationState;
            if (sds != null) {
                return sds;
            }
            sds = new CSS2PropertiesImpl(this);
            String style = this.getAttribute("style");
            if (style != null && style.length() != 0) {
                CSSOMParser parser = new CSSOMParser();
                InputSource inputSource = this.getCssInputSourceForDecl(style);
                try {
                    CSSStyleDeclaration sd2 = parser.parseStyleDeclaration(inputSource);
                    sds.addStyleDeclaration(sd2);
                }
                catch (Exception err) {
                    String id2 = this.getId();
                    String withId = id2 == null ? "" : " with ID '" + id2 + "'";
                    this.warn("Unable to parse style attribute value for element " + this.getTagName() + withId + ".", err);
                }
            }
            this.localStyleDeclarationState = sds;
        }
        return sds;
    }

    public void setStyle(Object value) {
        throw new DOMException(9, "Cannot set style property");
    }

    public void setCurrentStyle(Object value) {
        throw new DOMException(9, "Cannot set currentStyle property");
    }

    public String getClassName() {
        String className = this.getAttribute("class");
        return className == null ? "" : className;
    }

    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    public String getCharset() {
        return this.getAttribute("charset");
    }

    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    public void warn(String message, Throwable err) {
    }

    public void warn(String message) {
    }

    protected int getAttributeAsInt(String name, int defaultValue) {
        String value = this.getAttribute(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception err) {
            this.warn("Bad integer", err);
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) {
        String value = this.getAttribute(name);
        return name.equalsIgnoreCase(value);
    }

    protected void assignAttributeField(String normalName, String value) {
        if (!this.notificationsSuspended) {
            this.informInvalidAttibute(normalName);
        } else if ("style".equals(normalName)) {
            this.forgetLocalStyle();
        }
        super.assignAttributeField(normalName, value);
    }

    protected final InputSource getCssInputSourceForDecl(String text) {
        StringReader reader = new StringReader("{" + text + "}");
        InputSource is2 = new InputSource(reader);
        return is2;
    }

    protected final CSS2PropertiesImpl addStyleSheetDeclarations(CSS2PropertiesImpl style) {
        block7: {
            block6: {
                Node pn2 = this.parentNode;
                if (pn2 == null) {
                    return style;
                }
                String classNames = this.getClassName();
                if (classNames == null || classNames.length() == 0) break block6;
                String id2 = this.getId();
                String elementName = this.getTagName();
                String[] classNameArray = Strings.split(classNames);
                int i10 = classNameArray.length;
                while (--i10 >= 0) {
                    String className = classNameArray[i10];
                    Collection sds = this.findStyleDeclarations(elementName, id2, className);
                    if (sds == null) continue;
                    Iterator sdsi = sds.iterator();
                    while (sdsi.hasNext()) {
                        CSSStyleDeclaration sd2 = (CSSStyleDeclaration)sdsi.next();
                        if (style == null) {
                            style = new CSS2PropertiesImpl(this);
                        }
                        style.addStyleDeclaration(sd2);
                    }
                }
                break block7;
            }
            String id3 = this.getId();
            String elementName = this.getTagName();
            Collection sds = this.findStyleDeclarations(elementName, id3, null);
            if (sds == null) break block7;
            Iterator sdsi = sds.iterator();
            while (sdsi.hasNext()) {
                CSSStyleDeclaration sd3 = (CSSStyleDeclaration)sdsi.next();
                if (style == null) {
                    style = new CSS2PropertiesImpl(this);
                }
                style.addStyleDeclaration(sd3);
            }
        }
        return style;
    }

    protected final Collection findStyleDeclarations(String elementName, String id2, String className) {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc == null) {
            return null;
        }
        StyleSheetAggregator ssa = doc.getStyleSheetAggregator();
        return ssa.getStyleDeclarations(this, elementName, id2, className);
    }

    public void informInvalid() {
        this.forgetStyle(false);
        super.informInvalid();
    }

    public void informInvalidAttibute(String normalName) {
        if ("style".equals(normalName)) {
            this.forgetLocalStyle();
        } else if ("id".equals(normalName) || "class".equals(normalName)) {
            this.forgetStyle(false);
        }
        super.informInvalid();
    }

    public void informLayoutInvalid() {
        super.informLayoutInvalid();
    }

    protected FormInput[] getFormInputs() {
        return null;
    }

    private boolean classMatch(String classTL) {
        String classNames = this.getClassName();
        if (classNames == null || classNames.length() == 0) {
            return classTL == null;
        }
        StringTokenizer tok = new StringTokenizer(classNames, " \t\r\n");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!token.toLowerCase().equals(classTL)) continue;
            return true;
        }
        return false;
    }

    public HTMLElementImpl getAncestorWithClass(String elementTL, String classTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && parentElement.classMatch(classTL)) {
                return parentElement;
            }
            return parentElement.getAncestorWithClass(elementTL, classTL);
        }
        return null;
    }

    public HTMLElementImpl getAncestorWithId(String elementTL, String idTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            String pidTL;
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            String pid = parentElement.getId();
            String string = pidTL = pid == null ? null : pid.toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && idTL.equals(pidTL)) {
                return parentElement;
            }
            return parentElement.getAncestorWithId(elementTL, idTL);
        }
        return null;
    }

    public HTMLElementImpl getAncestor(String elementTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            if ("*".equals(elementTL)) {
                return parentElement;
            }
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (elementTL.equals(pelementTL)) {
                return parentElement;
            }
            return parentElement.getAncestor(elementTL);
        }
        return null;
    }

    protected Object getAncestorForJavaClass(Class javaClass) {
        Node nodeObj = this.getParentNode();
        if (nodeObj == null || javaClass.isInstance(nodeObj)) {
            return nodeObj;
        }
        if (nodeObj instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)nodeObj).getAncestorForJavaClass(javaClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerHTML(String newHtml) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document == null) {
            this.warn("setInnerHTML(): Element " + this + " does not belong to a document.");
            return;
        }
        HtmlParser parser = new HtmlParser(document.getUserAgentContext(), (HTMLDocument)document, null, null, null);
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                nl2.clear();
            }
        }
        try {
            StringReader reader = new StringReader(newHtml);
            try {
                parser.parse(reader, (Node)this);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Exception thrown) {
            this.warn("setInnerHTML(): Error setting inner HTML.", thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerHTML() {
        StringBuffer buffer = new StringBuffer();
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.appendInnerHTMLImpl(buffer);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOuterHTML() {
        StringBuffer buffer = new StringBuffer();
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.appendOuterHTMLImpl(buffer);
        }
        return buffer.toString();
    }

    protected void appendInnerHTMLImpl(StringBuffer buffer) {
        int size;
        ArrayList nl2 = this.nodeList;
        if (nl2 != null && (size = nl2.size()) > 0) {
            for (int i10 = 0; i10 < size; ++i10) {
                Node child = (Node)nl2.get(i10);
                if (child instanceof HTMLElementImpl) {
                    ((HTMLElementImpl)child).appendOuterHTMLImpl(buffer);
                    continue;
                }
                if (child instanceof Comment) {
                    buffer.append("<!--" + ((Comment)child).getTextContent() + "-->");
                    continue;
                }
                if (!(child instanceof Text)) continue;
                String text = ((Text)child).getTextContent();
                String encText = Strings.strictHtmlEncode(text);
                buffer.append(encText);
            }
        }
    }

    protected void appendOuterHTMLImpl(StringBuffer buffer) {
        ArrayList nl2;
        String tagName = this.getTagName();
        buffer.append('<');
        buffer.append(tagName);
        Map attributes = this.attributes;
        if (attributes != null) {
            Iterator i10 = attributes.entrySet().iterator();
            while (i10.hasNext()) {
                Map.Entry entry = i10.next();
                String value = (String)entry.getValue();
                if (value == null) continue;
                buffer.append(' ');
                buffer.append(entry.getKey());
                buffer.append("=\"");
                buffer.append(Strings.strictHtmlEncode(value));
                buffer.append("\"");
            }
        }
        if ((nl2 = this.nodeList) == null || nl2.size() == 0) {
            buffer.append("/>");
            return;
        }
        buffer.append('>');
        this.appendInnerHTMLImpl(buffer);
        buffer.append("</");
        buffer.append(tagName);
        buffer.append('>');
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return new StyleSheetRenderState(prevRenderState, this);
    }

    public int getOffsetTop() {
        CSS2PropertiesImpl style = this.getCurrentStyle();
        if (style == null) {
            return 0;
        }
        String topText = style.getTop();
        return topText == null ? 0 : HtmlValues.getPixelSize(topText, this.getRenderState(), 0);
    }

    public int getOffsetLeft() {
        CSS2PropertiesImpl style = this.getCurrentStyle();
        if (style == null) {
            return 0;
        }
        String leftText = style.getLeft();
        return leftText == null ? 0 : HtmlValues.getPixelSize(leftText, this.getRenderState(), 0);
    }

    public int getOffsetWidth() {
        CSS2PropertiesImpl style = this.getCurrentStyle();
        if (style == null) {
            return 0;
        }
        String valueText = style.getWidth();
        return valueText == null ? 0 : HtmlValues.getPixelSize(valueText, this.getRenderState(), 0);
    }

    public int getOffsetHeight() {
        CSS2PropertiesImpl style = this.getCurrentStyle();
        if (style == null) {
            return 0;
        }
        String valueText = style.getHeight();
        return valueText == null ? 0 : HtmlValues.getPixelSize(valueText, this.getRenderState(), 0);
    }

    public CSS2PropertiesImpl getParentStyle() {
        Node parent = this.parentNode;
        if (parent instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)parent).getCurrentStyle();
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[currentStyle=" + this.getCurrentStyle() + "]";
    }
}

