/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.lobobrowser.html.domimpl.AttrImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NamedNodeMapImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeListImpl;
import org.lobobrowser.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    private final String name;
    protected Map attributes;
    private String id;

    public ElementImpl(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedNodeMap getAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            HashMap attrs = this.attributes;
            if (attrs == null) {
                this.attributes = attrs = new HashMap();
            }
            return new NamedNodeMapImpl(this, this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attrs = this.attributes;
            return attrs == null ? false : !attrs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalAttributes(Node arg) {
        if (arg instanceof ElementImpl) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                Map attrs2;
                Map attrs1 = this.attributes;
                if (attrs1 == null) {
                    attrs1 = Collections.EMPTY_MAP;
                }
                if ((attrs2 = ((ElementImpl)arg).attributes) == null) {
                    attrs2 = Collections.EMPTY_MAP;
                }
                return Objects.equals(attrs1, attrs2);
            }
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.setAttribute("id", id2);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    public String getLang() {
        return this.getAttribute("lang");
    }

    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    public String getDir() {
        return this.getAttribute("dir");
    }

    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAttribute(String name) {
        String normalName = this.normalizeAttributeName(name);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attributes = this.attributes;
            return attributes == null ? null : (String)attributes.get(normalName);
        }
    }

    private Attr getAttr(String normalName, String value) {
        return new AttrImpl(normalName, value, true, this, "id".equals(normalName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr getAttributeNode(String name) {
        String normalName = this.normalizeAttributeName(name);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attributes = this.attributes;
            String value = attributes == null ? null : (String)attributes.get(normalName);
            return value == null ? null : this.getAttr(normalName, value);
        }
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected static boolean isTagName(Node node, String name) {
        return node.getNodeName().equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getElementsByTagName(String name) {
        boolean matchesAll = "*".equals(name);
        LinkedList descendents = new LinkedList();
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                while (i10.hasNext()) {
                    Object child = i10.next();
                    if (!(child instanceof Element)) continue;
                    Element childElement = (Element)child;
                    if (matchesAll || ElementImpl.isTagName(childElement, name)) {
                        descendents.add(child);
                    }
                    NodeList sublist = childElement.getElementsByTagName(name);
                    int length = sublist.getLength();
                    for (int idx = 0; idx < length; ++idx) {
                        descendents.add(sublist.item(idx));
                    }
                }
            }
        }
        return new NodeListImpl(descendents);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getTagName() {
        return this.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) {
        String normalName = this.normalizeAttributeName(name);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attributes = this.attributes;
            return attributes == null ? false : attributes.containsKey(normalName);
        }
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attributes = this.attributes;
            if (attributes == null) {
                return;
            }
            attributes.remove(normalName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        String normalName = this.normalizeAttributeName(oldAttr.getName());
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map attributes = this.attributes;
            if (attributes == null) {
                return null;
            }
            String oldValue = (String)attributes.remove(normalName);
            Attr attr = oldValue == null ? null : this.getAttr(normalName, oldValue);
            return attr;
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected void assignAttributeField(String normalName, String value) {
        boolean isName = false;
        if ("id".equals(normalName) || (isName = "name".equals(normalName))) {
            String oldId = this.id;
            this.id = value;
            HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
            if (document != null) {
                if (oldId != null) {
                    document.removeElementById(oldId);
                }
                document.setElementById(value, this);
                if (isName) {
                    String oldName = this.getAttribute("name");
                    if (oldName != null) {
                        document.removeNamedItem(oldName);
                    }
                    document.setNamedItem(value, this);
                }
            }
        }
    }

    protected final String normalizeAttributeName(String name) {
        return name.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, String value) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            HashMap<String, String> attribs = this.attributes;
            if (attribs == null) {
                this.attributes = attribs = new HashMap<String, String>(2);
            }
            attribs.put(normalName, value);
        }
        this.assignAttributeField(normalName, value);
    }

    public void setAttributeImpl(String name, String value) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        HashMap<String, String> attribs = this.attributes;
        if (attribs == null) {
            this.attributes = attribs = new HashMap<String, String>(2);
        }
        this.assignAttributeField(normalName, value);
        attribs.put(normalName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        String normalName = this.normalizeAttributeName(newAttr.getName());
        String value = newAttr.getValue();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(normalName, value);
        }
        this.assignAttributeField(normalName, value);
        return newAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        String normalName = this.normalizeAttributeName(name);
        if (!"id".equals(normalName)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        String normalName = this.normalizeAttributeName(idAttr.getName());
        if (!"id".equals(normalName)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRawInnerText(boolean includeComment) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                StringBuffer sb2 = null;
                while (i10.hasNext()) {
                    Comment cn2;
                    String txt;
                    Object node = i10.next();
                    if (node instanceof Text) {
                        Text tn2 = (Text)node;
                        txt = tn2.getNodeValue();
                        if ("".equals(txt)) continue;
                        if (sb2 == null) {
                            sb2 = new StringBuffer();
                        }
                        sb2.append(txt);
                        continue;
                    }
                    if (node instanceof ElementImpl) {
                        ElementImpl en2 = (ElementImpl)node;
                        txt = en2.getRawInnerText(includeComment);
                        if ("".equals(txt)) continue;
                        if (sb2 == null) {
                            sb2 = new StringBuffer();
                        }
                        sb2.append(txt);
                        continue;
                    }
                    if (!includeComment || !(node instanceof Comment) || "".equals(txt = (cn2 = (Comment)node).getNodeValue())) continue;
                    if (sb2 == null) {
                        sb2 = new StringBuffer();
                    }
                    sb2.append(txt);
                }
                return sb2 == null ? "" : sb2.toString();
            }
            return "";
        }
    }

    public String toString() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append(this.getNodeName());
        sb2.append(" [");
        NamedNodeMap attribs = this.getAttributes();
        int length = attribs.getLength();
        for (int i10 = 0; i10 < length; ++i10) {
            Attr attr = (Attr)attribs.item(i10);
            sb2.append(attr.getNodeName());
            sb2.append('=');
            sb2.append(attr.getNodeValue());
            if (i10 + 1 >= length) continue;
            sb2.append(',');
        }
        sb2.append("]");
        return sb2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText() {
        StringBuffer buffer = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendInnerTextImpl(buffer);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerText(String newText) {
        Document document = this.document;
        if (document == null) {
            this.warn("setInnerText(): Element " + this + " does not belong to a document.");
            return;
        }
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                nl2.clear();
            }
        }
        Text textNode = document.createTextNode(newText);
        this.appendChild(textNode);
    }

    protected void appendInnerTextImpl(StringBuffer buffer) {
        ArrayList nl2 = this.nodeList;
        if (nl2 == null) {
            return;
        }
        int size = nl2.size();
        if (size == 0) {
            return;
        }
        for (int i10 = 0; i10 < size; ++i10) {
            Node child = (Node)nl2.get(i10);
            if (child instanceof ElementImpl) {
                ((ElementImpl)child).appendInnerTextImpl(buffer);
            }
            if (child instanceof Comment || !(child instanceof Text)) continue;
            buffer.append(((Text)child).getTextContent());
        }
    }

    protected Node createSimilarNode() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        return doc == null ? null : doc.createElement(this.getTagName());
    }
}

