/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ClassUtil {
    private static final int TYPE_NOT_FOUND = 10008;
    private static final int UNEXPECTED_TYPE = 10009;
    private static final int CANNOT_CREATE_TYPE = 10010;
    private static final int SECURITY_ERROR = 10011;
    private static final int UNKNOWN_ERROR = 10012;

    private ClassUtil() {
    }

    public static Class createClass(String type) {
        return ClassUtil.createClass(type, null);
    }

    public static Class createClass(String type, ClassLoader loader) {
        try {
            if (type != null) {
                type = type.trim();
            }
            if (loader == null) {
                return Class.forName(type);
            }
            return Class.forName(type, true, loader);
        }
        catch (ClassNotFoundException cnf) {
            MessageException ex2 = new MessageException();
            ex2.setMessage(10008, new Object[]{type});
            ex2.setDetails(10008, "0", new Object[]{type});
            ex2.setCode("Server.ResourceUnavailable");
            throw ex2;
        }
    }

    public static Object createDefaultInstance(Class cls, Class expectedInstance) {
        String type = cls.getName();
        try {
            Object instance = cls.newInstance();
            if (expectedInstance != null && !expectedInstance.isInstance(instance)) {
                MessageException ex2 = new MessageException();
                ex2.setMessage(10009, new Object[]{instance.getClass().getName(), expectedInstance.getName()});
                ex2.setCode("Server.ResourceUnavailable");
                throw ex2;
            }
            return instance;
        }
        catch (IllegalAccessException ia) {
            boolean details = false;
            StringBuffer message = new StringBuffer("Unable to create a new instance of type ");
            message.append(type);
            if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                details = true;
            }
            MessageException ex3 = new MessageException();
            ex3.setMessage(10010, new Object[]{type});
            if (details) {
                ex3.setDetails(10010, "0");
            }
            ex3.setCode("Server.ResourceUnavailable");
            throw ex3;
        }
        catch (InstantiationException ine) {
            String variant = null;
            if (cls != null) {
                if (cls.isInterface()) {
                    variant = "1";
                } else if (ClassUtil.isAbstract(cls)) {
                    variant = "2";
                } else if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                    variant = "3";
                }
            }
            MessageException ex4 = new MessageException();
            ex4.setMessage(10010, new Object[]{type});
            if (variant != null) {
                ex4.setDetails(10010, variant);
            }
            ex4.setCode("Server.ResourceUnavailable");
            throw ex4;
        }
        catch (SecurityException se2) {
            MessageException ex5 = new MessageException();
            ex5.setMessage(10011, new Object[]{type});
            ex5.setCode("Server.ResourceUnavailable");
            ex5.setRootCause(se2);
            throw ex5;
        }
        catch (Exception e10) {
            MessageException ex6 = new MessageException();
            ex6.setMessage(10012, new Object[]{type});
            ex6.setCode("Server.ResourceUnavailable");
            ex6.setRootCause(e10);
            throw ex6;
        }
    }

    public static boolean isAbstract(Class cls) {
        boolean abs = false;
        try {
            if (cls != null) {
                int mod = cls.getModifiers();
                abs = Modifier.isAbstract(mod);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return abs;
    }

    public static boolean hasValidDefaultConstructor(Class cls) {
        boolean valid = false;
        try {
            if (cls != null) {
                Constructor c10 = cls.getConstructor(new Class[0]);
                int mod = c10.getModifiers();
                valid = Modifier.isPublic(mod);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return valid;
    }

    public static String classLoaderToString(ClassLoader cl2) {
        if (cl2 == null) {
            return "null";
        }
        if (cl2 == ClassLoader.getSystemClassLoader()) {
            return "system";
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append("hashCode: " + System.identityHashCode(cl2) + " (parent " + ClassUtil.classLoaderToString(cl2.getParent()) + ")");
        return sb2.toString();
    }
}

