/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.ObjectTrace;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.PrettyPrinter;
import flex.messaging.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class BasicPrettyPrinter
implements PrettyPrinter {
    protected ObjectTrace trace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettify(Object o10) {
        try {
            this.trace = new ObjectTrace();
            this.internalPrettify(o10);
            String string = this.trace.toString();
            return string;
        }
        catch (Throwable t10) {
            String string = this.trace.toString();
            return string;
        }
        finally {
            this.trace = null;
        }
    }

    protected void internalPrettify(Object o10) {
        if (o10 == null) {
            this.trace.writeNull();
        } else if (o10 instanceof String) {
            String string = (String)o10;
            if (string.startsWith("<?xml")) {
                this.trace.write(StringUtils.prettifyXML(string));
            } else {
                this.trace.write(string);
            }
        } else if (o10 instanceof Number || o10 instanceof Boolean || o10 instanceof Date || o10 instanceof Calendar || o10 instanceof Character) {
            this.trace.write(o10);
        } else {
            this.prettifyComplexType(o10);
        }
    }

    protected void prettifyComplexType(Object o10) {
        StringBuffer header = new StringBuffer();
        if (o10 instanceof PrettyPrintable) {
            PrettyPrintable pp2 = (PrettyPrintable)o10;
            header.append(pp2.toStringHeader());
        }
        Class<?> c10 = o10.getClass();
        String className = c10.getName();
        if (o10 instanceof Collection) {
            header.append(className).append(" (Collection size:").append(((Collection)o10).size()).append(")");
        } else if (o10 instanceof Map) {
            header.append(className).append(" (Map size:").append(((Map)o10).size()).append(")");
        } else if (c10.isArray() && c10.getComponentType() != null) {
            Class<?> componentType = c10.getComponentType();
            className = componentType.getName();
            header.append(className).append("[] (Array length:").append(Array.getLength(o10)).append(")");
        } else {
            header.append(className);
        }
        this.trace.startObject(header.toString());
        this.trace.endObject();
    }

    protected boolean hasCustomToStringMethod(Class c10) {
        try {
            Method toStringMethod = c10.getMethod("toString", null);
            Class<?> declaringClass = toStringMethod.getDeclaringClass();
            if (declaringClass != Object.class && !declaringClass.getName().startsWith("java.util")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Object copy() {
        return new BasicPrettyPrinter();
    }
}

