/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amfx.AmfxOutput;
import flex.messaging.io.amfx.AmfxTypes;
import java.io.IOException;
import java.io.OutputStream;

public class AmfxMessageSerializer
implements MessageSerializer,
AmfxTypes {
    protected AmfxOutput amfxOut;
    protected int version;
    protected boolean isDebug;
    protected AmfTrace debugTrace;
    public static final String XML_DIRECTIVE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";

    public void setVersion(int value) {
        this.version = value;
    }

    public void initialize(SerializationContext context, OutputStream out, AmfTrace trace) {
        this.amfxOut = new AmfxOutput(context);
        this.amfxOut.setOutputStream(out);
        this.debugTrace = trace;
        this.isDebug = this.debugTrace != null;
        this.amfxOut.setDebugTrace(trace);
    }

    public void writeMessage(ActionMessage m10) throws IOException {
        if (this.isDebug) {
            this.debugTrace.startResponse("Serializing AMFX/HTTP response");
        }
        this.amfxOut.writeUTF(XML_DIRECTIVE);
        int version = m10.getVersion();
        this.writeOpenAMFX(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = m10.getHeaderCount();
        for (int i10 = 0; i10 < headerCount; ++i10) {
            MessageHeader header = m10.getHeader(i10);
            if (this.isDebug) {
                this.debugTrace.startHeader(header.getName(), header.getMustUnderstand(), i10);
            }
            this.writeHeader(header);
            if (!this.isDebug) continue;
            this.debugTrace.endHeader();
        }
        int bodyCount = m10.getBodyCount();
        for (int i11 = 0; i11 < bodyCount; ++i11) {
            MessageBody body = m10.getBody(i11);
            if (this.isDebug) {
                this.debugTrace.startMessage(body.getTargetURI(), body.getResponseURI(), i11);
            }
            this.writeBody(body);
            if (!this.isDebug) continue;
            this.debugTrace.endMessage();
        }
        this.writeCloseAMFX();
        if (this.isDebug) {
            this.debugTrace.endMessage();
        }
    }

    protected void writeOpenAMFX(int version) throws IOException {
        int buflen = 14;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<").append("amfx").append(" ver=\"");
        sb2.append(version);
        sb2.append("\">");
        this.amfxOut.writeUTF(sb2);
    }

    protected void writeCloseAMFX() throws IOException {
        this.amfxOut.writeUTF("</amfx>");
    }

    protected void writeHeader(MessageHeader h10) throws IOException {
        int buflen = 127;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<").append("header").append(" name=\"");
        sb2.append(h10.getName());
        sb2.append("\"");
        if (h10.getMustUnderstand()) {
            sb2.append(" mustUnderstand=\"");
            sb2.append(h10.getMustUnderstand());
            sb2.append("\"");
        }
        sb2.append(">");
        this.amfxOut.writeUTF(sb2);
        this.writeObject(h10.getData());
        this.amfxOut.writeUTF("</header>");
    }

    protected void writeBody(MessageBody b10) throws IOException {
        if (b10.getTargetURI() == null && b10.getResponseURI() == null) {
            this.amfxOut.writeUTF("<body>");
        } else {
            int buflen = 127;
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<").append("body");
            if (b10.getTargetURI() != null) {
                sb2.append(" targetURI=\"").append(b10.getTargetURI()).append("\"");
            }
            if (b10.getResponseURI() != null) {
                sb2.append(" responseURI=\"").append(b10.getResponseURI()).append("\"");
            }
            sb2.append(">");
            this.amfxOut.writeUTF(sb2);
        }
        Object data = b10.getData();
        this.writeObject(data);
        this.amfxOut.writeUTF("</body>");
    }

    public void writeObject(Object value) throws IOException {
        this.amfxOut.writeObject(value);
    }
}

