/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.Hex;
import flex.messaging.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

public class AmfxInput {
    private SerializationContext context;
    private BeanProxy beanproxy = new BeanProxy();
    private final ArrayList objectTable;
    private final ArrayList stringTable;
    private final ArrayList traitsTable;
    private StringBuffer text;
    private ActionMessage message;
    private MessageHeader currentHeader;
    private MessageBody currentBody;
    private Stack objectStack;
    private Stack proxyStack;
    private Stack arrayPropertyStack;
    private Stack ecmaArrayIndexStack;
    private Stack strictArrayIndexStack;
    private Stack traitsStack;
    private boolean isStringReference;
    private boolean isTraitProperty;
    protected boolean isDebug;
    protected AmfTrace trace;

    public AmfxInput(SerializationContext context) {
        this.context = context;
        this.stringTable = new ArrayList(64);
        this.objectTable = new ArrayList(64);
        this.traitsTable = new ArrayList(10);
        this.objectStack = new Stack();
        this.proxyStack = new Stack();
        this.arrayPropertyStack = new Stack();
        this.strictArrayIndexStack = new Stack();
        this.ecmaArrayIndexStack = new Stack();
        this.traitsStack = new Stack();
        this.text = new StringBuffer(32);
    }

    public void reset() {
        this.stringTable.clear();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.objectStack.clear();
        this.proxyStack.clear();
        this.arrayPropertyStack.clear();
        this.traitsStack.clear();
        this.currentBody = null;
        this.currentHeader = null;
        TypeMarshallingContext marshallingContext = TypeMarshallingContext.getTypeMarshallingContext();
        marshallingContext.reset();
    }

    public void setDebugTrace(AmfTrace trace) {
        this.trace = trace;
        this.isDebug = this.trace != null;
    }

    public void setActionMessage(ActionMessage msg) {
        this.message = msg;
    }

    public Object readObject() throws IOException {
        return null;
    }

    public void text(String s10) {
        this.text.append(s10);
    }

    public void start_amfx(Attributes attributes) {
        String ver = attributes.getValue("ver");
        int version = 3;
        if (ver != null) {
            try {
                version = Integer.parseInt(ver);
            }
            catch (NumberFormatException ex2) {
                throw new MessageException("Unknown version: " + ver);
            }
        }
        if (this.isDebug) {
            this.trace.version(version);
        }
        this.message.setVersion(version);
    }

    public void end_amfx() {
    }

    public void start_header(Attributes attributes) {
        if (this.currentHeader != null || this.currentBody != null) {
            throw new MessageException("Unexpected header tag.");
        }
        this.currentHeader = new MessageHeader();
        String name = attributes.getValue("name");
        this.currentHeader.setName(name);
        String mu2 = attributes.getValue("mustUnderstand");
        boolean mustUnderstand = false;
        if (mu2 != null) {
            mustUnderstand = Boolean.valueOf(mu2);
            this.currentHeader.setMustUnderstand(mustUnderstand);
        }
        if (this.isDebug) {
            this.trace.startHeader(name, mustUnderstand, this.message.getHeaderCount());
        }
    }

    public void end_header() {
        this.message.addHeader(this.currentHeader);
        this.currentHeader = null;
        if (this.isDebug) {
            this.trace.endHeader();
        }
    }

    public void start_body(Attributes attributes) {
        if (this.currentBody != null || this.currentHeader != null) {
            throw new MessageException("Unexpected body tag.");
        }
        this.currentBody = new MessageBody();
        String targetURI = attributes.getValue("targetURI");
        this.currentBody.setTargetURI(targetURI);
        String responseURI = attributes.getValue("responseURI");
        this.currentBody.setResponseURI(responseURI);
        if (this.isDebug) {
            this.trace.startMessage(targetURI, responseURI, this.message.getBodyCount());
        }
    }

    public void end_body() {
        this.message.addBody(this.currentBody);
        this.currentBody = null;
        if (this.isDebug) {
            this.trace.endMessage();
        }
    }

    public void start_array(Attributes attributes) {
        String ecma;
        boolean isECMA;
        int length = 10;
        String len = attributes.getValue("length");
        if (len != null) {
            try {
                len = len.trim();
                length = Integer.parseInt(len);
                if (length < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex2) {
                throw new MessageException("Invalid array length: " + len);
            }
        }
        Object array = (isECMA = "true".equalsIgnoreCase(ecma = attributes.getValue("ecma"))) ? new HashMap() : (this.context.legacyCollection ? new ArrayList(length) : new Object[length]);
        this.setValue(array);
        this.ecmaArrayIndexStack.push(new int[]{0});
        this.strictArrayIndexStack.push(new int[]{0});
        this.objectTable.add(array);
        this.objectStack.push(array);
        this.proxyStack.push(null);
        if (isECMA) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.objectTable.size() - 1);
            }
        } else if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
    }

    public void end_array() {
        try {
            this.objectStack.pop();
            this.proxyStack.pop();
            this.ecmaArrayIndexStack.pop();
            this.strictArrayIndexStack.pop();
        }
        catch (EmptyStackException ex2) {
            throw new MessageException("Unexpected end of array");
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    public void start_bytearray(Attributes attributes) {
        this.text.delete(0, this.text.length());
    }

    public void end_bytearray() {
        String bs2 = this.text.toString().trim();
        Hex.Decoder decoder = new Hex.Decoder();
        decoder.decode(bs2);
        byte[] value = decoder.drain();
        this.setValue(value);
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, bs2.length());
        }
    }

    public void start_date(Attributes attributes) {
        this.text.delete(0, this.text.length());
    }

    public void end_date() {
        String d10 = this.text.toString().trim();
        try {
            long l10 = Long.parseLong(d10);
            Date date = new Date(l10);
            this.setValue(date);
            this.objectTable.add(date);
            if (this.isDebug) {
                this.trace.write(date);
            }
        }
        catch (NumberFormatException ex2) {
            throw new MessageException("Invalid date: " + d10);
        }
    }

    public void start_double(Attributes attributes) {
        this.text.delete(0, this.text.length());
    }

    public void end_double() {
        String ds2 = this.text.toString().trim();
        try {
            Double d10 = Double.valueOf(ds2);
            this.setValue(d10);
            if (this.isDebug) {
                this.trace.write(d10);
            }
        }
        catch (NumberFormatException ex2) {
            throw new MessageException("Invalid double: " + ds2);
        }
    }

    public void start_false(Attributes attributes) {
        this.setValue(Boolean.FALSE);
        if (this.isDebug) {
            this.trace.write(false);
        }
    }

    public void end_false() {
    }

    public void start_item(Attributes attributes) {
        String name = attributes.getValue("name");
        if (name != null) {
            if ((name = name.trim()).length() <= 0) {
                throw new MessageException("Array item names cannot be the empty string.");
            }
            char c10 = name.charAt(0);
            if (!Character.isLetterOrDigit(c10) && c10 != '_') {
                throw new MessageException("Invalid item name: " + name + ". Array item names must start with a letter, a digit or the underscore '_' character.");
            }
        } else {
            throw new MessageException("Array item must have a name attribute.");
        }
        Object o10 = this.objectStack.peek();
        if (!(o10 instanceof Map)) {
            throw new MessageException("Unexpected array item name: " + name + ". Please set the ecma attribute to 'true'.");
        }
        this.arrayPropertyStack.push(name);
    }

    public void end_item() {
        this.arrayPropertyStack.pop();
    }

    public void start_int(Attributes attributes) {
        this.text.delete(0, this.text.length());
    }

    public void end_int() {
        String is2 = this.text.toString().trim();
        try {
            Integer i10 = Integer.valueOf(is2);
            this.setValue(i10);
            if (this.isDebug) {
                this.trace.write(i10);
            }
        }
        catch (NumberFormatException ex2) {
            throw new MessageException("Invalid int: " + is2);
        }
    }

    public void start_null(Attributes attributes) {
        this.setValue(null);
        if (this.isDebug) {
            this.trace.writeNull();
        }
    }

    public void end_null() {
    }

    public void start_object(Attributes attributes) {
        Object object;
        PropertyProxy proxy = null;
        String type = attributes.getValue("type");
        if (type != null) {
            type = type.trim();
        }
        if (type != null && type.length() > 0) {
            String aliasedClass = ClassAliasRegistry.getRegistry().getClassName(type);
            if (aliasedClass != null) {
                type = aliasedClass;
            }
            if (type == null || type.length() == 0) {
                object = new ASObject();
            } else if (type.startsWith(">")) {
                object = new ASObject();
                ((ASObject)object).setType(type);
            } else if (this.context.instantiateTypes || type.startsWith("flex.")) {
                Class desiredClass = AbstractProxy.getClassFromClassName(type, this.context.createASObjectForMissingType);
                proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(desiredClass);
                object = proxy == null ? ClassUtil.createDefaultInstance(desiredClass, null) : proxy.createInstance(type);
            } else {
                object = new ASObject();
                ((ASObject)object).setType(type);
            }
        } else {
            object = new ASObject(type);
        }
        if (proxy == null) {
            proxy = PropertyProxyRegistry.getProxyAndRegister(object);
        }
        this.objectStack.push(object);
        this.proxyStack.push(proxy);
        this.objectTable.add(object);
        if (this.isDebug) {
            this.trace.startAMFObject(type, this.objectTable.size() - 1);
        }
    }

    public void end_object() {
        Object obj;
        if (!this.traitsStack.empty()) {
            this.traitsStack.pop();
        }
        if (!this.objectStack.empty()) {
            Object newObj;
            obj = this.objectStack.pop();
            PropertyProxy proxy = (PropertyProxy)this.proxyStack.pop();
            Object object = newObj = proxy == null ? obj : proxy.instanceComplete(obj);
            if (newObj != obj) {
                int i10;
                for (i10 = 0; i10 < this.objectTable.size() && this.objectTable.get(i10) != obj; ++i10) {
                }
                if (i10 != this.objectTable.size()) {
                    this.objectTable.set(i10, newObj);
                }
                obj = newObj;
            }
        } else {
            throw new MessageException("Unexpected end of object.");
        }
        this.setValue(obj);
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start_ref(Attributes attributes) {
        String id2 = attributes.getValue("id");
        if (id2 == null) throw new MessageException("Unknown object reference: " + id2);
        try {
            int i10 = Integer.parseInt(id2);
            Object o10 = this.objectTable.get(i10);
            this.setValue(o10);
            if (!this.isDebug) return;
            this.trace.writeRef(i10);
            return;
        }
        catch (NumberFormatException ex2) {
            throw new MessageException("Invalid object reference: " + id2);
        }
        catch (IndexOutOfBoundsException ex3) {
            throw new MessageException("Unknown object reference: " + id2);
        }
    }

    public void end_ref() {
    }

    public void start_string(Attributes attributes) {
        String id2 = attributes.getValue("id");
        if (id2 != null) {
            this.isStringReference = true;
            try {
                int i10 = Integer.parseInt(id2);
                String s10 = (String)this.stringTable.get(i10);
                if (this.isTraitProperty) {
                    TraitsContext traitsContext = (TraitsContext)this.traitsStack.peek();
                    traitsContext.add(s10);
                }
                this.setValue(s10);
            }
            catch (NumberFormatException ex2) {
                throw new MessageException("Invalid string reference: " + id2);
            }
            catch (IndexOutOfBoundsException ex3) {
                throw new MessageException("Unknown string reference: " + id2);
            }
        } else {
            this.text.delete(0, this.text.length());
            this.isStringReference = false;
        }
    }

    public void end_string() {
        if (!this.isStringReference) {
            String s10 = this.text.toString();
            if (s10.length() > 0) {
                if (!this.isTraitProperty) {
                    s10 = this.unescapeCloseCDATA(s10);
                }
                this.stringTable.add(s10);
            }
            if (this.isTraitProperty) {
                TraitsContext traitsContext = (TraitsContext)this.traitsStack.peek();
                traitsContext.add(s10);
            } else {
                this.setValue(s10);
                if (this.isDebug) {
                    this.trace.writeString(s10);
                }
            }
        }
    }

    public void start_traits(Attributes attributes) {
        if (!this.objectStack.empty()) {
            ArrayList<String> traitsList = new ArrayList<String>();
            TraitsContext traitsContext = new TraitsContext(traitsList);
            this.traitsStack.push(traitsContext);
            String id2 = attributes.getValue("id");
            if (id2 != null) {
                try {
                    int i10 = Integer.parseInt(id2);
                    List l10 = (List)this.traitsTable.get(i10);
                    for (String prop : l10) {
                        traitsList.add(prop);
                    }
                }
                catch (NumberFormatException ex2) {
                    throw new MessageException("Invalid traits reference: " + id2);
                }
                catch (IndexOutOfBoundsException ex3) {
                    throw new MessageException("Unknown traits reference: " + id2);
                }
            } else {
                boolean externalizable = false;
                String ext = attributes.getValue("externalizable");
                if (ext != null) {
                    externalizable = "true".equals(ext.trim());
                }
                Object obj = this.objectStack.peek();
                if (externalizable && !(obj instanceof Externalizable)) {
                    SerializationException ex4 = new SerializationException();
                    ex4.setMessage(10305, new Object[]{obj.getClass().getName()});
                    throw ex4;
                }
                this.traitsTable.add(traitsList);
            }
        } else {
            throw new MessageException("Unexpected traits");
        }
        this.isTraitProperty = true;
    }

    public void end_traits() {
        this.isTraitProperty = false;
    }

    public void start_true(Attributes attributes) {
        this.setValue(Boolean.TRUE);
        if (this.isDebug) {
            this.trace.write(true);
        }
    }

    public void end_true() {
    }

    public void start_undefined(Attributes attributes) {
        this.setValue(null);
        if (this.isDebug) {
            this.trace.writeUndefined();
        }
    }

    public void end_undefined() {
    }

    public void start_xml(Attributes attributes) {
        this.text.delete(0, this.text.length());
    }

    public void end_xml() {
        String xml = this.text.toString();
        xml = this.unescapeCloseCDATA(xml);
        Document value = XMLUtil.stringToDocument(xml, !this.context.legacyXMLNamespaces);
        this.setValue(value);
    }

    private String unescapeCloseCDATA(String s10) {
        if (s10.length() > 5 && s10.indexOf("]]&gt;") != -1) {
            s10 = s10.replaceAll("]]&gt;", "]]>");
        }
        return s10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setValue(Object value) {
        String prop;
        if (this.objectStack.empty()) {
            if (this.currentHeader != null) {
                this.currentHeader.setData(value);
                return;
            }
            if (this.currentBody == null) throw new MessageException("Unexpected value: " + value);
            this.currentBody.setData(value);
            return;
        }
        Object obj = this.objectStack.peek();
        if (obj instanceof Externalizable) {
            if (value == null) throw new MessageException("Error while reading Externalizable class. Value must be a byte array.");
            if (!value.getClass().isArray()) throw new MessageException("Error while reading Externalizable class. Value must be a byte array.");
            if (!Byte.TYPE.equals(value.getClass().getComponentType())) throw new MessageException("Error while reading Externalizable class. Value must be a byte array.");
            Externalizable extern = (Externalizable)obj;
            Amf3Input objIn = new Amf3Input(this.context);
            byte[] ba = (byte[])value;
            ByteArrayInputStream baIn = new ByteArrayInputStream(ba);
            try {
                try {
                    objIn.setInputStream(baIn);
                    extern.readExternal(objIn);
                }
                catch (ClassNotFoundException ex3) {
                    throw new MessageException("Error while reading Externalizable class " + extern.getClass().getName(), ex3);
                }
                catch (IOException ex4) {
                    throw new MessageException("Error while reading Externalizable class " + extern.getClass().getName(), ex4);
                }
                Object var9_23 = null;
            }
            catch (Throwable throwable) {
                Object var9_24 = null;
                try {
                    objIn.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex2) {}
            objIn.close();
            return;
        }
        if (obj instanceof ASObject) {
            String prop2;
            TraitsContext traitsContext = (TraitsContext)this.traitsStack.peek();
            try {
                prop2 = traitsContext.next();
            }
            catch (IndexOutOfBoundsException ex5) {
                throw new MessageException("Object has no trait info for value: " + value);
            }
            ASObject aso = (ASObject)obj;
            aso.put(prop2, value);
            if (!this.isDebug) return;
            this.trace.namedElement(prop2);
            return;
        }
        if (obj instanceof ArrayList && !(obj instanceof ArrayCollection)) {
            ArrayList list = (ArrayList)obj;
            list.add(value);
            if (!this.isDebug) return;
            this.trace.arrayElement(list.size() - 1);
            return;
        }
        if (obj.getClass().isArray()) {
            if (this.strictArrayIndexStack.empty()) return;
            int[] indexObj = (int[])this.strictArrayIndexStack.peek();
            int index = indexObj[0];
            if (Array.getLength(obj) <= index) throw new MessageException("Index out of bounds at: " + index + " cannot set array value: " + value + "");
            Array.set(obj, index, value);
            indexObj[0] = indexObj[0] + 1;
            return;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (!this.arrayPropertyStack.empty()) {
                String prop3 = (String)this.arrayPropertyStack.peek();
                map.put(prop3, value);
                if (!this.isDebug) return;
                this.trace.namedElement(prop3);
                return;
            }
            if (this.ecmaArrayIndexStack.empty()) return;
            int[] index = (int[])this.ecmaArrayIndexStack.peek();
            String prop4 = String.valueOf(index[0]);
            index[0] = index[0] + 1;
            map.put(prop4, value);
            if (!this.isDebug) return;
            this.trace.namedElement(prop4);
            return;
        }
        TraitsContext traitsContext = (TraitsContext)this.traitsStack.peek();
        try {
            prop = traitsContext.next();
        }
        catch (IndexOutOfBoundsException ex6) {
            throw new MessageException("Object has no trait info for value: " + value, ex6);
        }
        try {
            PropertyProxy proxy = (PropertyProxy)this.proxyStack.peek();
            if (proxy == null) {
                proxy = this.beanproxy;
            }
            proxy.setValue(obj, prop, value);
        }
        catch (Exception ex7) {
            throw new MessageException("Failed to set property '" + prop + "' with value: " + value, ex7);
        }
        if (!this.isDebug) return;
        this.trace.namedElement(prop);
    }

    private class TraitsContext {
        private List traits;
        private int counter;

        private TraitsContext(List traits) {
            this.traits = traits;
        }

        private void add(String trait) {
            if ((trait = trait.trim()).length() <= 0) {
                throw new MessageException("Traits cannot be the empty string.");
            }
            char c10 = trait.charAt(0);
            if (!Character.isLetterOrDigit(c10) && c10 != '_') {
                throw new MessageException("Invalid trait name: " + trait + ". Object property names must start with a letter, a digit or the underscore '_' character.");
            }
            this.traits.add(trait);
        }

        private String next() {
            String trait = (String)this.traits.get(this.counter);
            ++this.counter;
            return trait;
        }
    }
}

