/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.Amf0Output;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import java.io.IOException;
import java.io.OutputStream;

public class AmfMessageSerializer
implements MessageSerializer {
    public static final int UNKNOWN_CONTENT_LENGTH = -1;
    protected Amf0Output amfOut;
    protected boolean isDebug;
    protected AmfTrace debugTrace;
    protected int version;

    public void setVersion(int value) {
        this.version = value;
    }

    public void initialize(SerializationContext context, OutputStream out, AmfTrace trace) {
        this.amfOut = new Amf0Output(context);
        this.amfOut.setOutputStream(out);
        this.amfOut.setAvmPlus(this.version >= 3);
        this.debugTrace = trace;
        this.isDebug = trace != null;
        this.amfOut.setDebugTrace(this.debugTrace);
    }

    public void writeMessage(ActionMessage m10) throws IOException {
        int version;
        if (this.isDebug) {
            this.debugTrace.startResponse("Serializing AMF/HTTP response");
        }
        this.amfOut.setAvmPlus((version = m10.getVersion()) >= 3);
        this.amfOut.writeShort(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = m10.getHeaderCount();
        this.amfOut.writeShort(headerCount);
        for (int i10 = 0; i10 < headerCount; ++i10) {
            MessageHeader header = m10.getHeader(i10);
            if (this.isDebug) {
                this.debugTrace.startHeader(header.getName(), header.getMustUnderstand(), i10);
            }
            this.writeHeader(header);
            if (!this.isDebug) continue;
            this.debugTrace.endHeader();
        }
        int bodyCount = m10.getBodyCount();
        this.amfOut.writeShort(bodyCount);
        for (int i11 = 0; i11 < bodyCount; ++i11) {
            MessageBody body = m10.getBody(i11);
            if (this.isDebug) {
                this.debugTrace.startMessage(body.getTargetURI(), body.getResponseURI(), i11);
            }
            this.writeBody(body);
            if (!this.isDebug) continue;
            this.debugTrace.endMessage();
        }
    }

    public void writeHeader(MessageHeader h10) throws IOException {
        this.amfOut.writeUTF(h10.getName());
        this.amfOut.writeBoolean(h10.getMustUnderstand());
        this.amfOut.writeInt(-1);
        this.amfOut.reset();
        this.writeObject(h10.getData());
    }

    public void writeBody(MessageBody b10) throws IOException {
        if (b10.getTargetURI() == null) {
            this.amfOut.writeUTF("null");
        } else {
            this.amfOut.writeUTF(b10.getTargetURI());
        }
        if (b10.getResponseURI() == null) {
            this.amfOut.writeUTF("null");
        } else {
            this.amfOut.writeUTF(b10.getResponseURI());
        }
        this.amfOut.writeInt(-1);
        this.amfOut.reset();
        Object data = b10.getData();
        this.writeObject(data);
    }

    public void writeObject(Object value) throws IOException {
        this.amfOut.writeObject(value);
    }
}

