/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.RecoverableSerializationException;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.Amf0Input;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import java.io.IOException;
import java.io.InputStream;

public class AmfMessageDeserializer
implements MessageDeserializer {
    private static final int UNSUPPORTED_AMF_VERSION = 10310;
    protected ActionMessageInput amfIn;
    protected AmfTrace debugTrace;
    protected boolean isDebug;

    public void initialize(SerializationContext context, InputStream in2, AmfTrace trace) {
        this.amfIn = new Amf0Input(context);
        this.amfIn.setInputStream(in2);
        this.debugTrace = trace;
        this.isDebug = this.debugTrace != null;
        this.amfIn.setDebugTrace(this.debugTrace);
    }

    public void readMessage(ActionMessage m10, ActionContext context) throws ClassNotFoundException, IOException {
        int version;
        if (this.isDebug) {
            this.debugTrace.startRequest("Deserializing AMF/HTTP request");
        }
        if ((version = this.amfIn.readUnsignedShort()) == 1) {
            version = 0;
        }
        if (version != 0 && version != 3) {
            MessageException ex2 = new MessageException();
            ex2.setMessage(10310, new Object[]{new Integer(version)});
            ex2.setCode("VersionMismatch");
            throw ex2;
        }
        m10.setVersion(version);
        context.setVersion(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = this.amfIn.readUnsignedShort();
        for (int i10 = 0; i10 < headerCount; ++i10) {
            MessageHeader header = new MessageHeader();
            m10.addHeader(header);
            this.readHeader(header, i10);
        }
        int bodyCount = this.amfIn.readUnsignedShort();
        for (int i11 = 0; i11 < bodyCount; ++i11) {
            MessageBody body = new MessageBody();
            m10.addBody(body);
            this.readBody(body, i11);
        }
    }

    public void readHeader(MessageHeader header, int index) throws ClassNotFoundException, IOException {
        Object data;
        String name = this.amfIn.readUTF();
        header.setName(name);
        boolean mustUnderstand = this.amfIn.readBoolean();
        header.setMustUnderstand(mustUnderstand);
        this.amfIn.readInt();
        this.amfIn.reset();
        if (this.isDebug) {
            this.debugTrace.startHeader(name, mustUnderstand, index);
        }
        try {
            data = this.readObject();
        }
        catch (RecoverableSerializationException ex2) {
            ex2.setCode("Client.Header.Encoding");
            data = ex2;
        }
        catch (MessageException ex3) {
            ex3.setCode("Client.Header.Encoding");
            throw ex3;
        }
        header.setData(data);
        if (this.isDebug) {
            this.debugTrace.endHeader();
        }
    }

    public void readBody(MessageBody body, int index) throws ClassNotFoundException, IOException {
        Object data;
        String targetURI = this.amfIn.readUTF();
        body.setTargetURI(targetURI);
        String responseURI = this.amfIn.readUTF();
        body.setResponseURI(responseURI);
        this.amfIn.readInt();
        this.amfIn.reset();
        if (this.isDebug) {
            this.debugTrace.startMessage(targetURI, responseURI, index);
        }
        try {
            data = this.readObject();
        }
        catch (RecoverableSerializationException ex2) {
            ex2.setCode("Client.Message.Encoding");
            data = ex2;
        }
        catch (MessageException ex3) {
            ex3.setCode("Client.Message.Encoding");
            throw ex3;
        }
        body.setData(data);
        if (this.isDebug) {
            this.debugTrace.endMessage();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.amfIn.readObject();
    }
}

