/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ArrayList;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PagedRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;

public class PageableRowSetProxy
extends AbstractProxy {
    static final long serialVersionUID = 1121859941216924326L;
    public static final int HUGE_PAGE_SIZE = Integer.MAX_VALUE;
    public static final String AS_TYPE_NAME = "RecordSet";
    public static final Integer RECORD_SET_VERSION = new Integer(1);
    public static final String TOTAL_COUNT = "totalCount";
    public static final String COLUMN_NAMES = "columnNames";
    public static final String INITIAL_DATA = "initialData";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVER_INFO = "serverInfo";
    public static final String VERSION = "version";
    public static final String CURSOR = "cursor";
    public static final String ID = "id";
    public static final List propertyNameCache = new ArrayList();

    public PageableRowSetProxy() {
        super(null);
        this.alias = AS_TYPE_NAME;
    }

    public PageableRowSetProxy(RowSet defaultInstance) {
        super(defaultInstance);
        this.alias = AS_TYPE_NAME;
    }

    public PageableRowSetProxy(PageableRowSet defaultInstance) {
        super(defaultInstance);
        this.alias = AS_TYPE_NAME;
    }

    public String getAlias(Object instance) {
        return AS_TYPE_NAME;
    }

    public List getPropertyNames(Object instance) {
        return propertyNameCache;
    }

    public Class getType(Object instance, String propertyName) {
        if (SERVER_INFO.equals(propertyName)) {
            return HashMap.class;
        }
        return null;
    }

    public Object getValue(Object instance, String propertyName) {
        HashMap<String, Object> value = null;
        if (instance instanceof RowSet) {
            instance = new PagedRowSet((RowSet)instance, Integer.MAX_VALUE, false);
        }
        if (instance instanceof PageableRowSet) {
            PageableRowSet prs = (PageableRowSet)instance;
            if (SERVER_INFO.equals(propertyName)) {
                try {
                    HashMap<String, Object> serverInfo = new HashMap<String, Object>();
                    serverInfo.put(ID, prs.getID());
                    Map pageInfo = prs.getRecords(1, prs.getInitialDownloadCount());
                    serverInfo.put(TOTAL_COUNT, new Integer(prs.getRowCount()));
                    serverInfo.put(INITIAL_DATA, pageInfo.get("Page"));
                    serverInfo.put(CURSOR, pageInfo.get("Cursor"));
                    serverInfo.put(SERVICE_NAME, prs.getServiceName());
                    serverInfo.put(COLUMN_NAMES, prs.getColumnNames());
                    serverInfo.put(VERSION, RECORD_SET_VERSION);
                    value = serverInfo;
                }
                catch (SQLException ex2) {
                    MessageException e10 = new MessageException();
                    e10.setMessage("Error encountered serializing RowSet.");
                    e10.setRootCause(ex2);
                    throw e10;
                }
            }
        }
        return value;
    }

    public void setValue(Object instance, String propertyName, Object value) {
    }

    public Object clone() {
        return super.clone();
    }

    static {
        propertyNameCache.add(SERVER_INFO);
    }
}

