/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.factories;

import flex.messaging.FactoryInstance;
import flex.messaging.FlexConfigurable;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.config.ConfigMap;
import flex.messaging.factories.JavaFactory;
import flex.messaging.util.ClassUtil;

public class JavaFactoryInstance
extends FactoryInstance {
    Object applicationInstance = null;
    Class javaClass = null;
    String attributeId;

    public JavaFactoryInstance(JavaFactory factory, String id2, ConfigMap properties) {
        super(factory, id2, properties);
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setSource(String source) {
        super.setSource(source);
        if (this.javaClass != null) {
            this.javaClass = null;
        }
    }

    public Object createInstance() {
        Object inst = ClassUtil.createDefaultInstance(this.getInstanceClass(), null);
        if (inst instanceof FlexConfigurable) {
            ((FlexConfigurable)inst).initialize(this.getId(), this.getProperties());
        }
        return inst;
    }

    public Class getInstanceClass() {
        if (this.javaClass == null) {
            this.javaClass = ClassUtil.createClass(this.getSource(), FlexContext.getMessageBroker() == null ? this.getClass().getClassLoader() : FlexContext.getMessageBroker().getClassLoader());
        }
        return this.javaClass;
    }

    public void operationComplete(Object instance) {
        FlexSession session;
        if (this.getScope().equalsIgnoreCase("session") && (session = FlexContext.getFlexSession()) != null && session.isValid()) {
            session.setAttribute(this.getAttributeId(), instance);
        }
    }

    public String toString() {
        return "JavaFactory instance for id=" + this.getId() + " source=" + this.getSource() + " scope=" + this.getScope();
    }
}

