/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.amf.SuspendableAMFFilter;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;

public class SuspendableMessageBrokerFilter
extends SuspendableAMFFilter {
    public static final String SUSPEND_PROCESSING_HEADER = "DSSuspendMessageBrokerFilterProcessing";
    private static final int UNHANDLED_ERROR = 10000;
    private static final int UNHANDLED_SERIALIZATION_ERROR = 10306;
    private static final String LOG_CATEGORY = "Message.General";
    protected AbstractEndpoint endpoint;
    protected String endpointLogCategory;
    protected Message inMessage;
    protected MessageBody response;
    protected Message responseMessage;

    public SuspendableMessageBrokerFilter(AbstractEndpoint endpoint, String endpointLogCategory) {
        this.endpoint = endpoint;
        this.endpointLogCategory = endpointLogCategory;
    }

    public void setResponseMessage(Message value) {
        if (!this.isSuspended()) {
            throw new IllegalStateException();
        }
        this.responseMessage = value;
    }

    protected void doInboundFilter(ActionContext context) throws IOException {
        if (this.responseMessage != null) {
            return;
        }
        try {
            MessageBody request = context.getRequestMessageBody();
            this.response = context.getResponseMessageBody();
            Object data = request.getData();
            if (data instanceof List) {
                data = ((List)data).get(0);
            } else if (data.getClass().isArray()) {
                data = Array.get(data, 0);
            }
            if (!(data instanceof Message)) {
                this.inMessage = null;
                throw new MessageException("Request was not of type flex.messaging.messages.Message");
            }
            this.inMessage = (Message)data;
            try {
                CommandMessage command;
                this.endpoint.setupFlexClient(this.inMessage);
                if (!(this.inMessage.getClientId() != null || this.inMessage instanceof CommandMessage && ((CommandMessage)this.inMessage).getOperation() == 2)) {
                    String clientId = UUIDUtils.createUUID();
                    this.inMessage.setClientId(clientId);
                }
                if (this.inMessage instanceof CommandMessage && (command = (CommandMessage)this.inMessage).getOperation() == 2 && context.getRequestMessage().getBodyCount() != 1) {
                    command.setHeader("DSSuppressPollWait", Boolean.TRUE);
                }
                if (context.isMPIenabled()) {
                    MessagePerformanceUtils.setupMPII(context, this.inMessage);
                }
                this.responseMessage = this.endpoint.serviceMessage(this.inMessage);
                if (this.responseMessage.headerExists(SUSPEND_PROCESSING_HEADER)) {
                    this.suspend();
                    this.responseMessage = null;
                    return;
                }
            }
            catch (MessageException e10) {
                context.setStatus(1);
                this.responseMessage = e10.createErrorMessage();
                ((ErrorMessage)this.responseMessage).setCorrelationId(this.inMessage.getMessageId());
                ((ErrorMessage)this.responseMessage).setDestination(this.inMessage.getDestination());
                ((ErrorMessage)this.responseMessage).setClientId(this.inMessage.getClientId());
                e10.logAtHingePoint(this.inMessage, (ErrorMessage)this.responseMessage, null);
            }
            catch (Throwable t10) {
                context.setStatus(1);
                MessageException lme = new MessageException();
                lme.setMessage(10000, new Object[]{t10.getMessage()});
                this.responseMessage = lme.createErrorMessage();
                ((ErrorMessage)this.responseMessage).setCorrelationId(this.inMessage.getMessageId());
                ((ErrorMessage)this.responseMessage).setDestination(this.inMessage.getDestination());
                ((ErrorMessage)this.responseMessage).setClientId(this.inMessage.getClientId());
                if (Log.isError()) {
                    Log.getLogger(LOG_CATEGORY).error("Unhandled error when processing a message: " + t10.toString() + StringUtils.NEWLINE + "  incomingMessage: " + this.inMessage + StringUtils.NEWLINE + "  errorReply: " + this.responseMessage + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString(t10) + StringUtils.NEWLINE);
                }
            }
        }
        catch (Throwable t11) {
            this.unhandledError(context, t11);
        }
    }

    protected void doOutboundFilter(ActionContext context) throws IOException {
        try {
            FlexSession session;
            Message messageToReturn = this.responseMessage;
            this.responseMessage = null;
            if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                MessagePerformanceUtils.updateOutgoingMPI(context, this.inMessage, messageToReturn);
            }
            if ((session = FlexContext.getFlexSession()) != null && session.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && messageToReturn instanceof Message) {
                messageToReturn = this.endpoint.convertToSmallMessage(messageToReturn);
            }
            if (!(messageToReturn instanceof ErrorMessage)) {
                this.response.setReplyMethod("/onResult");
            } else {
                this.response.setReplyMethod("/onStatus");
            }
            this.response.setData(messageToReturn);
        }
        catch (Throwable t10) {
            this.unhandledError(context, t10);
        }
    }

    private void unhandledError(ActionContext context, Throwable t10) {
        MessageException methodResult;
        context.setStatus(1);
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t10 instanceof MessageException) {
            methodResult = (MessageException)t10;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t10);
        }
        responseBody.setReplyMethod("/onStatus");
        responseBody.setData(methodResult);
        if (Log.isInfo()) {
            Log.getLogger(this.endpointLogCategory).info("Client request could not be processed.", t10);
        }
    }
}

