/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.util.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TokenReplacer {
    private final Map replacedTokens = new LinkedHashMap();
    private final Pattern pattern;

    public TokenReplacer() {
        String tokenRegEx = "\\{(.*?)\\}";
        this.pattern = Pattern.compile(tokenRegEx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceToken(Node node, String sourceFileName) {
        Node replacementNode;
        if ("ip-address-pattern".equals(node.getNodeName())) {
            return;
        }
        if (node.getNodeValue() == null) {
            if (node.getChildNodes().getLength() != 1 || !(node.getFirstChild() instanceof Text)) return;
            replacementNode = node.getFirstChild();
        } else {
            replacementNode = node;
        }
        String nodeValue = replacementNode.getNodeValue();
        Matcher matcher = this.pattern.matcher(nodeValue);
        while (matcher.find()) {
            String tokenWithCurlyBraces = matcher.group();
            String tokenWithoutCurlyBraces = matcher.group(1);
            String propertyValue = System.getProperty(tokenWithoutCurlyBraces);
            if (propertyValue != null) {
                nodeValue = StringUtils.substitute(nodeValue, tokenWithCurlyBraces, propertyValue);
                this.replacedTokens.put(tokenWithCurlyBraces, propertyValue);
                continue;
            }
            if ("{context.root}".equals(tokenWithCurlyBraces) || "{context-root}".equals(tokenWithCurlyBraces) || "{server.name}".equals(tokenWithCurlyBraces) || "{server.port}".equals(tokenWithCurlyBraces)) continue;
            ConfigurationException ex2 = new ConfigurationException();
            Object[] args = new Object[]{tokenWithCurlyBraces, sourceFileName};
            ex2.setMessage(11125, args);
            throw ex2;
        }
        replacementNode.setNodeValue(nodeValue);
    }

    public void reportTokens() {
        if (Log.isWarn()) {
            Iterator iter = this.replacedTokens.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String tokenWithParanthesis = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if ("{context.root}".equals(tokenWithParanthesis) || "{context-root}".equals(tokenWithParanthesis)) {
                    if (!Log.isWarn()) continue;
                    Log.getLogger("Configuration").warn("Token '{0}' was replaced with '{1}'. Note that this will apply to all applications on the JVM", new Object[]{tokenWithParanthesis, propertyValue});
                    continue;
                }
                if (!Log.isDebug()) continue;
                Log.getLogger("Configuration").debug("Token '{0}' was replaced with '{1}'", new Object[]{tokenWithParanthesis, propertyValue});
            }
        }
    }
}

