/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationConstants;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.ServicesConfiguration;
import flex.messaging.config.TokenReplacer;
import flex.messaging.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractConfigurationParser
implements ConfigurationParser,
ConfigurationConstants {
    protected ServicesConfiguration config;
    protected DocumentBuilder docBuilder;
    protected ConfigurationFileResolver fileResolver;
    protected TokenReplacer tokenReplacer;
    private Map fileByDocument = new HashMap();

    protected AbstractConfigurationParser() {
        this.initializeDocumentBuilder();
        this.tokenReplacer = new TokenReplacer();
    }

    public void parse(String path, ConfigurationFileResolver fileResolver, ServicesConfiguration config) {
        this.config = config;
        this.fileResolver = fileResolver;
        Document doc = this.loadDocument(path, fileResolver.getConfigurationFile(path));
        this.initializeExpressionQuery();
        this.parseTopLevelConfig(doc);
    }

    public void reportTokens() {
        this.tokenReplacer.reportTokens();
    }

    protected void initializeDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex2) {
            ConfigurationException e10 = new ConfigurationException();
            e10.setMessage(10100);
            e10.setRootCause(ex2);
            throw e10;
        }
    }

    protected Document loadDocument(String path, InputStream in2) {
        try {
            Document doc;
            String encoding;
            if (!in2.markSupported()) {
                in2 = new BufferedInputStream(in2);
            }
            if ("UTF-8".equals(encoding = FileUtils.consumeBOM(in2, null)) || "UTF-16".equals(encoding)) {
                InputSource inputSource = new InputSource(in2);
                inputSource.setEncoding(encoding);
                doc = this.docBuilder.parse(inputSource);
            } else {
                doc = this.docBuilder.parse(in2);
            }
            this.addFileByDocument(path, doc);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (SAXParseException ex2) {
            Integer line = new Integer(ex2.getLineNumber());
            Integer col = new Integer(ex2.getColumnNumber());
            String message = ex2.getMessage();
            ConfigurationException e10 = new ConfigurationException();
            e10.setMessage(10102, new Object[]{line, col, message});
            e10.setRootCause(ex2);
            throw e10;
        }
        catch (SAXException ex3) {
            ConfigurationException e11 = new ConfigurationException();
            e11.setMessage(ex3.getMessage());
            e11.setRootCause(ex3);
            throw e11;
        }
        catch (IOException ex4) {
            ConfigurationException e12 = new ConfigurationException();
            e12.setMessage(ex4.getMessage());
            e12.setRootCause(ex4);
            throw e12;
        }
    }

    protected void addFileByDocument(String path, Node node) {
        String shortPath = path;
        if (shortPath != null && (shortPath.indexOf("/") != -1 || shortPath.indexOf("\\") != -1)) {
            int start = 0;
            start = shortPath.lastIndexOf("/");
            if (start == -1) {
                start = shortPath.lastIndexOf("\\");
            }
            shortPath = path.substring(start + 1);
        }
        this.fileByDocument.put(node, shortPath);
    }

    protected String getSourceFileOf(Node node) {
        return (String)this.fileByDocument.get(node.getOwnerDocument());
    }

    protected abstract void parseTopLevelConfig(Document var1);

    protected abstract void initializeExpressionQuery();

    protected abstract Node selectSingleNode(Node var1, String var2);

    protected abstract NodeList selectNodeList(Node var1, String var2);

    protected abstract Object evaluateExpression(Node var1, String var2);

    public ConfigMap properties(NodeList properties) {
        return this.properties(properties, "uknown file");
    }

    public ConfigMap properties(NodeList properties, String sourceFileName) {
        int length = properties.getLength();
        ConfigMap map = new ConfigMap(length);
        for (int p10 = 0; p10 < length; ++p10) {
            Node prop = properties.item(p10);
            String propName = prop.getNodeName();
            if (propName == null) continue;
            propName = propName.trim();
            if (prop.getNodeType() == 1) {
                NodeList attributes = this.selectNodeList(prop, "@*");
                NodeList children = this.selectNodeList(prop, "*");
                if (children.getLength() > 0 || attributes.getLength() > 0) {
                    ConfigMap childMap = new ConfigMap();
                    if (children.getLength() > 0) {
                        childMap.addProperties(this.properties(children, sourceFileName));
                    }
                    if (attributes.getLength() > 0) {
                        childMap.addProperties(this.properties(attributes, sourceFileName));
                    }
                    map.addProperty(propName, childMap);
                    continue;
                }
                this.tokenReplacer.replaceToken(prop, sourceFileName);
                String propValue = this.evaluateExpression(prop, ".").toString();
                map.addProperty(propName, propValue);
                continue;
            }
            this.tokenReplacer.replaceToken(prop, sourceFileName);
            map.addProperty(propName, prop.getNodeValue());
        }
        return map;
    }

    public String getAttributeOrChildElement(Node node, String name) {
        String attr = this.evaluateExpression(node, "@" + name).toString().trim();
        if (attr.length() == 0) {
            attr = this.evaluateExpression(node, name).toString().trim();
        }
        return attr;
    }

    public void allowedChildElements(Node node, String[] allowed) {
        NodeList children = this.selectNodeList(node, "*");
        String unexpected = this.unexpected(children, allowed);
        if (unexpected != null) {
            ConfigurationException ex2 = new ConfigurationException();
            Object[] args = new Object[]{unexpected, node.getNodeName(), this.getSourceFilename(node)};
            ex2.setMessage(10106, args);
            throw ex2;
        }
        NodeList textNodes = this.selectNodeList(node, "text()");
        for (int i10 = 0; i10 < textNodes.getLength(); ++i10) {
            String text = this.evaluateExpression(textNodes.item(i10), ".").toString().trim();
            if (text.length() <= 0) continue;
            ConfigurationException ex3 = new ConfigurationException();
            Object[] args = new Object[]{text, node.getNodeName(), this.getSourceFilename(node)};
            ex3.setMessage(11104, args);
            throw ex3;
        }
    }

    public void allowedAttributes(Node node, String[] allowed) {
        NodeList attributes = this.selectNodeList(node, "@*");
        String unexpectedAttribute = this.unexpected(attributes, allowed);
        if (unexpectedAttribute != null) {
            ConfigurationException ex2 = new ConfigurationException();
            Object[] args = new Object[]{unexpectedAttribute, node.getNodeName(), this.getSourceFilename(node)};
            ex2.setMessage(10107, args);
            throw ex2;
        }
    }

    private String getSourceFilename(Node node) {
        return this.getSourceFileOf(node);
    }

    public void allowedAttributesOrElements(Node node, String[] allowed) {
        this.allowedAttributes(node, allowed);
        this.allowedChildElements(node, allowed);
    }

    public void requiredAttributesOrElements(Node node, String[] required) {
        String nodeName = node.getNodeName();
        NodeList attributes = this.selectNodeList(node, "@*");
        ArrayList<String> list = new ArrayList<String>();
        for (int i10 = 0; i10 < required.length; ++i10) {
            list.add(required[i10]);
        }
        String missingAttribute = null;
        do {
            if ((missingAttribute = this.required(attributes, list)) == null) continue;
            Node child = this.selectSingleNode(node, missingAttribute);
            if (child != null) {
                list.remove(missingAttribute);
                continue;
            }
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10105, new Object[]{missingAttribute, nodeName});
            throw ex2;
        } while (missingAttribute != null && list.size() > 0);
    }

    public void requiredChildElements(Node node, String[] required) {
        String nodeName = node.getNodeName();
        NodeList children = this.selectNodeList(node, "*");
        ArrayList<String> list = new ArrayList<String>();
        for (int i10 = 0; i10 < required.length; ++i10) {
            list.add(required[i10]);
        }
        String missing = this.required(children, list);
        if (missing != null) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10104, new Object[]{missing, nodeName});
            throw ex2;
        }
    }

    public String unexpected(NodeList attributes, String[] allowed) {
        for (int i10 = 0; i10 < attributes.getLength(); ++i10) {
            Node attrib = attributes.item(i10);
            String attribName = attrib.getNodeName();
            boolean match = false;
            for (int j10 = 0; j10 < allowed.length; ++j10) {
                String a10 = allowed[j10];
                if (!a10.equals(attribName)) continue;
                match = true;
                break;
            }
            if (!match) {
                return attribName;
            }
            this.tokenReplacer.replaceToken(attrib, this.getSourceFilename(attrib));
        }
        return null;
    }

    public String required(NodeList attributes, List required) {
        for (int i10 = 0; i10 < required.size(); ++i10) {
            boolean found = false;
            String req = (String)required.get(i10);
            Node attrib = null;
            for (int j10 = 0; j10 < attributes.getLength(); ++j10) {
                attrib = attributes.item(j10);
                String attribName = attrib.getNodeName();
                if (!req.equals(attribName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return req;
            }
            this.tokenReplacer.replaceToken(attrib, this.getSourceFilename(attrib));
        }
        return null;
    }

    public static boolean isValidID(String id2) {
        if (id2 != null && id2.length() > 0 && id2.length() < 256) {
            char[] chars = id2.toCharArray();
            for (int i10 = 0; i10 < chars.length; ++i10) {
                char c10 = chars[i10];
                if (",;:".indexOf(c10) == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

