/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services;

import flex.management.BaseControl;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.services.ServiceControlMBean;
import flex.messaging.Destination;
import flex.messaging.services.Service;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;

public abstract class ServiceControl
extends BaseControl
implements ServiceControlMBean {
    protected Service service;
    private List destinations;

    public ServiceControl(Service service, BaseControl parent) {
        super(parent);
        this.service = service;
        this.destinations = new ArrayList();
    }

    public String getId() {
        return this.service.getId();
    }

    public Boolean isRunning() {
        return this.service.isStarted();
    }

    public void addDestination(ObjectName value) {
        this.destinations.add(value);
    }

    public void removeDestination(ObjectName value) {
        this.destinations.remove(value);
    }

    public ObjectName[] getDestinations() {
        int size = this.destinations.size();
        ObjectName[] destinationNames = new ObjectName[size];
        for (int i10 = 0; i10 < size; ++i10) {
            destinationNames[i10] = (ObjectName)this.destinations.get(i10);
        }
        return destinationNames;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void preDeregister() throws Exception {
        MessageBrokerControl parent = (MessageBrokerControl)this.getParentControl();
        parent.removeService(this.getObjectName());
        for (Destination child : this.service.getDestinations().values()) {
            if (child.getControl() == null) continue;
            child.getControl().unregister();
            child.setControl(null);
            child.setManaged(false);
        }
        super.preDeregister();
    }
}

