/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.log;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.log.LogControl;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.log.LogCategories;
import flex.messaging.log.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogManager
extends ManageableComponent {
    private static final String LOG_CATEGORY = "Configuration";
    private static final int NULL_LOG_REF_EXCEPTION = 10031;
    private Log log;
    private String ID = "log";
    private CategoryManager categoryManager;
    private LogControl controller;
    private boolean isSetup;

    public LogManager() {
        this(true);
    }

    public LogManager(boolean enableManagement) {
        super(enableManagement);
        this.setId(this.ID);
        this.categoryManager = new CategoryManager();
    }

    public void setupLogControl() {
        if (!this.isSetup) {
            this.controller = new LogControl(this.getParent().getControl(), this);
            this.setControl(this.controller);
            this.controller.register();
            this.isSetup = true;
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public void setLog(Log logInstance) {
        this.log = logInstance;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    public String[] getLoggers() {
        return this.log.getLoggers();
    }

    public String[] getTargetIds() {
        return Log.getTargetMap().keySet().toArray(new String[0]);
    }

    public Target getTarget(String targetId) {
        return (Target)Log.getTargetMap().get(targetId);
    }

    public String[] getTargetFilters(String targetId) {
        Target target = this.getTarget(targetId);
        if (target == null) {
            return new String[0];
        }
        List filterObjects = target.getFilters();
        String[] filters = new String[filterObjects.size()];
        for (int i10 = 0; i10 < filterObjects.size(); ++i10) {
            filters[i10] = (String)filterObjects.get(i10);
        }
        return filters;
    }

    public boolean checkFilter(String filter) {
        return this.categoryManager.checkFilter(filter);
    }

    public List getCategories() {
        return this.categoryManager.getCategories();
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.log == null) {
            this.invalidate();
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10031, new Object[0]);
            throw ex2;
        }
    }

    private class CategoryManager
    implements LogCategories {
        private List categories = new ArrayList();

        public CategoryManager() {
            Field[] categoryFields = this.getClass().getFields();
            for (int i10 = 0; i10 < categoryFields.length; ++i10) {
                try {
                    this.categories.add((String)categoryFields[i10].get(this));
                    continue;
                }
                catch (IllegalAccessException iae) {
                    // empty catch block
                }
            }
        }

        public boolean checkFilter(String filter) {
            for (int i10 = 0; i10 < this.categories.size(); ++i10) {
                if (!Log.checkFilterToCategory(filter, (String)this.categories.get(i10))) continue;
                return true;
            }
            return false;
        }

        public List getCategories() {
            return Collections.unmodifiableList(new ArrayList(this.categories));
        }
    }
}

