/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CounterImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.RGBColorImpl;
import com.steadystate.css.dom.RectImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSValueImpl
implements CSSPrimitiveValue,
CSSValueList,
Serializable {
    private Object _value = null;

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        if (value.getParameters() != null) {
            this._value = value.getLexicalUnitType() == 38 ? new RectImpl(value.getParameters()) : (value.getLexicalUnitType() == 27 ? new RGBColorImpl(value.getParameters()) : (value.getLexicalUnitType() == 25 ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == 26 ? new CounterImpl(true, value.getParameters()) : value)));
        } else if (forcePrimitive || value.getNextLexicalUnit() == null) {
            this._value = value;
        } else {
            Vector<CSSValueImpl> v10 = new Vector<CSSValueImpl>();
            for (LexicalUnit lu2 = value; lu2 != null; lu2 = lu2.getNextLexicalUnit()) {
                if (lu2.getLexicalUnitType() == 0 || lu2.getLexicalUnitType() == 4) continue;
                v10.addElement(new CSSValueImpl(lu2, true));
            }
            this._value = v10;
        }
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    public String getCssText() {
        if (this.getCssValueType() == 2) {
            StringBuffer sb2 = new StringBuffer();
            Vector v10 = (Vector)this._value;
            LexicalUnit lu2 = (LexicalUnit)((CSSValueImpl)v10.elementAt((int)0))._value;
            while (lu2 != null) {
                sb2.append(lu2.toString());
                LexicalUnit prev = lu2;
                if ((lu2 = lu2.getNextLexicalUnit()) == null || lu2.getLexicalUnitType() == 0 || lu2.getLexicalUnitType() == 4 || prev.getLexicalUnitType() == 4) continue;
                sb2.append(" ");
            }
            return sb2.toString();
        }
        return this._value.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is2 = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v22 = (CSSValueImpl)parser.parsePropertyValue(is2);
            this._value = v22._value;
        }
        catch (Exception e10) {
            throw new DOMExceptionImpl(12, 0, e10.getMessage());
        }
    }

    public short getCssValueType() {
        return this._value instanceof Vector ? (short)2 : 1;
    }

    public short getPrimitiveType() {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu2 = (LexicalUnit)this._value;
            switch (lu2.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 17;
                }
                case 34: {
                    return 16;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
        } else {
            if (this._value instanceof RectImpl) {
                return 24;
            }
            if (this._value instanceof RGBColorImpl) {
                return 25;
            }
            if (this._value instanceof CounterImpl) {
                return 23;
            }
        }
        return 0;
    }

    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this._value = LexicalUnitImpl.createNumber(null, floatValue);
    }

    public float getFloatValue(short unitType) throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu2 = (LexicalUnit)this._value;
            return lu2.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 10);
    }

    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this._value = LexicalUnitImpl.createString(null, stringValue);
                break;
            }
            case 20: {
                this._value = LexicalUnitImpl.createURI(null, stringValue);
                break;
            }
            case 21: {
                this._value = LexicalUnitImpl.createIdent(null, stringValue);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 19);
            }
            default: {
                throw new DOMExceptionImpl(15, 11);
            }
        }
    }

    public String getStringValue() throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu2 = (LexicalUnit)this._value;
            if (lu2.getLexicalUnitType() == 35 || lu2.getLexicalUnitType() == 36 || lu2.getLexicalUnitType() == 24 || lu2.getLexicalUnitType() == 37) {
                return lu2.getStringValue();
            }
        } else if (this._value instanceof Vector) {
            return null;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    public Counter getCounterValue() throws DOMException {
        if (!(this._value instanceof Counter)) {
            throw new DOMExceptionImpl(15, 12);
        }
        return (Counter)this._value;
    }

    public Rect getRectValue() throws DOMException {
        if (!(this._value instanceof Rect)) {
            throw new DOMExceptionImpl(15, 13);
        }
        return (Rect)this._value;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        if (!(this._value instanceof RGBColor)) {
            throw new DOMExceptionImpl(15, 14);
        }
        return (RGBColor)this._value;
    }

    public int getLength() {
        return this._value instanceof Vector ? ((Vector)this._value).size() : 0;
    }

    public CSSValue item(int index) {
        return this._value instanceof Vector ? (CSSValue)((Vector)this._value).elementAt(index) : null;
    }

    public String toString() {
        return this.getCssText();
    }
}

