/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
implements CSSMediaRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private MediaList _media = null;
    private CSSRuleList _rules = null;

    public CSSMediaRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, MediaList media) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._media = media;
    }

    public short getType() {
        return 4;
    }

    public String getCssText() {
        StringBuffer sb2 = new StringBuffer("@media ");
        sb2.append(this.getMedia().toString()).append(" {");
        for (int i10 = 0; i10 < this.getCssRules().getLength(); ++i10) {
            CSSRule rule = this.getCssRules().item(i10);
            sb2.append(rule.getCssText()).append(" ");
        }
        sb2.append("}");
        return sb2.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is2 = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r10 = parser.parseRule(is2);
            if (r10.getType() != 4) {
                throw new DOMExceptionImpl(13, 7);
            }
            this._media = ((CSSMediaRuleImpl)r10)._media;
            this._rules = ((CSSMediaRuleImpl)r10)._rules;
        }
        catch (CSSException e10) {
            throw new DOMExceptionImpl(12, 0, e10.getMessage());
        }
        catch (IOException e11) {
            throw new DOMExceptionImpl(12, 0, e11.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public MediaList getMedia() {
        return this._media;
    }

    public CSSRuleList getCssRules() {
        return this._rules;
    }

    public int insertRule(String rule, int index) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is2 = new InputSource(new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this._parentStyleSheet);
            CSSRule r10 = parser.parseRule(is2);
            ((CSSRuleListImpl)this.getCssRules()).insert(r10, index);
        }
        catch (ArrayIndexOutOfBoundsException e10) {
            throw new DOMExceptionImpl(1, 1, e10.getMessage());
        }
        catch (CSSException e11) {
            throw new DOMExceptionImpl(12, 0, e11.getMessage());
        }
        catch (IOException e12) {
            throw new DOMExceptionImpl(12, 0, e12.getMessage());
        }
        return index;
    }

    public void deleteRule(int index) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (ArrayIndexOutOfBoundsException e10) {
            throw new DOMExceptionImpl(1, 1, e10.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl rules) {
        this._rules = rules;
    }

    public String toString() {
        return this.getCssText();
    }
}

