/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RBlank
extends BaseBoundableRenderable {
    public final int ascentPlusLeading;
    private final FontMetrics fontMetrics;

    public RBlank(ModelNode me, FontMetrics fm, RenderableContainer container, int ascentPlusLeading, int width, int height) {
        super(container, me);
        this.fontMetrics = fm;
        this.ascentPlusLeading = ascentPlusLeading;
        this.width = width;
        this.height = height;
    }

    protected void invalidateLayoutLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g2) {
        Color over;
        int td;
        RenderState rs = this.modelNode.getRenderState();
        Color bkg = rs.getTextBackgroundColor();
        if (bkg != null) {
            Color oldColor = g2.getColor();
            try {
                g2.setColor(bkg);
                g2.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g2.setColor(oldColor);
            }
        }
        if ((td = rs.getTextDecorationMask()) != 0) {
            if ((td & 1) != 0) {
                int lineOffset = this.ascentPlusLeading + 2;
                g2.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 4) != 0) {
                FontMetrics fm = this.fontMetrics;
                int lineOffset = fm.getLeading() + (fm.getAscent() + fm.getDescent()) / 2;
                g2.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 2) != 0) {
                int lineOffset = this.fontMetrics.getLeading();
                g2.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 8) != 0) {
                // empty if block
            }
        }
        if ((over = rs.getOverlayColor()) != null) {
            Color oldColor = g2.getColor();
            try {
                g2.setColor(over);
                g2.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g2.setColor(oldColor);
            }
        }
    }

    public boolean paintSelection(Graphics g2, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        g2.setColor(SELECTION_COLOR);
        g2.setXORMode(SELECTION_XOR);
        g2.fillRect(0, 0, this.width, this.height);
        g2.setPaintMode();
        return true;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        buffer.append(' ');
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int x2, int y2) {
        return new RenderableSpot(this, x2, y2);
    }
}

