/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class WritableLineReader
extends LineNumberReader {
    private final Reader delegate;
    private StringBuffer writeBuffer = null;

    public WritableLineReader(Reader reader, int bufferSize) {
        super(reader, bufferSize);
        this.delegate = reader;
    }

    public WritableLineReader(Reader reader) {
        super(reader);
        this.delegate = reader;
    }

    public int read() throws IOException {
        StringBuffer sb2 = this.writeBuffer;
        if (sb2 != null && sb2.length() > 0) {
            char ch = sb2.charAt(0);
            sb2.deleteCharAt(0);
            if (sb2.length() == 0) {
                this.writeBuffer = null;
            }
            return ch;
        }
        return super.read();
    }

    public int read(char[] b2, int off, int len) throws IOException {
        StringBuffer sb2 = this.writeBuffer;
        if (sb2 != null && sb2.length() > 0) {
            int srcEnd = Math.min(sb2.length(), len);
            sb2.getChars(0, srcEnd, b2, off);
            sb2.delete(0, srcEnd);
            if (sb2.length() == 0) {
                this.writeBuffer = null;
            }
            return srcEnd;
        }
        return super.read(b2, off, len);
    }

    public boolean ready() throws IOException {
        StringBuffer sb2 = this.writeBuffer;
        if (sb2 != null && sb2.length() > 0) {
            return true;
        }
        return super.ready();
    }

    public void close() throws IOException {
        this.writeBuffer = null;
        super.close();
    }

    public void write(String text) throws IOException {
        StringBuffer sb2 = this.writeBuffer;
        if (sb2 == null) {
            this.writeBuffer = sb2 = new StringBuffer();
        }
        sb2.append(text);
    }
}

