/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.InputContext;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLFormElement;

public abstract class HTMLBaseInputElement
extends HTMLAbstractUIElement {
    protected InputContext inputContext;
    private Image image = null;
    private String imageSrc;
    private final ArrayList imageListeners = new ArrayList(1);

    public HTMLBaseInputElement(String name) {
        super(name);
    }

    public void setInputContext(InputContext ic2) {
        this.inputContext = ic2;
    }

    public String getDefaultValue() {
        return this.getAttribute("defaultValue");
    }

    public void setDefaultValue(String defaultValue) {
        this.setAttribute("defaultValue", defaultValue);
    }

    public HTMLFormElement getForm() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && !(parent instanceof HTMLFormElement); parent = parent.getParentNode()) {
        }
        return (HTMLFormElement)parent;
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public String getAccessKey() {
        return this.getAttribute("accessKey");
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accessKey", accessKey);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getAlt() {
        return this.getAttribute("alit");
    }

    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    public boolean getDisabled() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? false : ic2.getDisabled();
    }

    public void setDisabled(boolean disabled) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setDisabled(disabled);
        }
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public boolean getReadOnly() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? false : ic2.getReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setReadOnly(readOnly);
        }
    }

    public int getTabIndex() {
        InputContext ic2 = this.inputContext;
        return ic2 == null ? 0 : ic2.getTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setTabIndex(tabIndex);
        }
    }

    public String getValue() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            return ic2.getValue();
        }
        String val = this.getAttribute("value");
        return val == null ? "" : val;
    }

    protected File getFileValue() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            return ic2.getFileValue();
        }
        return null;
    }

    public void setValue(String value) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setValue(value);
        } else {
            this.setAttribute("value", value);
        }
    }

    public void blur() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.blur();
        }
    }

    public void focus() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.focus();
        }
    }

    public void select() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.select();
        }
    }

    protected void assignAttributeField(String normalName, String value) {
        if ("value".equals(normalName)) {
            InputContext ic2 = this.inputContext;
            if (ic2 != null) {
                ic2.setValue(value);
            }
        } else if ("src".equals(normalName)) {
            this.loadImage(value);
        } else {
            super.assignAttributeField(normalName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String src) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document != null) {
            ArrayList arrayList = this.imageListeners;
            synchronized (arrayList) {
                this.imageSrc = src;
                this.image = null;
            }
            if (src != null) {
                document.loadImage(src, new LocalImageListener(src));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.imageListeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener listener) {
        Image currentImage;
        ArrayList l2;
        ArrayList arrayList = l2 = this.imageListeners;
        synchronized (arrayList) {
            currentImage = this.image;
            l2.add(listener);
        }
        if (currentImage != null) {
            listener.imageLoaded(new ImageEvent(this, currentImage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener listener) {
        ArrayList l2;
        ArrayList arrayList = l2 = this.imageListeners;
        synchronized (arrayList) {
            l2.remove(l2);
        }
    }

    void resetInput() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.resetInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String expectedImgSrc, ImageEvent event) {
        ImageListener[] listenerArray;
        ArrayList l2;
        ArrayList arrayList = l2 = this.imageListeners;
        synchronized (arrayList) {
            if (!expectedImgSrc.equals(this.imageSrc)) {
                return;
            }
            this.image = event.image;
            listenerArray = l2.toArray(ImageListener.EMPTY_ARRAY);
        }
        int llength = listenerArray.length;
        for (int i2 = 0; i2 < llength; ++i2) {
            listenerArray[i2].imageLoaded(event);
        }
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String imgSrc) {
            this.expectedImgSrc = imgSrc;
        }

        public void imageLoaded(ImageEvent event) {
            HTMLBaseInputElement.this.dispatchEvent(this.expectedImgSrc, event);
        }
    }
}

