/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static String charset = "UTF8";

    private URLEncoder() {
    }

    public static String encode(String s2) {
        try {
            return URLEncoder.encode(s2, charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(charset);
        }
    }

    public static String encode(String s2, String enc) throws UnsupportedEncodingException {
        if (!URLEncoder.needsEncoding(s2)) {
            return s2;
        }
        int length = s2.length();
        StringBuffer out = new StringBuffer(length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(10);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        for (int i2 = 0; i2 < length; ++i2) {
            int c2 = s2.charAt(i2);
            if (c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57 || c2 == 32) {
                if (c2 == 32) {
                    c2 = 43;
                }
                URLEncoder.toHex(out, buf.toByteArray());
                buf.reset();
                out.append((char)c2);
                continue;
            }
            try {
                char d2;
                writer.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i2 < length - 1 && (d2 = s2.charAt(i2 + 1)) >= '\udc00' && d2 <= '\udfff') {
                    writer.write(d2);
                    ++i2;
                }
                writer.flush();
                continue;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(s2);
            }
        }
        try {
            writer.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        URLEncoder.toHex(out, buf.toByteArray());
        return out.toString();
    }

    private static void toHex(StringBuffer buffer, byte[] b2) {
        for (int i2 = 0; i2 < b2.length; ++i2) {
            buffer.append('%');
            char ch = Character.forDigit(b2[i2] >> 4 & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            buffer.append(ch);
            ch = Character.forDigit(b2[i2] & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            buffer.append(ch);
        }
    }

    private static boolean needsEncoding(String s2) {
        if (s2 == null) {
            return false;
        }
        int length = s2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') continue;
            return true;
        }
        return false;
    }
}

