/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import flex.messaging.log.Log;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.TimeoutCapable;

public class TimeoutManager {
    private static final String LOG_CATEGORY = "Timeout";
    private ScheduledThreadPoolExecutor timeoutService;

    public TimeoutManager() {
        this(null);
    }

    public TimeoutManager(ThreadFactory tf) {
        if (tf == null) {
            tf = new MonitorThreadFactory();
        }
        this.timeoutService = new ScheduledThreadPoolExecutor(1, tf);
    }

    public Future scheduleTimeout(TimeoutCapable t2) {
        ScheduledFuture future = null;
        if (t2.getTimeoutPeriod() > 0L) {
            TimeoutTask timeoutTask = new TimeoutTask(t2);
            future = this.timeoutService.schedule((Runnable)timeoutTask, t2.getTimeoutPeriod(), TimeUnit.MILLISECONDS);
            t2.setTimeoutFuture((Future)future);
            if (t2 instanceof TimeoutAbstractObject) {
                TimeoutAbstractObject timeoutAbstract = (TimeoutAbstractObject)t2;
                timeoutAbstract.setTimeoutManager(this);
                timeoutAbstract.setTimeoutTask(timeoutTask);
            }
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has scheduled instance '" + System.identityHashCode(t2) + "' of type '" + t2.getClass().getName() + "' to be timed out in " + t2.getTimeoutPeriod() + " milliseconds. Task queue size: " + this.timeoutService.getQueue().size());
            }
        }
        return future;
    }

    public boolean unscheduleTimeout(TimeoutAbstractObject timeoutAbstract) {
        Runnable unscheduledTimeoutTask;
        Object toRemove = timeoutAbstract.getTimeoutFuture();
        if (!(toRemove instanceof Runnable)) {
            toRemove = timeoutAbstract.getTimeoutTask();
        }
        if (this.timeoutService.remove((Runnable)toRemove)) {
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has removed the timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
        } else {
            Future timeoutFuture = timeoutAbstract.getTimeoutFuture();
            timeoutFuture.cancel(false);
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' cancelling timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
            if (timeoutFuture.isDone()) {
                this.timeoutService.purge();
                if (Log.isDebug()) {
                    Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' purged queue of any cancelled or completed tasks. Task queue size: " + this.timeoutService.getQueue().size());
                }
            }
        }
        if ((unscheduledTimeoutTask = timeoutAbstract.getTimeoutTask()) != null && unscheduledTimeoutTask instanceof TimeoutTask) {
            ((TimeoutTask)timeoutAbstract.getTimeoutTask()).clearTimeoutCapable();
        }
        return true;
    }

    public void shutdown() {
        this.timeoutService.shutdown();
    }

    class TimeoutTask
    implements Runnable {
        private TimeoutCapable timeoutObject;

        public void clearTimeoutCapable() {
            this.timeoutObject = null;
        }

        public TimeoutTask(TimeoutCapable timeoutObject) {
            this.timeoutObject = timeoutObject;
        }

        public void run() {
            long inactiveMillis = System.currentTimeMillis() - this.timeoutObject.getLastUse();
            if (inactiveMillis >= this.timeoutObject.getTimeoutPeriod()) {
                this.timeoutObject.timeout();
                if (Log.isDebug()) {
                    Log.getLogger(TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has run the timeout task for instance '" + System.identityHashCode(this.timeoutObject) + "' of type '" + this.timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                }
            } else {
                this.timeoutObject.setTimeoutFuture((Future)TimeoutManager.this.timeoutService.schedule((Runnable)this, this.timeoutObject.getTimeoutPeriod() - inactiveMillis, TimeUnit.MILLISECONDS));
                if (Log.isDebug()) {
                    Log.getLogger(TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has rescheduled a timeout for the active instance '" + System.identityHashCode(this.timeoutObject) + "' of type '" + this.timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                }
            }
        }
    }

    class MonitorThreadFactory
    implements ThreadFactory {
        MonitorThreadFactory() {
        }

        public Thread newThread(Runnable r2) {
            Thread t2 = new Thread(r2);
            t2.setDaemon(true);
            t2.setName("TimeoutManager");
            return t2;
        }
    }
}

