/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControl;
import flex.messaging.MessageException;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.messages.Message;
import java.util.HashMap;
import java.util.Map;

public class ThrottleManager
extends ManageableComponent {
    public static final String LOG_CATEGORY = "Service.Message";
    public static final String TYPE = "ThrottleManager";
    private static final Object classMutex = new Object();
    private static final int MESSAGE_TIMES_SIZE = 15;
    private static int instanceCount = 0;
    private Map<Object, ThrottleMark> inboundClientMarks;
    private Map<Object, ThrottleMark> outboundClientMarks;
    private ThrottleMark inboundDestinationMark;
    private ThrottleMark outboundDestinationMark;
    private ThrottleSettings settings;

    public ThrottleManager() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleManager(boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
        this.setThrottleSettings(new ThrottleSettings());
    }

    public void stop() {
        super.stop();
        if (this.isManaged() && this.getControl() != null) {
            this.getControl().unregister();
            this.setControl(null);
            this.setManaged(false);
        }
    }

    public void setId(String id2) {
    }

    public void removeClientThrottleMark(Object clientId) {
        if (this.inboundClientMarks != null) {
            this.inboundClientMarks.remove(clientId);
        }
        if (this.outboundClientMarks != null) {
            this.outboundClientMarks.remove(clientId);
        }
    }

    public void setThrottleSettings(ThrottleSettings throttleSettings) {
        this.settings = throttleSettings;
        if (this.settings.isDestinationThrottleEnabled()) {
            this.inboundDestinationMark = new ThrottleMark(this.settings.getDestinationName());
            this.outboundDestinationMark = new ThrottleMark(this.settings.getDestinationName());
        }
        if (this.settings.isClientThrottleEnabled()) {
            this.inboundClientMarks = new HashMap<Object, ThrottleMark>();
            this.outboundClientMarks = new HashMap<Object, ThrottleMark>();
        }
    }

    public ThrottleResult throttleIncomingMessage(Message msg) {
        ThrottleResult result = new ThrottleResult(0);
        if (this.settings.getInboundPolicy() != 0 && (result = this.throttleDestinationLevel(msg, true)).getResultCode() == 0) {
            result = this.throttleClientLevel(msg, msg.getClientId(), true);
        }
        return result;
    }

    public ThrottleResult throttleOutgoingMessage(Message msg, Object clientId) {
        ThrottleResult result = new ThrottleResult(0);
        if (this.settings.getOutboundPolicy() != 0) {
            result = clientId == null ? this.throttleDestinationLevel(msg, false) : this.throttleClientLevel(msg, clientId, false);
        }
        return result;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    private ThrottleResult throttleDestinationLevel(Message msg, boolean incoming) {
        ThrottleResult result = new ThrottleResult(0);
        if (this.settings.isDestinationThrottleEnabled()) {
            if (incoming) {
                try {
                    this.inboundDestinationMark.assertValid(msg.getTimestamp(), this.settings.getIncomingDestinationFrequency());
                }
                catch (RuntimeException e2) {
                    int throttleResultCode = this.getResultCode(this.settings.getInboundPolicy());
                    if (throttleResultCode != 0 && this.isManaged()) {
                        ((ThrottleManagerControl)this.getControl()).incrementDestinationIncomingMessageThrottleCount();
                    }
                    String s2 = "Message throttled: Too many messages sent to destination " + this.inboundDestinationMark.id + " in too small of a time interval.  " + e2.getMessage();
                    MessageException me = new MessageException(s2);
                    result = new ThrottleResult(throttleResultCode, me);
                }
            } else {
                try {
                    this.outboundDestinationMark.assertValid(msg.getTimestamp(), this.settings.getOutgoingDestinationFrequency());
                }
                catch (RuntimeException e3) {
                    int throttleResultCode = this.getResultCode(this.settings.getOutboundPolicy());
                    if (throttleResultCode != 0 && this.isManaged()) {
                        ((ThrottleManagerControl)this.getControl()).incrementDestinationOutgoingMessageThrottleCount();
                    }
                    String s3 = "Message throttled: Too many messages routed by destination " + this.outboundDestinationMark.id + " in too small of a time interval";
                    MessageException me = new MessageException(s3);
                    result = new ThrottleResult(throttleResultCode, me);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThrottleResult throttleClientLevel(Message msg, Object clientId, boolean incoming) {
        ThrottleResult result = new ThrottleResult(0);
        if (this.settings.isClientThrottleEnabled()) {
            if (incoming) {
                ThrottleMark clientLevelMark = this.inboundClientMarks.get(clientId);
                if (clientLevelMark == null) {
                    clientLevelMark = new ThrottleMark(clientId);
                }
                try {
                    clientLevelMark.assertValid(msg.getTimestamp(), this.settings.getIncomingClientFrequency());
                }
                catch (RuntimeException e2) {
                    int throttleResultCode = this.getResultCode(this.settings.getInboundPolicy());
                    if (throttleResultCode != 0 && this.isManaged()) {
                        ((ThrottleManagerControl)this.getControl()).incrementClientIncomingMessageThrottleCount();
                    }
                    String s2 = "Message throttled: Too many messages sent by client " + clientId + " in too small of a time interval";
                    MessageException me = new MessageException(s2);
                    result = new ThrottleResult(throttleResultCode, me);
                }
                finally {
                    this.inboundClientMarks.put(clientId, clientLevelMark);
                }
            } else {
                ThrottleMark clientLevelMark = this.outboundClientMarks.get(clientId);
                if (clientLevelMark == null) {
                    clientLevelMark = new ThrottleMark(clientId);
                }
                try {
                    clientLevelMark.assertValid(msg.getTimestamp(), this.settings.getOutgoingClientFrequency());
                }
                catch (RuntimeException e3) {
                    int throttleResultCode = this.getResultCode(this.settings.getOutboundPolicy());
                    if (throttleResultCode != 0 && this.isManaged()) {
                        ((ThrottleManagerControl)this.getControl()).incrementClientOutgoingMessageThrottleCount();
                    }
                    String s3 = "Message throttled: Too many messages sent to client " + clientId + " in too small of a time interval";
                    MessageException me = new MessageException(s3);
                    result = new ThrottleResult(throttleResultCode, me);
                }
                finally {
                    this.outboundClientMarks.put(clientId, clientLevelMark);
                }
            }
        }
        return result;
    }

    private int getResultCode(int policy) {
        int n2 = 0;
        switch (policy) {
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
            }
        }
        return n2;
    }

    class ThrottleMark {
        Object id;
        int messageCount;
        long[] previousMessageTimes;

        ThrottleMark(Object id2) {
            this.id = id2;
            this.messageCount = 0;
            this.previousMessageTimes = new long[15];
        }

        void assertValid(long messageTimestamp, int maxFrequency) {
            if (maxFrequency > 0) {
                long interval;
                long actualFrequency;
                if (this.messageCount >= 15 && (actualFrequency = 15L / ((interval = (messageTimestamp - this.previousMessageTimes[this.messageCount % 15]) / 1000L) > 0L ? interval : 1L)) > (long)maxFrequency) {
                    throw new RuntimeException("actual frequency=" + actualFrequency + " max frequency=" + maxFrequency);
                }
                if (this.messageCount == Integer.MAX_VALUE) {
                    this.messageCount = 0;
                }
                this.previousMessageTimes[this.messageCount++ % 15] = messageTimestamp;
            }
        }
    }

    public static class ThrottleResult {
        public static final int RESULT_OK = 0;
        public static final int RESULT_IGNORE = 1;
        public static final int RESULT_REPLACE = 2;
        public static final int RESULT_ERROR = 3;
        private MessageException exception;
        private int resultCode;

        public ThrottleResult(int resultCode) {
            this.resultCode = resultCode;
        }

        public ThrottleResult(int result, MessageException exception) {
            this(result);
            this.exception = exception;
        }

        public MessageException getException() {
            return this.exception;
        }

        public int getResultCode() {
            return this.resultCode;
        }
    }
}

