/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amfx.AmfxOutput;
import flex.messaging.io.amfx.AmfxTypes;
import java.io.IOException;
import java.io.OutputStream;

public class AmfxMessageSerializer
implements MessageSerializer,
AmfxTypes {
    protected AmfxOutput amfxOut;
    protected int version;
    protected boolean isDebug;
    protected AmfTrace debugTrace;
    public static final String XML_DIRECTIVE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";

    public void setVersion(int value) {
        this.version = value;
    }

    public void initialize(SerializationContext context, OutputStream out, AmfTrace trace) {
        this.amfxOut = new AmfxOutput(context);
        this.amfxOut.setOutputStream(out);
        this.debugTrace = trace;
        this.isDebug = this.debugTrace != null;
        this.amfxOut.setDebugTrace(trace);
    }

    public void writeMessage(ActionMessage m2) throws IOException {
        if (this.isDebug) {
            this.debugTrace.startResponse("Serializing AMFX/HTTP response");
        }
        this.amfxOut.writeUTF(XML_DIRECTIVE);
        int version = m2.getVersion();
        this.writeOpenAMFX(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = m2.getHeaderCount();
        for (int i2 = 0; i2 < headerCount; ++i2) {
            MessageHeader header = m2.getHeader(i2);
            if (this.isDebug) {
                this.debugTrace.startHeader(header.getName(), header.getMustUnderstand(), i2);
            }
            this.writeHeader(header);
            if (!this.isDebug) continue;
            this.debugTrace.endHeader();
        }
        int bodyCount = m2.getBodyCount();
        for (int i3 = 0; i3 < bodyCount; ++i3) {
            MessageBody body = m2.getBody(i3);
            if (this.isDebug) {
                this.debugTrace.startMessage(body.getTargetURI(), body.getResponseURI(), i3);
            }
            this.writeBody(body);
            if (!this.isDebug) continue;
            this.debugTrace.endMessage();
        }
        this.writeCloseAMFX();
        if (this.isDebug) {
            this.debugTrace.endMessage();
        }
    }

    protected void writeOpenAMFX(int version) throws IOException {
        int buflen = 14;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<").append("amfx").append(" ver=\"");
        sb2.append(version);
        sb2.append("\">");
        this.amfxOut.writeUTF(sb2);
    }

    protected void writeCloseAMFX() throws IOException {
        this.amfxOut.writeUTF("</amfx>");
    }

    protected void writeHeader(MessageHeader h2) throws IOException {
        int buflen = 127;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<").append("header").append(" name=\"");
        sb2.append(h2.getName());
        sb2.append("\"");
        if (h2.getMustUnderstand()) {
            sb2.append(" mustUnderstand=\"");
            sb2.append(h2.getMustUnderstand());
            sb2.append("\"");
        }
        sb2.append(">");
        this.amfxOut.writeUTF(sb2);
        this.writeObject(h2.getData());
        this.amfxOut.writeUTF("</header>");
    }

    protected void writeBody(MessageBody b2) throws IOException {
        if (b2.getTargetURI() == null && b2.getResponseURI() == null) {
            this.amfxOut.writeUTF("<body>");
        } else {
            int buflen = 127;
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<").append("body");
            if (b2.getTargetURI() != null) {
                sb2.append(" targetURI=\"").append(b2.getTargetURI()).append("\"");
            }
            if (b2.getResponseURI() != null) {
                sb2.append(" responseURI=\"").append(b2.getResponseURI()).append("\"");
            }
            sb2.append(">");
            this.amfxOut.writeUTF(sb2);
        }
        Object data = b2.getData();
        this.writeObject(data);
        this.amfxOut.writeUTF("</body>");
    }

    public void writeObject(Object value) throws IOException {
        this.amfxOut.writeObject(value);
    }
}

