/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import flex.messaging.io.amf.translator.decoder.TypedObjectDecoder;
import java.util.List;

public class ReferenceAwareTypedObjectDecoder
extends TypedObjectDecoder {
    protected Object decodeTypedObject(Object bean, Object encodedObject) {
        TypeMarshallingContext context = TypeMarshallingContext.getTypeMarshallingContext();
        context.getKnownObjects().put(encodedObject, bean);
        PropertyProxy beanProxy = PropertyProxyRegistry.getProxy(bean);
        PropertyProxy encodedProxy = PropertyProxyRegistry.getProxy(encodedObject);
        List propertyNames = beanProxy.getPropertyNames(bean);
        if (propertyNames != null) {
            for (String propName : propertyNames) {
                Class wClass = beanProxy.getType(bean, propName);
                Object value = encodedProxy.getValue(encodedObject, propName);
                Object decodedObject = null;
                try {
                    if (value != null) {
                        Object ref = null;
                        if (this.canUseByReference(value)) {
                            ref = context.getKnownObjects().get(value);
                        }
                        if (ref == null) {
                            ActionScriptDecoder decoder = DecoderFactory.getReferenceAwareDecoder(value, wClass);
                            decodedObject = decoder.decodeObject(value, wClass);
                            if (this.canUseByReference(decodedObject)) {
                                context.getKnownObjects().put(value, decodedObject);
                            }
                        } else {
                            decodedObject = ref;
                        }
                    }
                    if (decodedObject == null && wClass.isPrimitive()) {
                        decodedObject = ReferenceAwareTypedObjectDecoder.getDefaultPrimitiveValue(wClass);
                    }
                    beanProxy.setValue(bean, propName, decodedObject);
                }
                catch (Exception e2) {
                    TranslationException ex = new TranslationException("Could not set object " + decodedObject + " on " + bean.getClass() + "'s " + propName);
                    ex.setCode("Server.Processing");
                    ex.setRootCause(e2);
                    throw ex;
                }
            }
        }
        return bean;
    }
}

