/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberDecoder
extends ActionScriptDecoder {
    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        Number result = null;
        if (encodedObject != null && encodedObject instanceof String) {
            String str = ((String)encodedObject).trim();
            try {
                if (!SerializationContext.getSerializationContext().legacyBigNumbers) {
                    if (BigInteger.class.equals((Object)desiredClass)) {
                        result = new BigInteger(str);
                        return result;
                    }
                    if (BigDecimal.class.equals((Object)desiredClass)) {
                        result = new BigDecimal(str);
                        return result;
                    }
                }
                Double dbl = new Double(str);
                encodedObject = dbl;
            }
            catch (NumberFormatException nfe) {
                DecoderFactory.invalidType(encodedObject, desiredClass);
            }
        }
        if (encodedObject instanceof Number || encodedObject == null) {
            Double dbl;
            if (desiredClass.isPrimitive()) {
                dbl = encodedObject == null ? new Double(0.0) : new Double(((Number)encodedObject).doubleValue());
                if (Object.class.equals((Object)desiredClass) || Double.TYPE.equals(desiredClass)) {
                    result = dbl;
                } else if (Integer.TYPE.equals(desiredClass)) {
                    result = new Integer(dbl.intValue());
                } else if (Long.TYPE.equals(desiredClass)) {
                    result = new Long(dbl.longValue());
                } else if (Float.TYPE.equals(desiredClass)) {
                    result = new Float(dbl.floatValue());
                } else if (Short.TYPE.equals(desiredClass)) {
                    result = new Short(dbl.shortValue());
                } else if (Byte.TYPE.equals(desiredClass)) {
                    result = new Byte(dbl.byteValue());
                }
            } else if (encodedObject != null) {
                dbl = new Double(((Number)encodedObject).doubleValue());
                if (Object.class.equals((Object)desiredClass) || Number.class.equals((Object)desiredClass) || Double.class.equals((Object)desiredClass)) {
                    result = dbl;
                } else if (Integer.class.equals((Object)desiredClass)) {
                    result = new Integer(dbl.intValue());
                } else if (Long.class.equals((Object)desiredClass)) {
                    result = new Long(dbl.longValue());
                } else if (Float.class.equals((Object)desiredClass)) {
                    result = new Float(dbl.floatValue());
                } else if (Short.class.equals((Object)desiredClass)) {
                    result = new Short(dbl.shortValue());
                } else if (BigDecimal.class.equals((Object)desiredClass)) {
                    result = SerializationContext.getSerializationContext().legacyBigNumbers ? new BigDecimal(dbl) : new BigDecimal(String.valueOf(dbl));
                } else if (Byte.class.equals((Object)desiredClass)) {
                    result = new Byte(dbl.byteValue());
                } else if (BigInteger.class.equals((Object)desiredClass)) {
                    String val = null;
                    long l2 = dbl.longValue();
                    if (l2 > Integer.MAX_VALUE) {
                        Long lo = new Long(dbl.longValue());
                        val = lo.toString().toUpperCase();
                        int suffix = val.indexOf("L");
                        if (suffix != -1) {
                            val = val.substring(0, suffix);
                        }
                    } else {
                        Integer i2 = new Integer(dbl.intValue());
                        val = i2.toString();
                    }
                    result = new BigInteger(val.trim());
                }
            } else {
                result = null;
            }
        } else {
            DecoderFactory.invalidType(encodedObject, desiredClass);
        }
        return result;
    }
}

