/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.LocalizedException;
import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.DictionaryProxy;
import flex.messaging.io.MapProxy;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PageableRowSetProxy;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.ThrowableProxy;
import flex.messaging.io.amf.ASObject;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PropertyProxyRegistry {
    private final Map classRegistry = new IdentityHashMap();
    private static PropertyProxyRegistry registry;

    public static synchronized PropertyProxyRegistry getRegistry() {
        if (registry == null) {
            registry = new PropertyProxyRegistry();
            PropertyProxyRegistry.preRegister();
        }
        return registry;
    }

    public static void release() {
        if (registry != null) {
            registry.clear();
            registry = null;
        }
    }

    private static void preRegister() {
        ThrowableProxy proxy = new ThrowableProxy();
        registry.register(MessageException.class, proxy);
        registry.register(LocalizedException.class, proxy);
        registry.register(Throwable.class, proxy);
        MapProxy mapProxy = new MapProxy();
        registry.register(ASObject.class, mapProxy);
        registry.register(HashMap.class, mapProxy);
        registry.register(AbstractMap.class, mapProxy);
        registry.register(Map.class, mapProxy);
    }

    public static PropertyProxy getProxyAndRegister(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c2 = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(c2);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
            PropertyProxyRegistry.getRegistry().register(c2, proxy);
        }
        return proxy;
    }

    public static PropertyProxy getProxy(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c2 = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxy(c2);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
        }
        proxy = (PropertyProxy)proxy.clone();
        proxy.setDefaultInstance(instance);
        return proxy;
    }

    private static PropertyProxy guessProxy(Object instance) {
        AbstractProxy proxy = instance instanceof Map ? new MapProxy() : (instance instanceof Throwable ? new ThrowableProxy() : (instance instanceof PageableRowSet || instance instanceof RowSet ? new PageableRowSetProxy() : (instance instanceof Dictionary ? new DictionaryProxy() : new BeanProxy())));
        return proxy;
    }

    public PropertyProxy getProxy(Class c2) {
        return this.getProxy(c2, true, false);
    }

    public PropertyProxy getProxyAndRegister(Class c2) {
        return this.getProxy(c2, true, true);
    }

    public PropertyProxy getProxy(Class c2, boolean searchHierarchy, boolean autoRegister) {
        Class<?> superclass;
        PropertyProxy proxy;
        if (c2 == null) {
            return null;
        }
        if (c2.isArray()) {
            c2 = c2.getComponentType();
        }
        if ((proxy = (PropertyProxy)this.classRegistry.get(c2)) == null && searchHierarchy) {
            Class<?>[] interfaces = c2.getInterfaces();
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                Class<?> interfaceClass = interfaces[i2];
                proxy = (PropertyProxy)this.classRegistry.get(interfaceClass);
                if (proxy != null && autoRegister) {
                    this.register(c2, proxy);
                    break;
                }
                proxy = this.getProxy(interfaceClass, searchHierarchy, autoRegister);
                if (proxy != null) break;
            }
        }
        if (proxy == null && searchHierarchy && (superclass = c2.getSuperclass()) != null && (proxy = this.getProxy(superclass, searchHierarchy, autoRegister)) != null && autoRegister) {
            this.register(c2, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class c2, PropertyProxy proxy) {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.put(c2, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class c2) {
        Map map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.remove(c2);
        }
    }
}

