/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.SuspendableAMFFilter;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;

public class SuspendableSerializationFilter
extends SuspendableAMFFilter {
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private Logger logger;
    private SerializationContext serializationContext;
    private TypeMarshaller typeMarshaller;
    private InputStream input;
    private int contentLength = -1;

    public SuspendableSerializationFilter(String logCategory, SerializationContext serializationContext, TypeMarshaller typeMarshaller) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger(logCategory);
        this.serializationContext = serializationContext;
        this.typeMarshaller = typeMarshaller;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public void setInputStream(InputStream value) {
        this.input = value;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int value) {
        this.contentLength = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doInboundFilter(ActionContext context) throws IOException {
        AmfTrace debugTrace;
        block14: {
            debugTrace = Log.isDebug() ? new AmfTrace() : null;
            context.setResponseMessage(new ActionMessage());
            boolean success = false;
            try {
                try {
                    TypeMarshallingContext.setTypeMarshaller(this.typeMarshaller);
                    MessageDeserializer deserializer = this.serializationContext.newMessageDeserializer();
                    deserializer.initialize(this.serializationContext, this.input, debugTrace);
                    if (this.contentLength != -1) {
                        context.setDeserializedBytes(this.contentLength);
                    }
                    if (context.isMPIenabled()) {
                        MessagePerformanceInfo mpi = new MessagePerformanceInfo();
                        mpi.recordMessageSizes = context.isRecordMessageSizes();
                        mpi.recordMessageTimes = context.isRecordMessageTimes();
                        if (context.isRecordMessageTimes()) {
                            mpi.receiveTime = System.currentTimeMillis();
                        }
                        if (context.isRecordMessageSizes()) {
                            mpi.messageSize = this.contentLength;
                        }
                        context.setMPII(mpi);
                    }
                    ActionMessage m2 = new ActionMessage();
                    context.setRequestMessage(m2);
                    deserializer.readMessage(m2, context);
                    success = true;
                }
                catch (EOFException eof) {
                    context.setStatus(2);
                    Object var7_10 = null;
                    if (!success) {
                        this.setInboundAborted(true);
                    }
                    TypeMarshallingContext.setTypeMarshaller(null);
                    this.contentLength = -1;
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (!Log.isDebug()) return;
                    this.logger.debug(debugTrace.toString());
                    return;
                }
                catch (IOException e2) {
                    if (!Log.isDebug()) throw e2;
                    this.logger.debug("IOException reading AMF message - client closed socket before sending the message?");
                    throw e2;
                }
                catch (Throwable t2) {
                    this.deserializationError(context, t2);
                    Object var7_11 = null;
                    if (!success) {
                        this.setInboundAborted(true);
                    }
                    TypeMarshallingContext.setTypeMarshaller(null);
                    this.contentLength = -1;
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (!Log.isDebug()) return;
                    this.logger.debug(debugTrace.toString());
                    return;
                }
                Object var7_9 = null;
                if (success) break block14;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (!success) {
                    this.setInboundAborted(true);
                }
                TypeMarshallingContext.setTypeMarshaller(null);
                this.contentLength = -1;
                ActionMessage respMsg = context.getResponseMessage();
                respMsg.setVersion(context.getVersion());
                if (!Log.isDebug()) throw throwable;
                this.logger.debug(debugTrace.toString());
                throw throwable;
            }
            this.setInboundAborted(true);
        }
        TypeMarshallingContext.setTypeMarshaller(null);
        this.contentLength = -1;
        ActionMessage respMsg = context.getResponseMessage();
        respMsg.setVersion(context.getVersion());
        if (!Log.isDebug()) return;
        this.logger.debug(debugTrace.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doOutboundFilter(ActionContext context) throws IOException {
        if (context.getStatus() == 2) return;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ActionMessage respMesg = context.getResponseMessage();
        AmfTrace debugTrace = Log.isDebug() ? new AmfTrace() : null;
        try {
            try {
                block11: {
                    TypeMarshallingContext.setTypeMarshaller(this.typeMarshaller);
                    long serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    MessageSerializer serializer = this.serializationContext.newMessageSerializer();
                    serializer.initialize(this.serializationContext, outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    context.setSerializedBytes(outBuffer.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            serializer = this.serializationContext.newMessageSerializer();
                            serializer.initialize(this.serializationContext, outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                        }
                        catch (Exception e2) {
                            if (!Log.isDebug()) break block11;
                            this.logger.debug("MPI set up error: " + e2.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer);
            }
            catch (Exception e3) {
                this.serializationError(context, e3);
                Object var10_10 = null;
                TypeMarshallingContext.setTypeMarshaller(null);
                if (!Log.isDebug()) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            TypeMarshallingContext.setTypeMarshaller(null);
            if (!Log.isDebug()) throw throwable;
            this.logger.debug(debugTrace.toString());
            throw throwable;
        }
        TypeMarshallingContext.setTypeMarshaller(null);
        if (!Log.isDebug()) return;
        this.logger.debug(debugTrace.toString());
    }

    private void deserializationError(ActionContext context, Throwable t2) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t2 instanceof MessageException) {
            methodResult = (MessageException)t2;
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t2);
            message = methodResult.getMessage();
        }
        responseBody.setData(methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString(t2));
        }
    }

    private void serializationError(ActionContext context, Throwable t2) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t2 instanceof MessageException) {
                methodResult = ((MessageException)t2).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t2.getMessage() != null && (message = t2.getMessage()) == null) {
                    message = t2.toString();
                }
                methodResult = new MessageException(message, t2).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        ((ErrorMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString(t2));
        }
        SerializationContext sc2 = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc2.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = Log.isDebug() ? new AmfTrace() : null;
        serializer.initialize(sc2, outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e2) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause(e2);
            throw ex;
        }
    }
}

