/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.endpoints.BaseHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegacyFilter
extends AMFFilter {
    public static final String LEGACY_ENVELOPE_FLAG_KEY = "_flag";
    public static final String LEGACY_ENVELOPE_FLAG_VALUE = "Envelope";
    public static final String LEGACY_SECURITY_HEADER_NAME = "Credentials";
    public static final String LEGACY_SECURITY_PRINCIPAL = "userid";
    public static final String LEGACY_SECURITY_CREDENTIALS = "password";
    private BaseHTTPEndpoint endpoint;

    public LegacyFilter(BaseHTTPEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void invoke(ActionContext context) throws IOException {
        MessageBody requestBody = context.getRequestMessageBody();
        context.setLegacy(true);
        Object data = requestBody.getData();
        List<Object> newParams = null;
        if (data != null) {
            Object obj;
            if (data.getClass().isArray()) {
                int paramLength = Array.getLength(data);
                if (paramLength == 1 && (obj = Array.get(data, 0)) != null && obj instanceof Message) {
                    context.setLegacy(false);
                    newParams = new ArrayList();
                    newParams.add(obj);
                }
                if (newParams == null) {
                    newParams = new ArrayList();
                    for (int i2 = 0; i2 < paramLength; ++i2) {
                        try {
                            newParams.add(Array.get(data, i2));
                            continue;
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                    }
                }
            } else if (data instanceof List) {
                List paramList = (List)data;
                if (paramList.size() == 1 && (obj = paramList.get(0)) != null && obj instanceof Message) {
                    context.setLegacy(false);
                    newParams = new ArrayList();
                    newParams.add(obj);
                }
                if (newParams == null) {
                    newParams = (List)data;
                }
            }
        }
        if (newParams == null) {
            newParams = new ArrayList<Object>();
            newParams.add(data);
        }
        if (context.isLegacy()) {
            newParams = this.legacyRequest(context, newParams);
        }
        requestBody.setData(newParams);
        this.next.invoke(context);
        if (context.isLegacy()) {
            MessageBody responseBody = context.getResponseMessageBody();
            Object response = responseBody.getData();
            if (response instanceof ErrorMessage) {
                ErrorMessage error = (ErrorMessage)response;
                ASObject aso = new ASObject();
                aso.put("message", error.faultString);
                aso.put("code", error.faultCode);
                aso.put("details", error.faultDetail);
                aso.put("rootCause", error.rootCause);
                response = aso;
            } else if (response instanceof Message) {
                response = ((Message)response).getBody();
            }
            responseBody.setData(response);
        }
    }

    private List legacyRequest(ActionContext context, List oldParams) {
        ASObject aso;
        Object obj;
        ArrayList<RemotingMessage> newParams = new ArrayList<RemotingMessage>(1);
        HashMap headerMap = new HashMap();
        List<Object> body = oldParams;
        RemotingMessage message = null;
        MessageBody requestBody = context.getRequestMessageBody();
        ArrayList packetHeaders = context.getRequestMessage().getHeaders();
        this.packetCredentials(packetHeaders, headerMap);
        if (oldParams.size() == 1 && (obj = oldParams.get(0)) != null && obj instanceof ASObject && this.isEnvelope(aso = (ASObject)obj)) {
            body = aso.get("data");
            Object h2 = aso.get("headers");
            if (h2 != null && h2 instanceof List) {
                this.readEnvelopeHeaders((List)h2, headerMap);
                this.envelopeCredentials(headerMap);
            }
        }
        message = this.createMessage(requestBody, body, headerMap);
        newParams.add(message);
        return newParams;
    }

    private boolean isEnvelope(ASObject aso) {
        String flag = null;
        Object f2 = aso.get(LEGACY_ENVELOPE_FLAG_KEY);
        if (f2 != null && f2 instanceof String) {
            flag = (String)f2;
        }
        return flag != null && flag.equalsIgnoreCase(LEGACY_ENVELOPE_FLAG_VALUE);
    }

    private RemotingMessage createMessage(MessageBody messageBody, Object body, Map headerMap) {
        RemotingMessage remotingMessage = new RemotingMessage();
        remotingMessage.setMessageId("");
        remotingMessage.setBody(body);
        remotingMessage.setHeaders(headerMap);
        String targetURI = messageBody.getTargetURI();
        int dotIndex = targetURI.lastIndexOf(".");
        if (dotIndex > 0) {
            String destination = targetURI.substring(0, dotIndex);
            remotingMessage.setDestination(destination);
        }
        if (targetURI.length() > dotIndex) {
            String operation = targetURI.substring(dotIndex + 1);
            remotingMessage.setOperation(operation);
        }
        return remotingMessage;
    }

    private Map readEnvelopeHeaders(List headers, Map headerMap) {
        int count = headers.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object obj = headers.get(i2);
            if (obj == null || !(obj instanceof List)) continue;
            List h2 = (List)obj;
            Object name = null;
            Object data = null;
            int numFields = h2.size();
            if (numFields != 3 || (name = (Object)h2.get(0)) == null || !(name instanceof String)) continue;
            data = h2.get(2);
            headerMap.put(name, data);
        }
        return headerMap;
    }

    private void envelopeCredentials(Map headers) {
        Object obj = headers.get(LEGACY_SECURITY_HEADER_NAME);
        if (obj != null && obj instanceof ASObject) {
            ASObject header = (ASObject)obj;
            String principal = (String)header.get(LEGACY_SECURITY_PRINCIPAL);
            Object credentials = header.get(LEGACY_SECURITY_CREDENTIALS);
            this.endpoint.getMessageBroker().getLoginManager().login(principal, credentials.toString());
        }
        headers.remove(LEGACY_SECURITY_HEADER_NAME);
    }

    private void packetCredentials(List packetHeaders, Map headers) {
        if (packetHeaders.size() > 0) {
            for (MessageHeader header : packetHeaders) {
                if (!header.getName().equals(LEGACY_SECURITY_HEADER_NAME)) continue;
                Map loginInfo = (Map)header.getData();
                String principal = loginInfo.get(LEGACY_SECURITY_PRINCIPAL).toString();
                Object credentials = loginInfo.get(LEGACY_SECURITY_CREDENTIALS);
                this.endpoint.getMessageBroker().getLoginManager().login(principal, credentials.toString());
                break;
            }
        }
    }
}

