/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging;

import flex.management.BaseControl;
import flex.management.runtime.AdminConsoleDisplayRegistrar;
import flex.management.runtime.messaging.MessageBrokerControlMBean;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.AMFEndpoint;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.HTTPEndpoint;
import flex.messaging.endpoints.StreamingAMFEndpoint;
import flex.messaging.endpoints.StreamingHTTPEndpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;

public class MessageBrokerControl
extends BaseControl
implements MessageBrokerControlMBean {
    private static final Object classMutex = new Object();
    private static final String TYPE = "MessageBroker";
    private static int instanceCount = 0;
    private String id;
    private MessageBroker broker;
    private List endpointNames;
    private List amfEndpoints;
    private List httpEndpoints;
    private List enterpriseEndpoints;
    private List streamingAmfEndpoints;
    private List streamingHttpEndpoints;
    private List services;
    private Integer flexSessionCount;
    private Integer maxFlexSessionsInCurrentHour;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBrokerControl(MessageBroker broker) {
        super(null);
        this.broker = broker;
        this.endpointNames = new ArrayList();
        this.amfEndpoints = new ArrayList();
        this.httpEndpoints = new ArrayList();
        this.enterpriseEndpoints = new ArrayList();
        this.streamingAmfEndpoints = new ArrayList();
        this.streamingHttpEndpoints = new ArrayList();
        this.services = new ArrayList();
        Object object = classMutex;
        synchronized (object) {
            this.id = TYPE + ++instanceCount;
        }
        this.setRegistrar(new AdminConsoleDisplayRegistrar(this));
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        this.getRegistrar().registerObject(2, name, "FlexSessionCount");
        this.getRegistrar().registerObjects(new int[]{2, 50}, name, new String[]{"AMFThroughput", "HTTPThroughput", "EnterpriseThroughput"});
        this.getRegistrar().registerObject(1, name, "MaxFlexSessionsInCurrentHour");
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return TYPE;
    }

    public Boolean isRunning() {
        return this.broker.isStarted();
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public ObjectName[] getEndpoints() throws IOException {
        int size = this.endpointNames.size();
        ObjectName[] endpointNameObjects = new ObjectName[size];
        for (int i2 = 0; i2 < size; ++i2) {
            endpointNameObjects[i2] = (ObjectName)this.endpointNames.get(i2);
        }
        return endpointNameObjects;
    }

    public void addEndpoint(Endpoint value) {
        if (value instanceof AMFEndpoint) {
            this.amfEndpoints.add(value);
        } else if (value instanceof HTTPEndpoint) {
            this.httpEndpoints.add(value);
        } else if (value instanceof StreamingAMFEndpoint) {
            this.streamingAmfEndpoints.add(value);
        } else if (value instanceof StreamingHTTPEndpoint) {
            this.streamingHttpEndpoints.add(value);
        } else {
            this.enterpriseEndpoints.add(value);
        }
        this.endpointNames.add(value.getControl().getObjectName());
    }

    public void removeEndpoint(ObjectName value) {
        this.endpointNames.remove(value);
    }

    public ObjectName[] getServices() throws IOException {
        int size = this.services.size();
        ObjectName[] serviceNames = new ObjectName[size];
        for (int i2 = 0; i2 < size; ++i2) {
            serviceNames[i2] = (ObjectName)this.services.get(i2);
        }
        return serviceNames;
    }

    public void addService(ObjectName value) {
        this.services.add(value);
    }

    public void removeService(ObjectName value) {
        this.services.remove(value);
    }

    public Integer getFlexSessionCount() {
        return this.flexSessionCount;
    }

    public void setFlexSessionCount(int connectionCount) {
        this.flexSessionCount = new Integer(connectionCount);
    }

    public Integer getMaxFlexSessionsInCurrentHour() {
        return this.maxFlexSessionsInCurrentHour;
    }

    public void setMaxFlexSessionsInCurrentHour(int currentConnectionCountMax) {
        this.maxFlexSessionsInCurrentHour = new Integer(currentConnectionCountMax);
    }

    public Integer getEnterpriseConnectionCount() throws IOException {
        int connections = 0;
        return new Integer(connections);
    }

    public Long getAMFThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.amfEndpoints));
    }

    public Long getHTTPThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.httpEndpoints));
    }

    public Long getEnterpriseThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.enterpriseEndpoints));
    }

    public Long getStreamingAMFThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.streamingAmfEndpoints));
    }

    public Long getStreamingHTTPThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.streamingHttpEndpoints));
    }

    private long calculateEndpointThroughput(List endpoints) {
        long throughput = 0L;
        for (int i2 = 0; i2 < endpoints.size(); ++i2) {
            if (!(endpoints.get(i2) instanceof AbstractEndpoint)) continue;
            throughput += ((AbstractEndpoint)endpoints.get(i2)).getThroughput();
        }
        return throughput;
    }
}

