/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private CSSRule _parentRule;
    private Vector _properties = new Vector();

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this._parentRule = parentRule;
    }

    public String getCssText() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("{");
        for (int i2 = 0; i2 < this._properties.size(); ++i2) {
            Property p2 = (Property)this._properties.elementAt(i2);
            if (p2 != null) {
                sb2.append(p2.toString());
            }
            if (i2 >= this._properties.size() - 1) continue;
            sb2.append("; ");
        }
        sb2.append("}");
        return sb2.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this._properties.removeAllElements();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e2) {
            throw new DOMExceptionImpl(12, 0, e2.getMessage());
        }
    }

    public String getPropertyValue(String propertyName) {
        Property p2 = this.getPropertyDeclaration(propertyName);
        return p2 != null ? p2.getValue().getCssText() : "";
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p2 = this.getPropertyDeclaration(propertyName);
        return p2 != null ? p2.getValue() : null;
    }

    public String removeProperty(String propertyName) throws DOMException {
        for (int i2 = 0; i2 < this._properties.size(); ++i2) {
            Property p2 = (Property)this._properties.elementAt(i2);
            if (!p2.getName().equalsIgnoreCase(propertyName)) continue;
            this._properties.removeElementAt(i2);
            return p2.getValue().toString();
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        Property p2 = this.getPropertyDeclaration(propertyName);
        if (p2 != null) {
            return p2.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            boolean important;
            InputSource is = new InputSource(new StringReader(value));
            CSSOMParser parser = new CSSOMParser();
            CSSValue expr = parser.parsePropertyValue(is);
            Property p2 = this.getPropertyDeclaration(propertyName);
            boolean bl = important = priority != null ? priority.equalsIgnoreCase("important") : false;
            if (p2 == null) {
                p2 = new Property(propertyName, expr, important);
                this.addProperty(p2);
            } else {
                p2.setValue(expr);
                p2.setImportant(important);
            }
        }
        catch (Exception e2) {
            throw new DOMExceptionImpl(12, 0, e2.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int index) {
        Property p2 = (Property)this._properties.elementAt(index);
        return p2 != null ? p2.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property p2) {
        this._properties.addElement(p2);
    }

    private Property getPropertyDeclaration(String name) {
        for (int i2 = 0; i2 < this._properties.size(); ++i2) {
            Property p2 = (Property)this._properties.elementAt(i2);
            if (!p2.getName().equalsIgnoreCase(name)) continue;
            return p2;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

