// Copyright (c) 2002-2010 Wieger Wesselink
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

/// \file sat/math_util.h
/// \brief Contains math utility functions

#ifndef SAT_MATH_UTIL_H
#define SAT_MATH_UTIL_H

#include <cmath>
#include <boost/cstdint.hpp>

namespace math {

//---------------------------------------------------------//
//                     print_as_int
//---------------------------------------------------------//
// prints x as an integer
std::string print_as_int(double x)
{
  boost::int64_t n = static_cast<boost::int64_t>(x + 0.5);
  std::ostringstream out;
  out << n;
  return out.str();
}

//---------------------------------------------------------//
//                     pow
//---------------------------------------------------------//
// returns m^n
template <typename T, typename U>
long pow(T m, U n)
{
  long result = 1; 
  for (int i = 0; i < n; i++)
    result *= m;
  return result;
}

//---------------------------------------------------------//
//                     pow2
//---------------------------------------------------------//
// returns 2^n
static inline
double pow2(int n)
{
  double result = 1; 
  for (int i = 0; i < n; i++)
    result *= 2;
  return result;
}

} // namespace math

#endif // SAT_MATH_UTIL_H
