/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.MappingDirect;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.StringConversion;
import org.jibx.binding.util.ArrayMap;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;

public class DefinitionContext {
    private final IContainer m_container;
    private final DefinitionContext m_context;
    private NamespaceDefinition m_attributeDefault;
    private NamespaceDefinition m_elementDefault;
    private ArrayList m_namespaces;
    private Map m_uriMap;
    private ArrayMap m_classMap;
    private ArrayList m_mappings;
    private Map m_convertMap;
    private Map m_formatMap;
    private Map m_namedStructureMap;

    public DefinitionContext(IContainer contain) {
        this.m_container = contain;
        this.m_context = contain.getDefinitionContext();
        this.m_convertMap = new HashMap();
        this.m_formatMap = new HashMap();
        if (this.m_context == null) {
            this.m_namedStructureMap = new HashMap();
        }
    }

    private boolean checkDuplicateNamespace(NamespaceDefinition def) {
        String uri;
        NamespaceDefinition prior;
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
            this.m_uriMap = new HashMap();
        }
        return (prior = (NamespaceDefinition)this.m_uriMap.get(uri = def.getUri())) != null && (prior.getPrefix() != null || def.getPrefix() == null);
    }

    private void internalAddNamespace(NamespaceDefinition def) {
        String uri = def.getUri();
        String prefix = def.getPrefix();
        def.setIndex(this.m_container.getBindingRoot().getNamespaceUriIndex(uri, prefix));
        this.m_namespaces.add(def);
        this.m_uriMap.put(uri, def);
    }

    public void addNamespace(NamespaceDefinition def) {
        if (def.isAttributeDefault()) {
            this.m_attributeDefault = def;
        }
        if (def.isElementDefault()) {
            this.m_elementDefault = def;
        }
        if (this.checkDuplicateNamespace(def)) {
            if (def.isAttributeDefault() || def.isElementDefault()) {
                NamespaceDefinition prior = this.m_uriMap.put(def.getUri(), def);
                def.setIndex(prior.getIndex());
            }
        } else {
            this.internalAddNamespace(def);
        }
    }

    public void addImpliedNamespace(NamespaceDefinition def) {
        if (!this.checkDuplicateNamespace(def)) {
            this.internalAddNamespace(def);
        }
    }

    public void addMapping(IMapping def) throws JiBXException {
        int index;
        String name;
        if (this.m_mappings == null) {
            this.m_classMap = new ArrayMap();
            this.m_mappings = new ArrayList();
        }
        if ((name = def.getTypeName()) == null) {
            name = def.getReferenceType();
        }
        if ((index = this.m_classMap.findOrAdd(name)) < this.m_mappings.size()) {
            if (def.getTypeName() == null) {
                throw new JiBXException("Conflicting mappings for class " + name);
            }
            throw new JiBXException("Conflicting mappings for type name " + name);
        }
        this.m_mappings.add(def);
    }

    public void addNamedStructure(String name, IComponent comp) throws JiBXException {
        if (this.m_namedStructureMap == null) {
            this.m_context.addNamedStructure(name, comp);
        } else {
            this.m_namedStructureMap.put(name, comp);
        }
    }

    private NamespaceDefinition getDefaultNamespace(boolean attr) {
        NamespaceDefinition ns = attr ? this.m_attributeDefault : this.m_elementDefault;
        if (ns == null && this.m_context != null) {
            ns = this.m_context.getDefaultNamespace(attr);
        }
        return ns;
    }

    public String getDefaultURI(boolean attr) {
        NamespaceDefinition ns = this.getDefaultNamespace(attr);
        if (ns == null) {
            return null;
        }
        return ns.getUri();
    }

    public int getDefaultIndex(boolean attr) {
        NamespaceDefinition ns = this.getDefaultNamespace(attr);
        if (ns == null) {
            return 0;
        }
        return ns.getIndex();
    }

    public int getNamespaceIndex(String uri, boolean attr) throws JiBXException {
        Object value;
        if (!(this.m_uriMap == null || (value = this.m_uriMap.get(uri)) == null || attr && ((NamespaceDefinition)value).getPrefix() == null)) {
            return ((NamespaceDefinition)value).getIndex();
        }
        if (this.m_context == null) {
            throw new JiBXException("Namespace URI \"" + uri + "\" not defined or not usable");
        }
        return this.m_context.getNamespaceIndex(uri, attr);
    }

    public IMapping getMappingAtLevel(String name) {
        int index;
        if (this.m_classMap != null && (index = this.m_classMap.find(name)) >= 0) {
            return (IMapping)this.m_mappings.get(index);
        }
        return null;
    }

    public IMapping getClassMapping(String name) {
        IMapping def = this.getMappingAtLevel(name);
        if (def == null && this.m_context != null) {
            def = this.m_context.getClassMapping(name);
        }
        return def;
    }

    public IComponent getNamedStructure(String name) throws JiBXException {
        IComponent comp = null;
        if (this.m_namedStructureMap != null) {
            comp = (IComponent)this.m_namedStructureMap.get(name);
        }
        if (comp == null) {
            if (this.m_context == null) {
                throw new JiBXException("Referenced label \"" + name + "\" not defined");
            }
            comp = this.m_context.getNamedStructure(name);
        }
        return comp;
    }

    public ArrayList getMappings() {
        return this.m_mappings;
    }

    public StringConversion getSpecificConversion(String name) {
        StringConversion conv = (StringConversion)this.m_convertMap.get(name);
        if (conv == null && this.m_context != null) {
            conv = this.m_context.getSpecificConversion(name);
        }
        return conv;
    }

    public StringConversion getConversion(ClassFile clas) {
        StringConversion conv = this.getSpecificConversion(clas.getName());
        if (conv == null) {
            return BindingDefinition.s_objectConversion;
        }
        return conv;
    }

    public StringConversion getNamedConversion(QName name) {
        StringConversion conv = (StringConversion)this.m_formatMap.get(name);
        if (conv == null && this.m_context != null) {
            conv = this.m_context.getNamedConversion(name);
        }
        return conv;
    }

    public void addConversion(QName name, StringConversion conv) throws JiBXException {
        if (this.m_formatMap.put(name, conv) != null) {
            throw new JiBXException("Duplicate conversion defined with name " + name);
        }
    }

    public void setConversion(StringConversion conv) throws JiBXException {
        if (this.m_convertMap.put(conv.getTypeName(), conv) != null) {
            throw new JiBXException("Duplicate conversion defined for type " + conv.getTypeName());
        }
    }

    public void setNamedConversion(QName name, StringConversion conv) throws JiBXException {
        this.addConversion(name, conv);
    }

    public void setDefaultConversion(QName name, StringConversion conv) throws JiBXException {
        this.addConversion(name, conv);
        this.setConversion(conv);
    }

    public boolean hasNamespace() {
        return this.m_namespaces != null && this.m_namespaces.size() > 0;
    }

    public ArrayList getNamespaces() {
        return this.m_namespaces;
    }

    private void genFillNamespaceIndexes(ArrayList nss, MethodBuilder mb) {
        if (nss != null) {
            for (int i = 0; i < nss.size(); ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                mb.appendLoadConstant(((NamespaceDefinition)nss.get(i)).getIndex());
                mb.appendIASTORE();
            }
        }
    }

    private void genFillNamespacePrefixes(ArrayList nss, MethodBuilder mb) {
        if (nss != null) {
            for (int i = 0; i < nss.size(); ++i) {
                mb.appendDUP();
                mb.appendLoadConstant(i);
                String prefix = ((NamespaceDefinition)nss.get(i)).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                mb.appendLoadConstant(prefix);
                mb.appendAASTORE();
            }
        }
    }

    public void genLoadNamespaces(MethodBuilder mb) {
        int count = this.m_namespaces == null ? 0 : this.m_namespaces.size();
        mb.appendLoadConstant(count);
        mb.appendCreateArray("int");
        this.genFillNamespaceIndexes(this.m_namespaces, mb);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        this.genFillNamespacePrefixes(this.m_namespaces, mb);
    }

    public void generateCode(boolean verbose, boolean force) throws JiBXException {
        if (this.m_mappings != null) {
            for (int i = 0; i < this.m_mappings.size(); ++i) {
                IMapping mapping = (IMapping)this.m_mappings.get(i);
                if (verbose) {
                    System.out.println("Generating code for mapping " + mapping.getBoundType());
                }
                ((IMapping)this.m_mappings.get(i)).generateCode(force);
            }
        }
    }

    public void linkMappings() throws JiBXException {
        if (this.m_mappings != null) {
            for (int i = 0; i < this.m_mappings.size(); ++i) {
                Object obj = this.m_mappings.get(i);
                if (!(obj instanceof MappingDefinition)) continue;
                ((MappingDefinition)obj).linkMappings();
            }
        }
    }

    public void setLinkages() throws JiBXException {
        if (this.m_mappings != null) {
            for (int i = 0; i < this.m_mappings.size(); ++i) {
                Object obj = this.m_mappings.get(i);
                if (!(obj instanceof MappingDefinition)) continue;
                ((MappingDefinition)obj).setLinkages();
            }
        }
    }

    public void print(int depth) {
        int i;
        BindingDefinition.indent(depth);
        System.out.print("context");
        if (this.m_namespaces != null) {
            System.out.print(" (ns#=" + this.m_namespaces.size() + ')');
        }
        if (this.m_mappings != null) {
            System.out.print(" (mp#=" + this.m_mappings.size() + ')');
        }
        if (this.m_namedStructureMap != null) {
            System.out.print(" (nm#=" + this.m_namedStructureMap.size() + ')');
        }
        if (this.m_convertMap != null) {
            System.out.print(" (cv#=" + this.m_convertMap.size() + ')');
        }
        if (this.m_formatMap != null) {
            System.out.print(" (fm#=" + this.m_formatMap.size() + ')');
        }
        System.out.println();
        if (this.m_namespaces != null) {
            for (i = 0; i < this.m_namespaces.size(); ++i) {
                NamespaceDefinition ndef = (NamespaceDefinition)this.m_namespaces.get(i);
                ndef.print(depth + 1);
            }
        }
        if (this.m_mappings != null) {
            for (i = 0; i < this.m_mappings.size(); ++i) {
                Object obj = this.m_mappings.get(i);
                if (obj instanceof MappingDefinition) {
                    MappingDefinition mdef = (MappingDefinition)obj;
                    mdef.print(depth + 1);
                    continue;
                }
                if (obj instanceof MappingDirect) {
                    MappingDirect mdir = (MappingDirect)obj;
                    mdir.print(depth + 1);
                    continue;
                }
                BindingDefinition.indent(depth + 1);
                System.out.println("unexpected type " + obj.getClass().getName());
            }
        }
    }
}

