/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.PrimitiveTypeWrapper;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaCompiler {
    public static final int COMPONENT_TYPE = 1;
    public static final int COMPONENT_ELEMENT = 2;
    public static final int COMPONENT_ATTRIBUTE = 3;
    public static final int COMPONENT_ATTRIBUTE_GROUP = 4;
    public static final int COMPONENT_GROUP = 5;
    private static final Log log = LogFactory.getLog(SchemaCompiler.class);
    private CompilerOptions options;
    private HashMap<QName, String> processedTypemap;
    private HashMap<QName, String> processedGroupTypeMap;
    private HashMap<QName, String> processedElementMap;
    private HashMap<XmlSchemaElement, BeanWriterMetaInfoHolder> processedAnonymousComplexTypesMap;
    private HashMap<QName, String> processedElementRefMap;
    private HashMap<QName, String> simpleTypesMap;
    private HashMap<QName, QName> changedTypeMap;
    private HashSet<XmlSchemaSimpleType> changedSimpleTypeSet;
    private HashSet<XmlSchemaComplexType> changedComplexTypeSet;
    private HashSet<XmlSchemaElement> changedElementSet;
    private HashMap<QName, BeanWriterMetaInfoHolder> processedTypeMetaInfoMap;
    private ArrayList<QName> processedElementList;
    private List<QName> nillableElementList;
    private BeanWriter writer = null;
    private Map<QName, String> baseSchemaTypeMap = null;
    private Map<String, XmlSchema> loadedSchemaMap = new HashMap<String, XmlSchema>();
    private Map<String, XmlSchema> availableSchemaMap = new HashMap<String, XmlSchema>();
    private Map<String, String> loadedSourceURI = new HashMap<String, String>();
    public static final String ANY_ELEMENT_FIELD_NAME = "extraElement";
    public static final String EXTRA_ATTRIBUTE_FIELD_NAME = "extraAttributes";
    public static final String USE_OPTIONAL = "optional";
    public static final String USE_REQUIRED = "required";
    public static final String USE_NONE = "none";
    HashMap<String, Integer> mapTypeCount = new HashMap();

    public HashMap<QName, String> getProcessedElementMap() {
        return this.processedElementMap;
    }

    public Map getProcessedModelMap() {
        return this.writer.getModelMap();
    }

    public SchemaCompiler(CompilerOptions options) throws SchemaCompilationException {
        this.options = options == null ? new CompilerOptions() : options;
        Map<String, String> nsp2PackageMap = this.options.getNs2PackageMap();
        if (nsp2PackageMap == null) {
            nsp2PackageMap = new HashMap<String, String>();
            this.options.setNs2PackageMap(nsp2PackageMap);
        }
        if (!nsp2PackageMap.containsKey("")) {
            nsp2PackageMap.put("", "axis2.apache.org");
        }
        this.processedTypemap = new HashMap();
        this.processedGroupTypeMap = new HashMap();
        this.processedElementMap = new HashMap();
        this.simpleTypesMap = new HashMap();
        this.processedElementList = new ArrayList();
        this.processedAnonymousComplexTypesMap = new HashMap();
        this.changedTypeMap = new HashMap();
        this.processedTypeMetaInfoMap = new HashMap();
        this.processedElementRefMap = new HashMap();
        this.nillableElementList = new ArrayList<QName>();
        this.changedComplexTypeSet = new HashSet();
        this.changedSimpleTypeSet = new HashSet();
        this.changedElementSet = new HashSet();
        this.writer = SchemaPropertyLoader.getBeanWriterInstance();
        this.writer.init(this.options);
        this.baseSchemaTypeMap = SchemaPropertyLoader.getTypeMapperInstance().getTypeMap();
        this.processedTypemap.putAll(SchemaPropertyLoader.getTypeMapperInstance().getSoapEncodingTypesMap());
    }

    public void compile(List<XmlSchema> schemalist) throws SchemaCompilationException {
        try {
            if (schemalist.isEmpty()) {
                return;
            }
            this.loadedSchemaMap.clear();
            this.availableSchemaMap.clear();
            for (XmlSchema schema : schemalist) {
                this.availableSchemaMap.put(schema.getTargetNamespace(), schema);
            }
            if (this.writer.getExtensionMapperPackageName() == null) {
                XmlSchema schema;
                String nsp = null;
                Iterator<XmlSchema> i$ = schemalist.iterator();
                while (i$.hasNext() && ((nsp = (schema = i$.next()).getTargetNamespace()) == null || nsp.equals(""))) {
                    XmlSchema[] schemas = SchemaUtil.getAllSchemas((XmlSchema)schema);
                    for (int j = 0; schemas != null && j < schemas.length && (nsp = schemas[j].getTargetNamespace()) == null; ++j) {
                    }
                }
                if (nsp == null) {
                    nsp = "org.apache.axis2";
                }
                if (this.options.getNs2PackageMap() != null && this.options.getNs2PackageMap().containsKey(nsp)) {
                    this.writer.registerExtensionMapperPackageName(this.options.getNs2PackageMap().get(nsp));
                } else {
                    this.writer.registerExtensionMapperPackageName(nsp == null ? null : URLProcessor.makePackageName((String)nsp));
                }
            }
            for (XmlSchema schema : schemalist) {
                this.compile(schema, true);
            }
            this.finalizeSchemaCompilation();
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void compile(XmlSchema schema) throws SchemaCompilationException {
        this.compile(schema, false);
    }

    private void compile(XmlSchema schema, boolean isPartofGroup) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) {
            return;
        }
        if (!isPartofGroup && this.writer.getExtensionMapperPackageName() == null) {
            String ns = schema.getTargetNamespace();
            if (ns == null) {
                ns = "org.apache.axis2";
            }
            if (this.options.getNs2PackageMap() != null && this.options.getNs2PackageMap().containsKey(ns)) {
                this.writer.registerExtensionMapperPackageName(this.options.getNs2PackageMap().get(ns));
            } else {
                this.writer.registerExtensionMapperPackageName(URLProcessor.makePackageName((String)ns));
            }
        }
        if (!this.loadedSchemaMap.containsKey(schema.getTargetNamespace())) {
            this.loadedSchemaMap.put(schema.getTargetNamespace(), schema);
            if (schema.getTargetNamespace() == null) {
                this.loadedSchemaMap.put("", schema);
            }
        }
        if (schema.getSourceURI() != null) {
            String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
            if (this.loadedSourceURI.containsKey(key)) {
                return;
            }
            this.loadedSourceURI.put(key, key);
        }
        if ((includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport) {
                    XmlSchemaImport schemaImport = (XmlSchemaImport)o;
                    XmlSchema schema12 = schemaImport.getSchema();
                    if (schema12 != null) {
                        this.compile(schema12, isPartofGroup);
                    } else if (schemaImport.getNamespace().equals("http://www.w3.org/XML/1998/namespace")) {
                        schema12 = new XmlSchemaCollection().read(new InputSource(SchemaCompiler.class.getResource("namespace.xsd").toExternalForm()), null);
                        schemaImport.setSchema(schema12);
                        this.compile(schema12, isPartofGroup);
                    } else if (!schemaImport.getNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
                        log.warn((Object)("No schemaLocation for import of " + schemaImport.getNamespace() + "; compilation may fail"));
                    }
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                if (schema1.getTargetNamespace() == null) {
                    schema1.setTargetNamespace(schema.getTargetNamespace());
                }
                this.compile(schema1, isPartofGroup);
            }
        }
        XmlSchemaObjectTable elements = schema.getElements();
        Iterator xmlSchemaElement1Iterator = elements.getValues();
        while (xmlSchemaElement1Iterator.hasNext()) {
            this.processElement((XmlSchemaElement)xmlSchemaElement1Iterator.next(), schema);
        }
        Iterator xmlSchemaElement2Iterator = elements.getValues();
        while (xmlSchemaElement2Iterator.hasNext()) {
            this.writeElement((XmlSchemaElement)xmlSchemaElement2Iterator.next());
        }
        if (this.options.isGenerateAll()) {
            Iterator xmlSchemaTypes2Iterator = schema.getSchemaTypes().getValues();
            while (xmlSchemaTypes2Iterator.hasNext()) {
                XmlSchemaType schemaType = (XmlSchemaType)xmlSchemaTypes2Iterator.next();
                if (this.isAlreadyProcessed(schemaType.getQName())) continue;
                if (schemaType instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                    if (complexType.getName() == null) continue;
                    this.processNamedComplexSchemaType(complexType, schema);
                    continue;
                }
                if (!(schemaType instanceof XmlSchemaSimpleType)) continue;
                this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, null, schema, null);
            }
        }
        if (!isPartofGroup) {
            this.finalizeSchemaCompilation();
        }
    }

    private void finalizeSchemaCompilation() throws SchemaCompilationException {
        this.writer.writeExtensionMapper(this.processedTypeMetaInfoMap.values().toArray(new BeanWriterMetaInfoHolder[this.processedTypeMetaInfoMap.size()]));
        if (this.options.isWrapClasses()) {
            this.writer.writeBatch();
        }
        for (XmlSchemaComplexType xmlSchemaComplexType : this.changedComplexTypeSet) {
            xmlSchemaComplexType.setName(null);
        }
        for (XmlSchemaSimpleType xmlSchemaSimpleType : this.changedSimpleTypeSet) {
            xmlSchemaSimpleType.setName(null);
        }
        for (XmlSchemaElement xmlSchemaElement : this.changedElementSet) {
            xmlSchemaElement.setSchemaTypeName(null);
        }
    }

    public Properties getCompilerProperties() {
        return SchemaPropertyLoader.getPropertyMap();
    }

    private void writeElement(XmlSchemaElement xsElt) throws SchemaCompilationException {
        QName qName;
        if (this.processedElementMap.containsKey(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        BeanWriterMetaInfoHolder metainf = new BeanWriterMetaInfoHolder();
        if (schemaType != null && schemaType.getName() != null) {
            qName = schemaType.getQName();
            String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
            if (this.options.isUseWrapperClasses() && PrimitiveTypeFinder.isPrimitive(className)) {
                className = PrimitiveTypeWrapper.getWrapper(className);
            }
            if (this.changedTypeMap.containsKey(qName)) {
                metainf.registerMapping(xsElt.getQName(), this.changedTypeMap.get(qName), className);
            } else {
                metainf.registerMapping(xsElt.getQName(), qName, className);
            }
            if (xsElt.getDefaultValue() != null) {
                metainf.registerDefaultValue(xsElt.getQName(), xsElt.getDefaultValue());
            }
            if (this.isBinary(xsElt)) {
                metainf.addtStatus(xsElt.getQName(), 16);
            }
        } else if (xsElt.getRefName() == null) {
            if (xsElt.getSchemaTypeName() != null) {
                qName = xsElt.getSchemaTypeName();
                String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
                metainf.registerMapping(xsElt.getQName(), qName, className);
            } else if (schemaType != null) {
                metainf = this.processedAnonymousComplexTypesMap.get(xsElt);
                metainf.setAnonymous(true);
            } else {
                log.warn((Object)SchemaCompilerMessages.getMessage("schema.elementWithNoType", xsElt.getQName().toString()));
                metainf.registerMapping(xsElt.getQName(), null, this.writer.getDefaultClassName(), 8);
            }
        }
        if (this.nillableElementList.contains(xsElt.getQName())) {
            metainf.registerNillableQName(xsElt.getQName());
        }
        String writtenClassName = this.writer.write(xsElt, this.processedTypemap, this.processedGroupTypeMap, metainf);
        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)writtenClassName);
        this.processedElementMap.put(xsElt.getQName(), writtenClassName);
    }

    private void processElement(XmlSchemaElement xsElt, Map<QName, String> innerElementMap, List<QName> localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, false, innerElementMap, localNillableList, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, true, null, null, parentSchema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processElement(XmlSchemaElement xsElt, boolean isOuter, Map<QName, String> innerElementMap, List<QName> localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        if (xsElt == null) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.elementNull"));
        }
        if (isOuter && this.processedElementList.contains(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            this.processSchema(xsElt, schemaType, parentSchema, false);
            if (!isOuter) {
                if (schemaType.getName() != null) {
                    String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                    if (this.options.isUseWrapperClasses() && PrimitiveTypeFinder.isPrimitive(className)) {
                        className = PrimitiveTypeWrapper.getWrapper(className);
                    }
                    schemaType.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    if (this.baseSchemaTypeMap.containsValue(className)) {
                        schemaType.addMetaInfo((Object)"CLASS_NAME_PRIMITIVE", (Object)Boolean.TRUE);
                    }
                } else {
                    QName generatedTypeName = this.generateTypeQName(xsElt.getQName(), parentSchema);
                    if (schemaType instanceof XmlSchemaComplexType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        this.changedComplexTypeSet.add((XmlSchemaComplexType)schemaType);
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeComplexType((XmlSchemaComplexType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    } else if (schemaType instanceof XmlSchemaSimpleType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        this.changedSimpleTypeSet.add((XmlSchemaSimpleType)schemaType);
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeSimpleType((XmlSchemaSimpleType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    }
                }
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        } else if (xsElt.getRefName() != null) {
            if (xsElt.getRefName().equals(SchemaConstants.XSD_SCHEMA)) {
                innerElementMap.put(xsElt.getQName(), this.writer.getDefaultClassName());
                return;
            }
            XmlSchema resolvedSchema = this.getParentSchema(parentSchema, xsElt.getRefName(), 2);
            if (resolvedSchema == null) {
                throw new SchemaCompilationException("can not find the element " + xsElt.getRefName() + " from the parent schema " + parentSchema.getTargetNamespace());
            }
            XmlSchemaElement referencedElement = resolvedSchema.getElementByName(xsElt.getRefName());
            if (referencedElement == null) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", xsElt.getRefName().toString()));
            }
            if (referencedElement.getSchemaType() != null && referencedElement.getSchemaType().getQName() != null) {
                if (!this.processedElementRefMap.containsKey(referencedElement.getQName())) {
                    if (this.baseSchemaTypeMap.containsKey(referencedElement.getSchemaTypeName())) {
                        this.processedElementRefMap.put(referencedElement.getQName(), this.baseSchemaTypeMap.get(referencedElement.getSchemaTypeName()));
                    } else {
                        XmlSchema resolvedTypeSchema = this.getParentSchema(resolvedSchema, referencedElement.getSchemaTypeName(), 1);
                        XmlSchemaType xmlSchemaType = resolvedTypeSchema.getTypeByName(referencedElement.getSchemaTypeName().getLocalPart());
                        this.processSchema(referencedElement, xmlSchemaType, resolvedTypeSchema, true);
                        this.processedElementRefMap.put(referencedElement.getQName(), this.processedTypemap.get(referencedElement.getSchemaTypeName()));
                    }
                }
                if (!this.baseSchemaTypeMap.containsKey(referencedElement.getSchemaTypeName())) {
                    String javaClassName = this.processedTypemap.get(referencedElement.getSchemaTypeName());
                    referencedElement.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
                    xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
                }
            } else if (referencedElement.getSchemaType() != null) {
                if (!this.processedElementRefMap.containsKey(referencedElement.getQName())) {
                    this.processSchema(referencedElement, referencedElement.getSchemaType(), resolvedSchema, true);
                    this.processedElementRefMap.put(referencedElement.getQName(), this.processedTypemap.get(referencedElement.getSchemaTypeName()));
                }
                String javaClassName = this.processedTypemap.get(referencedElement.getSchemaTypeName());
                referencedElement.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
                xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
            } else if (referencedElement.getSchemaTypeName() != null) {
                QName schemaTypeName = referencedElement.getSchemaTypeName();
                XmlSchema newResolvedSchema = this.getParentSchema(resolvedSchema, schemaTypeName, 1);
                XmlSchemaType xmlSchemaType = newResolvedSchema.getTypeByName(schemaTypeName);
                if (xmlSchemaType == null) throw new SchemaCompilationException(" Can not find the schema type with name " + schemaTypeName);
                if (!this.processedElementRefMap.containsKey(referencedElement.getQName())) {
                    this.processSchema(referencedElement, xmlSchemaType, newResolvedSchema, false);
                    this.processedElementRefMap.put(referencedElement.getQName(), this.processedTypemap.get(schemaTypeName));
                }
                String javaClassName = this.processedTypemap.get(referencedElement.getSchemaTypeName());
                referencedElement.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
                xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
            }
        } else if (xsElt.getSchemaTypeName() != null) {
            QName schemaTypeName = xsElt.getSchemaTypeName();
            XmlSchema resolvedSchema = this.getParentSchema(parentSchema, schemaTypeName, 1);
            XmlSchemaType typeByName = null;
            if (resolvedSchema != null) {
                typeByName = resolvedSchema.getTypeByName(schemaTypeName);
            }
            if (typeByName != null) {
                this.processSchema(xsElt, typeByName, resolvedSchema, false);
                if (!isOuter) {
                    String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                    xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                } else {
                    this.processedElementList.add(xsElt.getQName());
                }
            } else if (!isOuter) {
                String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                innerElementMap.put(xsElt.getQName(), className);
                xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        }
        if (!xsElt.isNillable()) return;
        if (isOuter) {
            this.nillableElementList.add(xsElt.getQName());
            return;
        } else {
            localNillableList.add(xsElt.getQName());
        }
    }

    private QName generateTypeQName(QName referenceEltQName, XmlSchema parentSchema) {
        QName generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix(referenceEltQName.getLocalPart()));
        while (parentSchema.getTypeByName(generatedTypeName) != null) {
            generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix(referenceEltQName.getLocalPart()));
        }
        return generatedTypeName;
    }

    private boolean isAlreadyProcessed(QName qName) {
        return this.processedTypemap.containsKey(qName) || this.simpleTypesMap.containsKey(qName) || this.baseSchemaTypeMap.containsKey(qName) || this.processedGroupTypeMap.containsKey(qName);
    }

    private String findRefClassName(QName name, boolean isArray) {
        String className = null;
        if (this.processedElementRefMap.get(name) != null) {
            className = this.processedElementRefMap.get(name);
            if (isArray) {
                className = className + "[]";
            }
        }
        return className;
    }

    private String findClassName(QName qName, boolean isArray) throws SchemaCompilationException {
        String className;
        if (this.processedTypemap.containsKey(qName)) {
            className = this.processedTypemap.get(qName);
        } else if (this.simpleTypesMap.containsKey(qName)) {
            className = this.simpleTypesMap.get(qName);
        } else if (this.baseSchemaTypeMap.containsKey(qName)) {
            className = this.baseSchemaTypeMap.get(qName);
        } else {
            if (SchemaCompiler.isSOAP_ENC(qName.getNamespaceURI())) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.soapencoding.error", qName.toString()));
            }
            className = this.writer.getDefaultClassName();
            log.warn((Object)SchemaCompilerMessages.getMessage("schema.typeMissing", qName.toString()));
        }
        if (isArray) {
            className = className + "[]";
        }
        return className;
    }

    public static boolean isSOAP_ENC(String s) {
        if (s.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return true;
        }
        return s.equals("http://www.w3.org/2003/05/soap-encoding");
    }

    private void processSchema(XmlSchemaElement xsElt, XmlSchemaType schemaType, XmlSchema parentSchema, boolean isWriteAnonComplexType) throws SchemaCompilationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            if (complexType.getName() != null && !this.changedComplexTypeSet.contains(schemaType)) {
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, complexType.getQName(), 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find the parent schema for the complex type " + complexType.getQName() + " from the parent schema " + parentSchema.getTargetNamespace());
                }
                this.processNamedComplexSchemaType(complexType, resolvedSchema);
            } else {
                this.processAnonymousComplexSchemaType(xsElt, complexType, parentSchema, isWriteAnonComplexType);
            }
        } else if (schemaType instanceof XmlSchemaSimpleType) {
            this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, xsElt, parentSchema, null);
        }
    }

    private void processAnonymousComplexSchemaType(XmlSchemaElement elt, XmlSchemaComplexType complexType, XmlSchema parentSchema, boolean isWriteAnonComplexType) throws SchemaCompilationException {
        QName generatedTypeName = null;
        String javaClassName = null;
        if (isWriteAnonComplexType) {
            generatedTypeName = this.generateTypeQName(elt.getQName(), parentSchema);
            if (elt.getSchemaTypeName() == null) {
                elt.setSchemaTypeName(generatedTypeName);
                this.changedElementSet.add(elt);
            }
            complexType.setName(generatedTypeName.getLocalPart());
            this.changedComplexTypeSet.add(complexType);
            javaClassName = this.writer.makeFullyQualifiedClassName(generatedTypeName);
            this.processedTypemap.put(generatedTypeName, javaClassName);
            this.processedElementRefMap.put(elt.getQName(), javaClassName);
            complexType.addMetaInfo((Object)"CLASS_NAME", (Object)javaClassName);
        }
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(elt.getQName(), complexType, parentSchema);
        if (isWriteAnonComplexType) {
            metaInfHolder.setOwnClassName(javaClassName);
            metaInfHolder.setOwnQname(generatedTypeName);
            this.writeComplexType(complexType, metaInfHolder);
        }
        this.processedAnonymousComplexTypesMap.put(elt, metaInfHolder);
    }

    private void processNamedComplexSchemaType(XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(complexType.getQName()) || this.baseSchemaTypeMap.containsKey(complexType.getQName())) {
            return;
        }
        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(complexType.getQName());
        this.processedTypemap.put(complexType.getQName(), fullyQualifiedClassName);
        complexType.addMetaInfo((Object)"CLASS_NAME", (Object)fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType.getQName(), complexType, parentSchema);
        metaInfHolder.setOwnQname(complexType.getQName());
        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        this.writeComplexType(complexType, metaInfHolder);
    }

    private String writeComplexType(XmlSchemaComplexType complexType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        String javaClassName = this.writer.write(complexType.getQName(), this.processedTypemap, this.processedGroupTypeMap, metaInfHolder, complexType.isAbstract());
        this.processedTypeMetaInfoMap.put(complexType.getQName(), metaInfHolder);
        return javaClassName;
    }

    private String writeComplexParticle(QName qname, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        String javaClassName = this.writer.write(qname, this.processedTypemap, this.processedGroupTypeMap, metaInfHolder, false);
        this.processedTypeMetaInfoMap.put(qname, metaInfHolder);
        return javaClassName;
    }

    private void writeSimpleType(XmlSchemaSimpleType simpleType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        this.writer.write(simpleType, this.processedTypemap, this.processedGroupTypeMap, metaInfHolder);
        this.processedTypeMetaInfoMap.put(simpleType.getQName(), metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processComplexType(QName parentElementQName, XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaParticle particle = complexType.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle != null) {
            this.processParticle(parentElementQName, particle, metaInfHolder, parentSchema);
        }
        this.processAttributes(complexType.getAttributes(), metaInfHolder, parentSchema);
        XmlSchemaAnyAttribute anyAtt = complexType.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder, anyAtt);
        }
        if (complexType.getContentModel() != null) {
            this.processContentModel(complexType.getContentModel(), metaInfHolder, parentSchema);
        }
        return metaInfHolder;
    }

    private void processAttributes(XmlSchemaObjectCollection attributes, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        Iterator attribIterator = attributes.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (o instanceof XmlSchemaAttribute) {
                this.processAttribute((XmlSchemaAttribute)o, metaInfHolder, parentSchema);
                continue;
            }
            if (!(o instanceof XmlSchemaAttributeGroupRef)) continue;
            this.processAttributeGroupReference((XmlSchemaAttributeGroupRef)o, metaInfHolder, parentSchema);
        }
    }

    private void processAttributeGroupReference(XmlSchemaAttributeGroupRef attributeGroupRef, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaAttributeGroup xmlSchemaAttributeGroup;
        XmlSchema resolvedSchema;
        QName attributeGroupRefName = attributeGroupRef.getRefName();
        if (attributeGroupRefName != null) {
            resolvedSchema = this.getParentSchema(parentSchema, attributeGroupRefName, 4);
            if (resolvedSchema == null) {
                throw new SchemaCompilationException("can not find the attribute group reference name " + attributeGroupRefName + " from the parent schema " + parentSchema.getTargetNamespace());
            }
            xmlSchemaAttributeGroup = (XmlSchemaAttributeGroup)resolvedSchema.getAttributeGroups().getItem(attributeGroupRefName);
            if (xmlSchemaAttributeGroup == null) {
                throw new SchemaCompilationException("Can not find an attribute group for group reference " + attributeGroupRefName.getLocalPart());
            }
        } else {
            throw new SchemaCompilationException("No group refernce has given");
        }
        this.processAttributes(xmlSchemaAttributeGroup.getAttributes(), metaInfHolder, resolvedSchema);
    }

    private void processContentModel(XmlSchemaContentModel content, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (content instanceof XmlSchemaComplexContent) {
            this.processComplexContent((XmlSchemaComplexContent)content, metaInfHolder, parentSchema);
        } else if (content instanceof XmlSchemaSimpleContent) {
            this.processSimpleContent((XmlSchemaSimpleContent)content, metaInfHolder, parentSchema);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComplexContent(XmlSchemaComplexContent complexContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = complexContent.getContent();
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, extension.getBaseTypeName(), 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find the compley type " + extension.getBaseTypeName() + " from the parent type " + parentSchema.getTargetNamespace());
                }
                XmlSchemaType type = resolvedSchema.getTypeByName(extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType, resolvedSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, resolvedSchema, null);
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, extension.getBaseTypeName(), parentSchema);
            if (extension.getParticle() != null) {
                this.processParticle(extension.getBaseTypeName(), extension.getParticle(), metaInfHolder, parentSchema);
            }
            this.processAttributes(extension.getAttributes(), metaInfHolder, parentSchema);
            XmlSchemaAnyAttribute anyAtt = extension.getAnyAttribute();
            if (anyAtt != null) {
                this.processAnyAttribute(metaInfHolder, anyAtt);
            }
            String className = this.findClassName(extension.getBaseTypeName(), false);
            if (this.writer.getDefaultClassName().equals(className)) return;
            metaInfHolder.setExtension(true);
            metaInfHolder.setExtensionClassName(className);
            return;
        } else {
            if (!(content instanceof XmlSchemaComplexContentRestriction)) return;
            XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, restriction.getBaseTypeName(), 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find the complex type " + restriction.getBaseTypeName() + " from the parent type " + parentSchema.getTargetNamespace());
                }
                XmlSchemaType type = resolvedSchema.getTypeByName(restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType, resolvedSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    throw new SchemaCompilationException("Not a valid restriction, complex content restriction base type cannot be a simple type.");
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, restriction.getBaseTypeName(), parentSchema);
            this.processParticle(restriction.getBaseTypeName(), restriction.getParticle(), metaInfHolder, parentSchema);
            this.processAttributes(restriction.getAttributes(), metaInfHolder, parentSchema);
            XmlSchemaAnyAttribute anyAtt = restriction.getAnyAttribute();
            if (anyAtt != null) {
                this.processAnyAttribute(metaInfHolder, anyAtt);
            }
            String className = this.findClassName(restriction.getBaseTypeName(), false);
            if (this.writer.getDefaultClassName().equals(className)) return;
            metaInfHolder.setRestriction(true);
            metaInfHolder.setRestrictionClassName(this.findClassName(restriction.getBaseTypeName(), false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyMetaInfoHierarchy(BeanWriterMetaInfoHolder metaInfHolder, QName baseTypeName, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchema resolvedSchema = this.getParentSchema(parentSchema, baseTypeName, 1);
        if (resolvedSchema == null) {
            throw new SchemaCompilationException("can not find type " + baseTypeName + " from the parent schema " + parentSchema.getTargetNamespace());
        }
        XmlSchemaType type = resolvedSchema.getTypeByName(baseTypeName);
        BeanWriterMetaInfoHolder baseMetaInfoHolder = this.processedTypeMetaInfoMap.get(baseTypeName);
        if (baseMetaInfoHolder == null) return;
        if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
            if (complexType.getContentModel() != null) {
                XmlSchemaContentModel content = complexType.getContentModel();
                if (content instanceof XmlSchemaComplexContent) {
                    XmlSchemaComplexContent complexContent = (XmlSchemaComplexContent)content;
                    if (complexContent.getContent() instanceof XmlSchemaComplexContentExtension) {
                        XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)complexContent.getContent();
                        this.copyMetaInfoHierarchy(baseMetaInfoHolder, extension.getBaseTypeName(), resolvedSchema);
                    } else {
                        if (!(complexContent.getContent() instanceof XmlSchemaComplexContentRestriction)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                        XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)complexContent.getContent();
                        this.copyMetaInfoHierarchy(baseMetaInfoHolder, restriction.getBaseTypeName(), resolvedSchema);
                    }
                } else {
                    if (!(content instanceof XmlSchemaSimpleContent)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content"));
                }
            }
            metaInfHolder.setAsParent(baseMetaInfoHolder);
            return;
        } else {
            if (!(type instanceof XmlSchemaSimpleType)) return;
            if (baseMetaInfoHolder.isUnion()) {
                metaInfHolder.setUnion(true);
                for (Map.Entry<QName, String> entry : baseMetaInfoHolder.getMemberTypes().entrySet()) {
                    metaInfHolder.addMemberType(entry.getKey(), entry.getValue());
                }
            }
            if (baseMetaInfoHolder.isList()) {
                metaInfHolder.setList(true);
                metaInfHolder.setItemTypeQName(baseMetaInfoHolder.getItemTypeQName());
                metaInfHolder.setItemTypeClassName(baseMetaInfoHolder.getItemTypeClassName());
            }
            metaInfHolder.setAsParent(baseMetaInfoHolder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSimpleContent(XmlSchemaSimpleContent simpleContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = simpleContent.getContent();
        if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, extension.getBaseTypeName(), 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find type " + extension.getBaseTypeName() + " from the parent schema " + parentSchema.getTargetNamespace());
                }
                XmlSchemaType type = resolvedSchema.getTypeByName(extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType, resolvedSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, resolvedSchema, null);
                }
            }
            this.processSimpleExtensionBaseType(extension.getBaseTypeName(), metaInfHolder, parentSchema);
            XmlSchemaObjectCollection attribs = extension.getAttributes();
            Iterator attribIterator = attribs.getIterator();
            while (attribIterator.hasNext()) {
                Object attr = attribIterator.next();
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                this.processAttribute((XmlSchemaAttribute)attr, metaInfHolder, parentSchema);
            }
            XmlSchemaAnyAttribute anyAtt = extension.getAnyAttribute();
            if (anyAtt == null) return;
            this.processAnyAttribute(metaInfHolder, anyAtt);
            return;
        } else {
            if (!(content instanceof XmlSchemaSimpleContentRestriction)) return;
            XmlSchemaSimpleContentRestriction restriction = (XmlSchemaSimpleContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, restriction.getBaseTypeName(), 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find type " + restriction.getBaseTypeName() + " from the parent schema " + parentSchema.getTargetNamespace());
                }
                XmlSchemaType type = resolvedSchema.getTypeByName(restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType, resolvedSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, resolvedSchema, null);
                }
            }
            this.processSimpleRestrictionBaseType(restriction.getBaseTypeName(), restriction.getBaseTypeName(), metaInfHolder, parentSchema);
            metaInfHolder.setSimple(true);
        }
    }

    public void processSimpleExtensionBaseType(QName extBaseType, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        String className = this.findClassName(extBaseType, false);
        if (this.baseSchemaTypeMap.containsKey(extBaseType)) {
            if (this.changedTypeMap.containsKey(extBaseType)) {
                metaInfHolder.registerMapping(extBaseType, this.changedTypeMap.get(extBaseType), className, 2);
            } else {
                metaInfHolder.registerMapping(extBaseType, extBaseType, className, 2);
            }
            metaInfHolder.setSimple(true);
        } else if (this.processedTypemap.containsKey(extBaseType)) {
            XmlSchemaComplexType complexType;
            XmlSchema resolvedSchema = this.getParentSchema(parentSchema, extBaseType, 1);
            if (resolvedSchema == null) {
                throw new SchemaCompilationException("can not find the type " + extBaseType + " from the parent schema " + parentSchema.getTargetNamespace());
            }
            XmlSchemaType type = resolvedSchema.getTypeByName(extBaseType);
            if (type instanceof XmlSchemaSimpleType) {
                metaInfHolder.setSimple(true);
                metaInfHolder.setExtension(true);
                metaInfHolder.setExtensionClassName(className);
                this.copyMetaInfoHierarchy(metaInfHolder, extBaseType, resolvedSchema);
            } else if (type instanceof XmlSchemaComplexType && (complexType = (XmlSchemaComplexType)type).getContentModel() == null) {
                metaInfHolder.setExtension(true);
                metaInfHolder.setExtensionClassName(className);
                this.copyMetaInfoHierarchy(metaInfHolder, extBaseType, resolvedSchema);
            }
        } else {
            metaInfHolder.setSimple(true);
        }
        if (this.isBinary(extBaseType)) {
            metaInfHolder.addtStatus(extBaseType, 16);
        }
    }

    public void processSimpleRestrictionBaseType(QName qName, QName resBaseType, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        String className = this.findClassName(resBaseType, false);
        if (this.baseSchemaTypeMap.containsKey(resBaseType)) {
            if (this.changedTypeMap.containsKey(resBaseType)) {
                metaInfHolder.registerMapping(qName, this.changedTypeMap.get(resBaseType), className, 2);
            } else {
                metaInfHolder.registerMapping(qName, resBaseType, className, 2);
            }
        } else if (this.processedTypemap.containsKey(resBaseType)) {
            metaInfHolder.setSimple(true);
            metaInfHolder.setRestriction(true);
            metaInfHolder.setRestrictionClassName(className);
            this.copyMetaInfoHierarchy(metaInfHolder, resBaseType, parentSchema);
        }
        metaInfHolder.setRestrictionBaseType(resBaseType);
    }

    private void processFacets(XmlSchemaSimpleTypeRestriction restriction, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) {
        XmlSchemaObjectCollection facets = restriction.getFacets();
        Iterator facetIterator = facets.getIterator();
        while (facetIterator.hasNext()) {
            Object obj = facetIterator.next();
            if (obj instanceof XmlSchemaPatternFacet) {
                XmlSchemaPatternFacet pattern = (XmlSchemaPatternFacet)obj;
                String patternString = pattern.getValue().toString();
                patternString = patternString.replaceAll("\\\\", "\\\\\\\\");
                patternString = patternString.replaceAll("\"", "\\\\\"");
                if (metaInfHolder.getPatternFacet() != null && metaInfHolder.getPatternFacet().trim().length() > 0) {
                    patternString = metaInfHolder.getPatternFacet().trim() + "|" + patternString;
                }
                metaInfHolder.setPatternFacet(patternString);
                continue;
            }
            if (obj instanceof XmlSchemaEnumerationFacet) {
                XmlSchemaEnumerationFacet enumeration = (XmlSchemaEnumerationFacet)obj;
                if (restriction.getBaseTypeName().equals(SchemaConstants.XSD_QNAME)) {
                    String value = enumeration.getValue().toString();
                    String prefix = value.substring(0, value.indexOf(":"));
                    String localPart = value.substring(value.indexOf(":") + 1);
                    String namespaceUri = parentSchema.getNamespaceContext().getNamespaceURI(prefix);
                    String qNameString = value + "\", \"" + namespaceUri;
                    metaInfHolder.addEnumFacet(qNameString);
                    continue;
                }
                metaInfHolder.addEnumFacet(enumeration.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaLengthFacet) {
                XmlSchemaLengthFacet length = (XmlSchemaLengthFacet)obj;
                metaInfHolder.setLengthFacet(Integer.parseInt(length.getValue().toString()));
                continue;
            }
            if (obj instanceof XmlSchemaMaxExclusiveFacet) {
                XmlSchemaMaxExclusiveFacet maxEx = (XmlSchemaMaxExclusiveFacet)obj;
                metaInfHolder.setMaxExclusiveFacet(maxEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinExclusiveFacet) {
                XmlSchemaMinExclusiveFacet minEx = (XmlSchemaMinExclusiveFacet)obj;
                metaInfHolder.setMinExclusiveFacet(minEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxInclusiveFacet) {
                XmlSchemaMaxInclusiveFacet maxIn = (XmlSchemaMaxInclusiveFacet)obj;
                metaInfHolder.setMaxInclusiveFacet(maxIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinInclusiveFacet) {
                XmlSchemaMinInclusiveFacet minIn = (XmlSchemaMinInclusiveFacet)obj;
                metaInfHolder.setMinInclusiveFacet(minIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxLengthFacet) {
                XmlSchemaMaxLengthFacet maxLen = (XmlSchemaMaxLengthFacet)obj;
                metaInfHolder.setMaxLengthFacet(Integer.parseInt(maxLen.getValue().toString()));
                continue;
            }
            if (!(obj instanceof XmlSchemaMinLengthFacet)) continue;
            XmlSchemaMinLengthFacet minLen = (XmlSchemaMinLengthFacet)obj;
            metaInfHolder.setMinLengthFacet(Integer.parseInt(minLen.getValue().toString()));
        }
    }

    private void processAnyAttribute(BeanWriterMetaInfoHolder metainf, XmlSchemaAnyAttribute anyAtt) {
        QName qName = new QName(EXTRA_ATTRIBUTE_FIELD_NAME);
        metainf.registerMapping(qName, null, this.writer.getDefaultAttribArrayClassName(), 8);
        metainf.addtStatus(qName, 1);
        metainf.addtStatus(qName, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAttribute(XmlSchemaAttribute att, BeanWriterMetaInfoHolder metainf, XmlSchema parentSchema) throws SchemaCompilationException {
        QName schemaTypeName = att.getSchemaTypeName();
        if (schemaTypeName != null) {
            if (att.getQName() == null) return;
            if (this.baseSchemaTypeMap.containsKey(schemaTypeName)) {
                metainf.registerMapping(att.getQName(), schemaTypeName, this.baseSchemaTypeMap.get(schemaTypeName).toString(), 1);
                String use = att.getUse().getValue();
                if (USE_NONE.equals(use) || USE_OPTIONAL.equals(use)) {
                    metainf.addtStatus(att.getQName(), 32);
                }
                String className = this.findClassName(schemaTypeName, false);
                att.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                if (att.getDefaultValue() == null) return;
                metainf.registerDefaultValue(att.getQName(), att.getDefaultValue());
                return;
            } else {
                XmlSchemaSimpleType simpleType;
                XmlSchema resolvedSchema = this.getParentSchema(parentSchema, schemaTypeName, 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find the type " + schemaTypeName + " from the parent schema " + parentSchema.getTargetNamespace());
                }
                XmlSchemaType type = resolvedSchema.getTypeByName(schemaTypeName);
                if (!(type instanceof XmlSchemaSimpleType) || (simpleType = (XmlSchemaSimpleType)type) == null) return;
                if (!this.isAlreadyProcessed(schemaTypeName)) {
                    this.processSimpleSchemaType(simpleType, null, resolvedSchema, null);
                }
                metainf.registerMapping(att.getQName(), schemaTypeName, this.processedTypemap.get(schemaTypeName).toString(), 1);
                String use = att.getUse().getValue();
                if (!USE_NONE.equals(use) && !USE_OPTIONAL.equals(use)) return;
                metainf.addtStatus(att.getQName(), 32);
            }
            return;
        } else if (att.getRefName() != null) {
            XmlSchema resolvedSchema = this.getParentSchema(parentSchema, att.getRefName(), 3);
            if (resolvedSchema == null) {
                throw new SchemaCompilationException("can not find the attribute " + att.getRefName() + " from the parent schema " + parentSchema.getTargetNamespace());
            }
            XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)resolvedSchema.getAttributes().getItem(att.getRefName());
            if (xmlSchemaAttribute == null) throw new SchemaCompilationException("Attribute QName reference refer to an invalid attribute " + att.getRefName());
            this.processAttribute(xmlSchemaAttribute, metainf, resolvedSchema);
            return;
        } else {
            QName attributeSchemaQname;
            QName attributeQName = att.getQName();
            if (attributeQName == null) throw new SchemaCompilationException("Attribute QName reference refer to an invalid attribute " + attributeQName);
            XmlSchemaSimpleType attributeSimpleType = att.getSchemaType();
            XmlSchema resolvedSchema = parentSchema;
            if (attributeSimpleType == null && (attributeSchemaQname = att.getSchemaTypeName()) != null) {
                resolvedSchema = this.getParentSchema(parentSchema, attributeSchemaQname, 1);
                if (resolvedSchema == null) {
                    throw new SchemaCompilationException("can not find the type " + attributeSchemaQname + " from the parent schema " + parentSchema.getTargetNamespace());
                }
                attributeSimpleType = (XmlSchemaSimpleType)resolvedSchema.getTypeByName(attributeSchemaQname);
            }
            if (attributeSimpleType != null) {
                QName schemaTypeQName = att.getSchemaTypeName();
                if (schemaTypeQName == null) {
                    schemaTypeQName = attributeSimpleType.getQName() != null ? attributeSimpleType.getQName() : new QName(parentSchema.getTargetNamespace(), attributeQName.getLocalPart() + this.getNextTypeSuffix(attributeQName.getLocalPart()));
                }
                if (!this.isAlreadyProcessed(schemaTypeQName)) {
                    this.processSimpleSchemaType(attributeSimpleType, null, resolvedSchema, schemaTypeQName);
                }
                metainf.registerMapping(att.getQName(), schemaTypeQName, this.processedTypemap.get(schemaTypeQName).toString(), 1);
                String use = att.getUse().getValue();
                if (!USE_NONE.equals(use) && !USE_OPTIONAL.equals(use)) return;
                metainf.addtStatus(att.getQName(), 32);
                return;
            } else {
                log.warn((Object)("No attribute type has defined to the Attribute " + attributeQName));
            }
        }
    }

    private void processParticle(QName parentElementQName, XmlSchemaParticle particle, BeanWriterMetaInfoHolder metainfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
            XmlSchemaObjectCollection items = xmlSchemaSequence.getItems();
            if (xmlSchemaSequence.getMaxOccurs() > 1L && parentElementQName != null) {
                BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                this.process(parentElementQName, items, beanWriterMetaInfoHolder, true, parentSchema);
                beanWriterMetaInfoHolder.setParticleClass(true);
                QName sequenceQName = new QName(parentElementQName.getNamespaceURI(), parentElementQName.getLocalPart() + "Sequence");
                String javaClassName = this.writeComplexParticle(sequenceQName, beanWriterMetaInfoHolder);
                this.processedTypemap.put(sequenceQName, javaClassName);
                metainfHolder.registerMapping(sequenceQName, sequenceQName, this.findClassName(sequenceQName, true), 4);
                metainfHolder.setOrdered(true);
                metainfHolder.registerQNameIndex(sequenceQName, metainfHolder.getOrderStartPoint() + 1);
                metainfHolder.setHasParticleType(true);
                metainfHolder.addtStatus(sequenceQName, 256);
                metainfHolder.addMaxOccurs(sequenceQName, xmlSchemaSequence.getMaxOccurs());
                metainfHolder.addMinOccurs(sequenceQName, xmlSchemaSequence.getMinOccurs());
            } else if (this.options.isBackwordCompatibilityMode()) {
                this.process(parentElementQName, items, metainfHolder, false, parentSchema);
            } else {
                this.process(parentElementQName, items, metainfHolder, true, parentSchema);
            }
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaObjectCollection items = ((XmlSchemaAll)particle).getItems();
            this.process(parentElementQName, items, metainfHolder, false, parentSchema);
        } else if (particle instanceof XmlSchemaChoice) {
            XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)particle;
            XmlSchemaObjectCollection items = ((XmlSchemaChoice)particle).getItems();
            if (xmlSchemaChoice.getMaxOccurs() > 1L) {
                BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                beanWriterMetaInfoHolder.setChoice(true);
                this.process(parentElementQName, items, beanWriterMetaInfoHolder, false, parentSchema);
                beanWriterMetaInfoHolder.setParticleClass(true);
                QName choiceQName = new QName(parentElementQName.getNamespaceURI(), parentElementQName.getLocalPart() + "Choice");
                String javaClassName = this.writeComplexParticle(choiceQName, beanWriterMetaInfoHolder);
                this.processedTypemap.put(choiceQName, javaClassName);
                metainfHolder.registerMapping(choiceQName, choiceQName, this.findClassName(choiceQName, true), 4);
                metainfHolder.setOrdered(true);
                metainfHolder.setHasParticleType(true);
                metainfHolder.registerQNameIndex(choiceQName, metainfHolder.getOrderStartPoint() + 1);
                metainfHolder.addtStatus(choiceQName, 256);
                metainfHolder.addMaxOccurs(choiceQName, xmlSchemaChoice.getMaxOccurs());
                metainfHolder.addMinOccurs(choiceQName, xmlSchemaChoice.getMinOccurs());
            } else {
                metainfHolder.setChoice(true);
                this.process(parentElementQName, items, metainfHolder, false, parentSchema);
            }
        } else if (particle instanceof XmlSchemaGroupRef) {
            XmlSchemaGroupRef xmlSchemaGroupRef = (XmlSchemaGroupRef)particle;
            QName groupQName = xmlSchemaGroupRef.getRefName();
            if (groupQName != null) {
                if (!this.processedGroupTypeMap.containsKey(groupQName)) {
                    XmlSchema resolvedParentSchema = this.getParentSchema(parentSchema, groupQName, 5);
                    if (resolvedParentSchema == null) {
                        throw new SchemaCompilationException("can not find the group " + groupQName + " from the parent schema " + parentSchema.getTargetNamespace());
                    }
                    XmlSchemaGroup xmlSchemaGroup = (XmlSchemaGroup)resolvedParentSchema.getGroups().getItem(groupQName);
                    this.processGroup(xmlSchemaGroup, groupQName, resolvedParentSchema);
                }
            } else {
                throw new SchemaCompilationException("Referenced name is null");
            }
            boolean isArray = xmlSchemaGroupRef.getMaxOccurs() > 1L;
            String groupClassName = this.processedGroupTypeMap.get(groupQName);
            if (isArray) {
                groupClassName = groupClassName + "[]";
            }
            metainfHolder.registerMapping(groupQName, groupQName, groupClassName);
            if (isArray) {
                metainfHolder.addtStatus(groupQName, 4);
            }
            metainfHolder.addtStatus(groupQName, 256);
            metainfHolder.addMaxOccurs(groupQName, xmlSchemaGroupRef.getMaxOccurs());
            metainfHolder.addMinOccurs(groupQName, xmlSchemaGroupRef.getMinOccurs());
            metainfHolder.setHasParticleType(true);
            metainfHolder.setOrdered(true);
            metainfHolder.registerQNameIndex(groupQName, metainfHolder.getOrderStartPoint() + 1);
        }
    }

    private void process(QName parentElementQName, XmlSchemaObjectCollection items, BeanWriterMetaInfoHolder metainfHolder, boolean order, XmlSchema parentSchema) throws SchemaCompilationException {
        int count = items.getCount();
        LinkedHashMap<Object, Boolean> processedElementArrayStatusMap = new LinkedHashMap<Object, Boolean>();
        LinkedHashMap<QName, String> processedElementTypeMap = new LinkedHashMap<QName, String>();
        ArrayList<QName> localNillableList = new ArrayList<QName>();
        HashMap<XmlSchemaObject, QName> particleQNameMap = new HashMap<XmlSchemaObject, QName>();
        ArrayList innerChoiceElementList = new ArrayList();
        HashMap<Object, Integer> elementOrderMap = new HashMap<Object, Integer>();
        int sequenceCounter = 0;
        for (int i = 0; i < count; ++i) {
            Boolean isArray;
            String javaClassName;
            String localName;
            XmlSchemaObject item = items.getItem(i);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xsElt = (XmlSchemaElement)item;
                boolean isArray2 = this.isArray((XmlSchemaParticle)xsElt);
                this.processElement(xsElt, processedElementTypeMap, localNillableList, parentSchema);
                processedElementArrayStatusMap.put(xsElt, isArray2);
                if (order) {
                    elementOrderMap.put(xsElt, sequenceCounter);
                }
            } else if (item instanceof XmlSchemaAny) {
                XmlSchemaAny any = (XmlSchemaAny)item;
                processedElementTypeMap.put(new QName(ANY_ELEMENT_FIELD_NAME), (String)any);
                if (order) {
                    elementOrderMap.put(any, new Integer(sequenceCounter));
                }
                processedElementArrayStatusMap.put(any, this.isArray((XmlSchemaParticle)any));
            } else if (item instanceof XmlSchemaSequence) {
                XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)item;
                if (xmlSchemaSequence.getItems().getCount() > 0) {
                    BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                    this.process(parentElementQName, xmlSchemaSequence.getItems(), beanWriterMetaInfoHolder, true, parentSchema);
                    beanWriterMetaInfoHolder.setParticleClass(true);
                    localName = parentElementQName.getLocalPart() + "Sequence";
                    QName sequenceQName = new QName(parentElementQName.getNamespaceURI(), localName + this.getNextTypeSuffix(localName));
                    javaClassName = this.writeComplexParticle(sequenceQName, beanWriterMetaInfoHolder);
                    this.processedTypemap.put(sequenceQName, javaClassName);
                    isArray = xmlSchemaSequence.getMaxOccurs() > 1L ? Boolean.TRUE : Boolean.FALSE;
                    processedElementArrayStatusMap.put(item, isArray);
                    particleQNameMap.put(item, sequenceQName);
                    if (order) {
                        elementOrderMap.put(item, new Integer(sequenceCounter));
                    }
                }
            } else if (item instanceof XmlSchemaChoice) {
                XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)item;
                if (xmlSchemaChoice.getItems().getCount() > 0) {
                    BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                    beanWriterMetaInfoHolder.setChoice(true);
                    this.process(parentElementQName, xmlSchemaChoice.getItems(), beanWriterMetaInfoHolder, false, parentSchema);
                    beanWriterMetaInfoHolder.setParticleClass(true);
                    localName = parentElementQName.getLocalPart() + "Choice";
                    QName choiceQName = new QName(parentElementQName.getNamespaceURI(), localName + this.getNextTypeSuffix(localName));
                    javaClassName = this.writeComplexParticle(choiceQName, beanWriterMetaInfoHolder);
                    this.processedTypemap.put(choiceQName, javaClassName);
                    isArray = xmlSchemaChoice.getMaxOccurs() > 1L ? Boolean.TRUE : Boolean.FALSE;
                    processedElementArrayStatusMap.put(item, isArray);
                    particleQNameMap.put(item, choiceQName);
                    if (order) {
                        elementOrderMap.put(item, new Integer(sequenceCounter));
                    }
                }
            } else if (item instanceof XmlSchemaGroupRef) {
                XmlSchemaGroupRef xmlSchemaGroupRef = (XmlSchemaGroupRef)item;
                QName groupQName = xmlSchemaGroupRef.getRefName();
                if (groupQName != null) {
                    if (!this.processedGroupTypeMap.containsKey(groupQName)) {
                        XmlSchema resolvedParentSchema = this.getParentSchema(parentSchema, groupQName, 5);
                        if (resolvedParentSchema == null) {
                            throw new SchemaCompilationException("Can not find the group with the qname" + groupQName + " from the parent schema " + parentSchema.getTargetNamespace());
                        }
                        XmlSchemaGroup xmlSchemaGroup = (XmlSchemaGroup)resolvedParentSchema.getGroups().getItem(groupQName);
                        if (xmlSchemaGroup != null) {
                            this.processGroup(xmlSchemaGroup, groupQName, resolvedParentSchema);
                        }
                    }
                    Boolean isArray3 = xmlSchemaGroupRef.getMaxOccurs() > 1L ? Boolean.TRUE : Boolean.FALSE;
                    processedElementArrayStatusMap.put(item, isArray3);
                    particleQNameMap.put(item, groupQName);
                    if (order) {
                        elementOrderMap.put(item, new Integer(sequenceCounter));
                    }
                } else {
                    throw new SchemaCompilationException("Referenced name is null");
                }
            }
            ++sequenceCounter;
        }
        int startingItemNumberOrder = metainfHolder.getOrderStartPoint();
        for (XmlSchemaObject child : processedElementArrayStatusMap.keySet()) {
            if (child instanceof XmlSchemaElement) {
                String clazzName;
                XmlSchemaElement elt = (XmlSchemaElement)child;
                QName referencedQName = null;
                if (elt.getQName() != null) {
                    QName schemaTypeQName;
                    referencedQName = elt.getQName();
                    QName qName = schemaTypeQName = elt.getSchemaType() != null ? elt.getSchemaType().getQName() : elt.getSchemaTypeName();
                    if (schemaTypeQName != null) {
                        clazzName = (String)processedElementTypeMap.get(elt.getQName());
                        metainfHolder.registerMapping(referencedQName, schemaTypeQName, clazzName, (Boolean)processedElementArrayStatusMap.get(elt) != false ? 4 : 2);
                        if (innerChoiceElementList.contains(referencedQName)) {
                            metainfHolder.addtStatus(referencedQName, 128);
                        }
                        if (elt.getDefaultValue() != null) {
                            metainfHolder.registerDefaultValue(referencedQName, elt.getDefaultValue());
                        }
                    }
                }
                if (elt.getRefName() != null) {
                    XmlSchema resolvedParentSchema;
                    boolean arrayStatus;
                    referencedQName = elt.getRefName();
                    clazzName = this.findRefClassName(referencedQName, arrayStatus = ((Boolean)processedElementArrayStatusMap.get(elt)).booleanValue());
                    if (clazzName == null) {
                        clazzName = this.findClassName(referencedQName, arrayStatus);
                    }
                    if ((resolvedParentSchema = this.getParentSchema(parentSchema, referencedQName, 2)) == null) {
                        throw new SchemaCompilationException("Can not find the element " + referencedQName + " from the parent schema " + parentSchema.getTargetNamespace());
                    }
                    XmlSchemaElement refElement = resolvedParentSchema.getElementByName(referencedQName);
                    if (refElement != null) {
                        metainfHolder.registerMapping(referencedQName, refElement.getSchemaTypeName(), clazzName, arrayStatus ? 4 : 2);
                    } else if (referencedQName.equals(SchemaConstants.XSD_SCHEMA)) {
                        metainfHolder.registerMapping(referencedQName, null, this.writer.getDefaultClassName(), 8);
                    } else {
                        throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", referencedQName.toString()));
                    }
                }
                if (referencedQName == null) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.emptyName"));
                }
                metainfHolder.addMaxOccurs(referencedQName, elt.getMaxOccurs());
                if (this.options.isOffStrictValidation()) {
                    metainfHolder.addMinOccurs(referencedQName, 0L);
                } else {
                    metainfHolder.addMinOccurs(referencedQName, elt.getMinOccurs());
                }
                if (order) {
                    metainfHolder.registerQNameIndex(referencedQName, startingItemNumberOrder + (Integer)elementOrderMap.get(elt));
                }
                if (localNillableList.contains(elt.getQName())) {
                    metainfHolder.registerNillableQName(elt.getQName());
                }
                if (!this.isBinary(elt)) continue;
                metainfHolder.addtStatus(elt.getQName(), 16);
                continue;
            }
            if (child instanceof XmlSchemaAny) {
                XmlSchemaAny any = (XmlSchemaAny)child;
                QName anyElementFieldName = new QName(ANY_ELEMENT_FIELD_NAME);
                boolean isArray = (Boolean)processedElementArrayStatusMap.get(any);
                metainfHolder.registerMapping(anyElementFieldName, null, isArray ? this.writer.getDefaultClassArrayName() : this.writer.getDefaultClassName(), 8);
                if (isArray) {
                    metainfHolder.addtStatus(anyElementFieldName, 4);
                }
                metainfHolder.addMaxOccurs(anyElementFieldName, any.getMaxOccurs());
                metainfHolder.addMinOccurs(anyElementFieldName, any.getMinOccurs());
                if (!order) continue;
                metainfHolder.registerQNameIndex(anyElementFieldName, startingItemNumberOrder + (Integer)elementOrderMap.get(any));
                continue;
            }
            if (child instanceof XmlSchemaSequence) {
                XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)child;
                QName sequenceQName = (QName)particleQNameMap.get(child);
                boolean isArray = xmlSchemaSequence.getMaxOccurs() > 1L;
                metainfHolder.registerMapping(sequenceQName, sequenceQName, this.findClassName(sequenceQName, isArray));
                if (isArray) {
                    metainfHolder.addtStatus(sequenceQName, 4);
                }
                metainfHolder.addtStatus(sequenceQName, 256);
                metainfHolder.addMaxOccurs(sequenceQName, xmlSchemaSequence.getMaxOccurs());
                metainfHolder.addMinOccurs(sequenceQName, xmlSchemaSequence.getMinOccurs());
                metainfHolder.setHasParticleType(true);
                if (!order) continue;
                metainfHolder.registerQNameIndex(sequenceQName, startingItemNumberOrder + (Integer)elementOrderMap.get(child));
                continue;
            }
            if (child instanceof XmlSchemaChoice) {
                XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)child;
                QName choiceQName = (QName)particleQNameMap.get(child);
                boolean isArray = xmlSchemaChoice.getMaxOccurs() > 1L;
                metainfHolder.registerMapping(choiceQName, choiceQName, this.findClassName(choiceQName, isArray));
                if (isArray) {
                    metainfHolder.addtStatus(choiceQName, 4);
                }
                metainfHolder.addtStatus(choiceQName, 256);
                metainfHolder.addMaxOccurs(choiceQName, xmlSchemaChoice.getMaxOccurs());
                metainfHolder.addMinOccurs(choiceQName, xmlSchemaChoice.getMinOccurs());
                metainfHolder.setHasParticleType(true);
                if (!order) continue;
                metainfHolder.registerQNameIndex(choiceQName, startingItemNumberOrder + (Integer)elementOrderMap.get(child));
                continue;
            }
            if (!(child instanceof XmlSchemaGroupRef)) continue;
            XmlSchemaGroupRef xmlSchemaGroupRef = (XmlSchemaGroupRef)child;
            QName groupQName = (QName)particleQNameMap.get(child);
            boolean isArray = xmlSchemaGroupRef.getMaxOccurs() > 1L;
            String groupClassName = this.processedGroupTypeMap.get(groupQName);
            if (isArray) {
                groupClassName = groupClassName + "[]";
            }
            metainfHolder.registerMapping(groupQName, groupQName, groupClassName);
            if (isArray) {
                metainfHolder.addtStatus(groupQName, 4);
            }
            metainfHolder.addtStatus(groupQName, 256);
            metainfHolder.addMaxOccurs(groupQName, xmlSchemaGroupRef.getMaxOccurs());
            metainfHolder.addMinOccurs(groupQName, xmlSchemaGroupRef.getMinOccurs());
            metainfHolder.setHasParticleType(true);
            if (!order) continue;
            metainfHolder.registerQNameIndex(groupQName, startingItemNumberOrder + (Integer)elementOrderMap.get(child));
        }
        metainfHolder.setOrdered(order);
    }

    private void processGroup(XmlSchemaGroup xmlSchemaGroup, QName schemaGroupQName, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaGroupBase xmlSchemaGroupBase = xmlSchemaGroup.getParticle();
        if (xmlSchemaGroupBase != null) {
            XmlSchemaChoice xmlSchemaChoice;
            if (xmlSchemaGroupBase instanceof XmlSchemaSequence) {
                XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)xmlSchemaGroupBase;
                if (xmlSchemaSequence.getItems().getCount() > 0) {
                    BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                    this.process(schemaGroupQName, xmlSchemaSequence.getItems(), beanWriterMetaInfoHolder, true, parentSchema);
                    beanWriterMetaInfoHolder.setParticleClass(true);
                    String javaClassName = this.writeComplexParticle(schemaGroupQName, beanWriterMetaInfoHolder);
                    this.processedGroupTypeMap.put(schemaGroupQName, javaClassName);
                }
            } else if (xmlSchemaGroupBase instanceof XmlSchemaChoice && (xmlSchemaChoice = (XmlSchemaChoice)xmlSchemaGroupBase).getItems().getCount() > 0) {
                BeanWriterMetaInfoHolder beanWriterMetaInfoHolder = new BeanWriterMetaInfoHolder();
                beanWriterMetaInfoHolder.setChoice(true);
                this.process(schemaGroupQName, xmlSchemaChoice.getItems(), beanWriterMetaInfoHolder, false, parentSchema);
                beanWriterMetaInfoHolder.setParticleClass(true);
                String javaClassName = this.writeComplexParticle(schemaGroupQName, beanWriterMetaInfoHolder);
                this.processedGroupTypeMap.put(schemaGroupQName, javaClassName);
            }
        }
    }

    private boolean isBinary(XmlSchemaElement elt) {
        return elt.getSchemaType() != null && SchemaConstants.XSD_BASE64.equals(elt.getSchemaType().getQName());
    }

    private boolean isBinary(QName qName) {
        return qName != null && SchemaConstants.XSD_BASE64.equals(qName);
    }

    private void processSimpleSchemaType(XmlSchemaSimpleType simpleType, XmlSchemaElement xsElt, XmlSchema parentSchema, QName qname) throws SchemaCompilationException {
        String fullyQualifiedClassName = null;
        if (simpleType.getQName() != null) {
            if (this.processedTypemap.containsKey(simpleType.getQName()) || this.baseSchemaTypeMap.containsKey(simpleType.getQName())) {
                return;
            }
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(simpleType.getQName());
            this.processedTypemap.put(simpleType.getQName(), fullyQualifiedClassName);
        } else {
            QName fakeQname;
            if (xsElt != null) {
                fakeQname = new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart() + this.getNextTypeSuffix(xsElt.getQName().getLocalPart()));
                xsElt.setSchemaTypeName(fakeQname);
                this.changedElementSet.add(xsElt);
            } else {
                fakeQname = qname;
            }
            if (this.processedTypemap.containsKey(fakeQname) || this.baseSchemaTypeMap.containsKey(fakeQname)) {
                return;
            }
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(fakeQname);
            simpleType.addMetaInfo((Object)"Q_NAME", (Object)fakeQname);
            this.processedTypemap.put(fakeQname, fullyQualifiedClassName);
        }
        simpleType.addMetaInfo((Object)"CLASS_NAME", (Object)fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processSimpleType(simpleType, parentSchema);
        metaInfHolder.setSimple(true);
        if (simpleType.getQName() == null) {
            QName fakeQname;
            this.processedAnonymousComplexTypesMap.put(xsElt, metaInfHolder);
            if (xsElt != null) {
                fakeQname = new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart());
            } else {
                fakeQname = qname;
                simpleType.setName(fakeQname.getLocalPart());
                this.changedSimpleTypeSet.add(simpleType);
                simpleType.setSourceURI(fakeQname.getNamespaceURI());
            }
            this.simpleTypesMap.put(fakeQname, fullyQualifiedClassName);
        }
        metaInfHolder.setOwnQname(simpleType.getQName());
        if (fullyQualifiedClassName != null) {
            metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        }
        this.writeSimpleType(simpleType, metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processSimpleType(XmlSchemaSimpleType simpleType, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        XmlSchemaSimpleTypeContent content = simpleType.getContent();
        QName parentSimpleTypeQname = simpleType.getQName();
        if (parentSimpleTypeQname == null) {
            parentSimpleTypeQname = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
        }
        if (content != null) {
            if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                QName baseTypeName = restriction.getBaseTypeName();
                if (this.baseSchemaTypeMap.containsKey(baseTypeName)) {
                    this.processSimpleRestrictionBaseType(parentSimpleTypeQname, restriction.getBaseTypeName(), metaInfHolder, parentSchema);
                    if (!SchemaConstants.XSD_BOOLEAN.equals(baseTypeName)) {
                        this.processFacets(restriction, metaInfHolder, parentSchema);
                    }
                } else {
                    XmlSchema resolvedSchema = this.getParentSchema(parentSchema, baseTypeName, 1);
                    if (resolvedSchema == null) {
                        throw new SchemaCompilationException("can not find the type " + baseTypeName + " from the parent schema " + parentSchema.getTargetNamespace());
                    }
                    XmlSchemaType restrictionBaseType = resolvedSchema.getTypeByName(baseTypeName);
                    if (restrictionBaseType instanceof XmlSchemaSimpleType) {
                        if (restrictionBaseType != null && !this.isAlreadyProcessed(baseTypeName)) {
                            this.processSimpleSchemaType((XmlSchemaSimpleType)restrictionBaseType, null, resolvedSchema, null);
                        }
                        this.processSimpleRestrictionBaseType(parentSimpleTypeQname, restriction.getBaseTypeName(), metaInfHolder, resolvedSchema);
                    }
                }
            } else if (content instanceof XmlSchemaSimpleTypeUnion) {
                XmlSchemaSimpleTypeUnion simpleTypeUnion = (XmlSchemaSimpleTypeUnion)content;
                QName[] qnames = simpleTypeUnion.getMemberTypesQNames();
                if (qnames != null) {
                    for (int i = 0; i < qnames.length; ++i) {
                        QName qname = qnames[i];
                        if (this.baseSchemaTypeMap.containsKey(qname)) {
                            metaInfHolder.addMemberType(qname, this.baseSchemaTypeMap.get(qname));
                            continue;
                        }
                        XmlSchema resolvedSchema = this.getParentSchema(parentSchema, qname, 1);
                        if (resolvedSchema == null) {
                            throw new SchemaCompilationException("can not find the type " + qname + " from the parent schema " + parentSchema.getTargetNamespace());
                        }
                        XmlSchemaType type = resolvedSchema.getTypeByName(qname);
                        if (type instanceof XmlSchemaSimpleType) {
                            XmlSchemaSimpleType memberSimpleType = (XmlSchemaSimpleType)type;
                            if (!this.isAlreadyProcessed(qname)) {
                                this.processSimpleSchemaType(memberSimpleType, null, resolvedSchema, null);
                            }
                            metaInfHolder.addMemberType(qname, this.processedTypemap.get(qname));
                            continue;
                        }
                        throw new SchemaCompilationException("Unions can not have complex types as a member type");
                    }
                } else {
                    XmlSchemaObjectCollection xmlSchemaObjectCollection = simpleTypeUnion.getBaseTypes();
                    int i = 1;
                    Iterator iter = xmlSchemaObjectCollection.getIterator();
                    while (iter.hasNext()) {
                        XmlSchemaObject xmlSchemaObject = (XmlSchemaObject)iter.next();
                        ++i;
                        if (!(xmlSchemaObject instanceof XmlSchemaSimpleType)) continue;
                        XmlSchemaSimpleType unionSimpleType = (XmlSchemaSimpleType)xmlSchemaObject;
                        QName childQname = unionSimpleType.getQName();
                        if (childQname == null) {
                            childQname = new QName(parentSimpleTypeQname.getNamespaceURI(), parentSimpleTypeQname.getLocalPart() + this.getNextTypeSuffix(parentSimpleTypeQname.getLocalPart()));
                        }
                        this.processSimpleSchemaType(unionSimpleType, null, parentSchema, childQname);
                        metaInfHolder.addMemberType(childQname, this.processedTypemap.get(childQname));
                    }
                }
                metaInfHolder.setUnion(true);
            } else if (content instanceof XmlSchemaSimpleTypeList) {
                XmlSchemaSimpleTypeList simpleTypeList = (XmlSchemaSimpleTypeList)content;
                QName itemTypeQName = simpleTypeList.getItemTypeName();
                if (itemTypeQName != null) {
                    if (!this.isAlreadyProcessed(itemTypeQName)) {
                        XmlSchema resolvedSchema = this.getParentSchema(parentSchema, itemTypeQName, 1);
                        if (resolvedSchema == null) {
                            throw new SchemaCompilationException("can not find the type " + itemTypeQName + " from the parent type " + parentSchema.getTargetNamespace());
                        }
                        XmlSchemaType simpleSchemaType = resolvedSchema.getTypeByName(itemTypeQName);
                        if (simpleSchemaType instanceof XmlSchemaSimpleType) {
                            this.processSimpleSchemaType((XmlSchemaSimpleType)simpleSchemaType, null, resolvedSchema, null);
                        }
                    }
                } else {
                    XmlSchemaSimpleType listSimpleType = simpleTypeList.getItemType();
                    itemTypeQName = listSimpleType.getQName();
                    if (itemTypeQName == null) {
                        itemTypeQName = new QName(parentSimpleTypeQname.getNamespaceURI(), parentSimpleTypeQname.getLocalPart() + "_type0");
                    }
                    this.processSimpleSchemaType(listSimpleType, null, parentSchema, itemTypeQName);
                }
                String className = this.findClassName(itemTypeQName, false);
                metaInfHolder.setList(true);
                metaInfHolder.setItemTypeQName(itemTypeQName);
                metaInfHolder.setItemTypeClassName(className);
            }
        }
        return metaInfHolder;
    }

    private boolean isArray(XmlSchemaParticle particle) throws SchemaCompilationException {
        long minOccurs = particle.getMinOccurs();
        long maxOccurs = particle.getMaxOccurs();
        if (maxOccurs < minOccurs) {
            throw new SchemaCompilationException();
        }
        return maxOccurs > 1L;
    }

    private String getNextTypeSuffix(String localName) {
        Integer typeCounter = this.mapTypeCount.get(localName);
        int count = 0;
        if (typeCounter != null) {
            count = typeCounter == Integer.MAX_VALUE ? 0 : typeCounter;
        }
        this.mapTypeCount.put(localName, count + 1);
        return "_type" + count;
    }

    private XmlSchema getParentSchema(XmlSchema parentSchema, QName componentQName, int componetType) throws SchemaCompilationException {
        if (componentQName == null || componentQName.getNamespaceURI() == null || "http://www.w3.org/2001/XMLSchema".equals(componentQName.getNamespaceURI())) {
            return parentSchema;
        }
        ArrayList<XmlSchema> visitedSchemas = new ArrayList<XmlSchema>();
        visitedSchemas.add(parentSchema);
        XmlSchema newParentSchema = this.getParentSchemaFromIncludes(parentSchema, componentQName, componetType, visitedSchemas);
        if (newParentSchema == null) {
            XmlSchema tempSchema;
            String targetNamespace = componentQName.getNamespaceURI();
            if (this.loadedSchemaMap.containsKey(targetNamespace)) {
                XmlSchema tempSchema2 = this.loadedSchemaMap.get(targetNamespace);
                if (this.isComponetExists(tempSchema2, componentQName, componetType)) {
                    newParentSchema = tempSchema2;
                }
            } else if (this.availableSchemaMap.containsKey(targetNamespace) && this.isComponetExists(tempSchema = this.availableSchemaMap.get(targetNamespace), componentQName, componetType)) {
                this.compile(tempSchema);
                newParentSchema = tempSchema;
            }
        }
        return newParentSchema;
    }

    private XmlSchema getParentSchemaFromIncludes(XmlSchema parentSchema, QName componentQName, int componetType, List<XmlSchema> visitedSchemas) throws SchemaCompilationException {
        XmlSchema newParentSchema = null;
        if (this.isComponetExists(parentSchema, componentQName, componetType)) {
            newParentSchema = parentSchema;
        } else {
            XmlSchemaObjectCollection includes = parentSchema.getIncludes();
            if (includes != null) {
                Object externalComponet = null;
                XmlSchema externalSchema = null;
                Iterator iter = includes.getIterator();
                while (iter.hasNext()) {
                    XmlSchemaImport xmlSchemaImport;
                    String importNamespce;
                    externalComponet = iter.next();
                    if (!(externalComponet instanceof XmlSchemaExternal)) continue;
                    externalSchema = ((XmlSchemaExternal)externalComponet).getSchema();
                    if (externalSchema == null && externalComponet instanceof XmlSchemaImport && (importNamespce = (xmlSchemaImport = (XmlSchemaImport)externalComponet).getNamespace()) != null && !importNamespce.equals("http://www.w3.org/2001/XMLSchema")) {
                        if (this.loadedSchemaMap.containsKey(importNamespce)) {
                            externalSchema = this.loadedSchemaMap.get(importNamespce);
                        } else if (this.availableSchemaMap.containsKey(importNamespce)) {
                            XmlSchema tempSchema = this.availableSchemaMap.get(importNamespce);
                            this.compile(tempSchema);
                            externalSchema = tempSchema;
                        }
                    }
                    if (externalSchema != null && !visitedSchemas.contains(externalSchema)) {
                        visitedSchemas.add(externalSchema);
                        newParentSchema = this.getParentSchemaFromIncludes(externalSchema, componentQName, componetType, visitedSchemas);
                    }
                    if (newParentSchema == null) continue;
                    break;
                }
            }
        }
        return newParentSchema;
    }

    private boolean isComponetExists(XmlSchema schema, QName componentQName, int componetType) {
        boolean isExists = false;
        switch (componetType) {
            case 1: {
                isExists = schema.getTypeByName(componentQName.getLocalPart()) != null;
                break;
            }
            case 2: {
                isExists = schema.getElementByName(componentQName.getLocalPart()) != null;
                break;
            }
            case 3: {
                isExists = schema.getAttributes().getItem(componentQName) != null;
                break;
            }
            case 4: {
                isExists = schema.getAttributeGroups().getItem(componentQName) != null;
                break;
            }
            case 5: {
                isExists = schema.getGroups().getItem(componentQName) != null;
            }
        }
        return isExists;
    }
}

