/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.parser;

import antlr.collections.AST;
import org.apache.axis2.corba.exceptions.InvalidIDLException;
import org.apache.axis2.corba.idl.parser.IDLVisitor;
import org.apache.axis2.corba.idl.types.ConstType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.Typedef;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class ExpressionUtil {
    public static Object eval(AST expressionNode, DataType returnType, IDLVisitor visitor) throws InvalidIDLException {
        Object value;
        int expressionType = expressionNode.getType();
        TypeCode typeCode = returnType.getTypeCode();
        switch (expressionType) {
            case 34: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = node2 == null ? ExpressionUtil.eval(node1, returnType, visitor) : ExpressionUtil.add(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 35: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = node2 == null ? ExpressionUtil.minus(ExpressionUtil.eval(node1, returnType, visitor), typeCode) : ExpressionUtil.subtract(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 36: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.multiply(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 37: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.div(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 38: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.mod(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 29: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.or(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 31: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.and(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 33: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.rshift(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 32: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.lshift(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 30: {
                AST node1 = expressionNode.getFirstChild();
                AST node2 = node1.getNextSibling();
                value = ExpressionUtil.xor(ExpressionUtil.eval(node1, returnType, visitor), ExpressionUtil.eval(node2, returnType, visitor), typeCode);
                break;
            }
            case 39: {
                AST node1 = expressionNode.getFirstChild();
                Object boolObj = ExpressionUtil.eval(node1, returnType, visitor);
                if (!(boolObj instanceof Boolean)) {
                    throw new InvalidIDLException("A boolean value is expected after (~) operator");
                }
                value = (Boolean)boolObj == false;
                break;
            }
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                value = ExpressionUtil.getValueObject(expressionNode.getText(), returnType);
                break;
            }
            case 40: {
                value = true;
                break;
            }
            case 41: {
                value = true;
                break;
            }
            case 18: {
                value = ExpressionUtil.getConstant(expressionNode.getText(), visitor);
                break;
            }
            case 24: {
                value = ExpressionUtil.eval(expressionNode.getFirstChild(), returnType, visitor);
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token " + expressionNode);
            }
        }
        return value;
    }

    private static Object add(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 + (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 + (Long)o2);
                break;
            }
            case 6: {
                valueObj = new Float(((Float)o1).floatValue() + ((Float)o2).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 + (Short)o2));
                break;
            }
            case 7: {
                valueObj = new Double((Double)o1 + (Double)o2);
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 + (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object minus(Object o, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer(-((Integer)o).intValue());
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long(-((Long)o).longValue());
                break;
            }
            case 6: {
                valueObj = new Float(-((Float)o).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short(-((Short)o).shortValue());
                break;
            }
            case 7: {
                valueObj = new Double(-((Double)o).doubleValue());
                break;
            }
            case 10: {
                valueObj = new Byte(-((Byte)o).byteValue());
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object subtract(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 - (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 - (Long)o2);
                break;
            }
            case 6: {
                valueObj = new Float(((Float)o1).floatValue() - ((Float)o2).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 - (Short)o2));
                break;
            }
            case 7: {
                valueObj = new Double((Double)o1 - (Double)o2);
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 - (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object multiply(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 * (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 * (Long)o2);
                break;
            }
            case 6: {
                valueObj = new Float(((Float)o1).floatValue() * ((Float)o2).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 * (Short)o2));
                break;
            }
            case 7: {
                valueObj = new Double((Double)o1 * (Double)o2);
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 * (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object div(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 / (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 / (Long)o2);
                break;
            }
            case 6: {
                valueObj = new Float(((Float)o1).floatValue() / ((Float)o2).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 / (Short)o2));
                break;
            }
            case 7: {
                valueObj = new Double((Double)o1 / (Double)o2);
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 / (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object rshift(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 >> (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 >> (int)((Long)o2).longValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 >> (Short)o2));
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 >> (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object lshift(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 << (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 << (int)((Long)o2).longValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 << (Short)o2));
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 << (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object xor(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 ^ (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 ^ (Long)o2);
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 ^ (Short)o2));
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 ^ (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object mod(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 % (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 % (Long)o2);
                break;
            }
            case 6: {
                valueObj = new Float(((Float)o1).floatValue() % ((Float)o2).floatValue());
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 % (Short)o2));
                break;
            }
            case 7: {
                valueObj = new Double((Double)o1 % (Double)o2);
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 % (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object or(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 | (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 | (Long)o2);
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 | (Short)o2));
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 | (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object and(Object o1, Object o2, TypeCode returnType) throws InvalidIDLException {
        Number valueObj;
        TCKind kind = returnType.kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer((Integer)o1 & (Integer)o2);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long((Long)o1 & (Long)o2);
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short((short)((Short)o1 & (Short)o2));
                break;
            }
            case 10: {
                valueObj = new Byte((byte)((Byte)o1 & (Byte)o2));
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token");
            }
        }
        return valueObj;
    }

    private static Object getValueObject(String value, DataType type) throws InvalidIDLException {
        Object valueObj;
        TCKind kind = type.getTypeCode().kind();
        switch (kind.value()) {
            case 3: 
            case 5: {
                valueObj = new Integer(value);
                break;
            }
            case 23: 
            case 24: {
                valueObj = new Long(value);
                break;
            }
            case 6: {
                valueObj = new Float(value);
                break;
            }
            case 2: 
            case 4: {
                valueObj = new Short(value);
                break;
            }
            case 9: 
            case 26: {
                valueObj = new Character(value.charAt(0));
                break;
            }
            case 7: {
                valueObj = new Double(value);
                break;
            }
            case 10: {
                valueObj = new Byte(value);
                break;
            }
            case 18: 
            case 27: {
                valueObj = value;
                break;
            }
            case 21: {
                Typedef typedef = (Typedef)type;
                valueObj = ExpressionUtil.getValueObject(value, typedef.getDataType());
                break;
            }
            default: {
                throw new InvalidIDLException("Unsupported IDL token ");
            }
        }
        return valueObj;
    }

    private static Object getConstant(String expressionName, IDLVisitor visitor) throws InvalidIDLException {
        DataType dataType = visitor.getDataType(expressionName);
        if (dataType == null || !(dataType instanceof ConstType)) {
            throw new InvalidIDLException("Constant " + expressionName + " not found.");
        }
        ConstType constType = (ConstType)dataType;
        Object value = constType.getValue();
        return value;
    }
}

