/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.PrivilegedAction;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;

class AnnotationDescImpl
implements AnnotationDesc {
    private boolean _hasXmlRootElement = false;
    private String _XmlRootElementName = null;
    private String _XmlRootElementNamespace = null;
    private Class[] _XmlSeeAlsoClasses = null;
    private boolean _hasXmlType = false;
    private String _XmlTypeName = null;
    private String _XmlTypeNamespace = null;

    private AnnotationDescImpl() {
    }

    public boolean hasXmlRootElement() {
        return this._hasXmlRootElement;
    }

    public String getXmlRootElementName() {
        return this._XmlRootElementName;
    }

    public String getXmlRootElementNamespace() {
        return this._XmlRootElementNamespace;
    }

    public boolean hasXmlType() {
        return this._hasXmlType;
    }

    public String getXmlTypeName() {
        return this._XmlTypeName;
    }

    public String getXmlTypeNamespace() {
        return this._XmlTypeNamespace;
    }

    static AnnotationDesc create(Class cls) {
        QName qName;
        AnnotationDescImpl aDesc = new AnnotationDescImpl();
        XmlSeeAlso xmlSeeAlso = (XmlSeeAlso)AnnotationDescImpl.getAnnotation(cls, XmlSeeAlso.class);
        if (xmlSeeAlso != null) {
            aDesc._XmlSeeAlsoClasses = xmlSeeAlso.value();
        }
        if ((qName = XMLRootElementUtil.getXmlRootElementQName(cls)) != null) {
            aDesc._hasXmlRootElement = true;
            aDesc._XmlRootElementName = qName.getLocalPart();
            aDesc._XmlRootElementNamespace = qName.getNamespaceURI();
        }
        if ((qName = XMLRootElementUtil.getXmlTypeQName(cls)) != null) {
            aDesc._hasXmlType = true;
            aDesc._XmlTypeName = qName.getLocalPart();
            aDesc._XmlTypeNamespace = qName.getNamespaceURI();
        }
        return aDesc;
    }

    public String toString() {
        String newline = "\n";
        StringBuffer string = new StringBuffer();
        string.append("\n");
        string.append("      @XMLRootElement exists = " + this.hasXmlRootElement());
        if (this.hasXmlRootElement()) {
            string.append("\n");
            string.append("      @XMLRootElement namespace = " + this.getXmlRootElementNamespace());
            string.append("\n");
            string.append("      @XMLRootElement name      = " + this.getXmlRootElementName());
        }
        string.append("\n");
        string.append("      @XmlType exists = " + this.hasXmlType());
        if (this.hasXmlRootElement()) {
            string.append("\n");
            string.append("      @XmlType namespace = " + this.getXmlTypeNamespace());
            string.append("\n");
            string.append("      @XmlType name      = " + this.getXmlTypeName());
        }
        if (this._XmlSeeAlsoClasses != null) {
            for (int i = 0; i < this._XmlSeeAlsoClasses.length; ++i) {
                string.append("\n");
                string.append("      @XMLSeeAlso class = " + this._XmlSeeAlsoClasses[i].getName());
            }
        }
        return string.toString();
    }

    public Class[] getXmlSeeAlsoClasses() {
        return this._XmlSeeAlsoClasses;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }
}

