/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jsr181.JSR181Helper;
import org.apache.axis2.jsr181.WebServiceAnnotation;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class POJODeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(POJODeployer.class);
    private ConfigurationContext configCtx;
    private String directory;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        block18: {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            String serviceHierarchy = Utils.getServiceHierarchy(deploymentFileData.getAbsolutePath(), this.directory);
            if (serviceHierarchy == null) {
                serviceHierarchy = "";
            }
            try {
                try {
                    String extension = DeploymentFileData.getFileExtension(deploymentFileData.getName());
                    if ("class".equals(extension)) {
                        File file = deploymentFileData.getFile();
                        File parentFile = file.getParentFile();
                        ClassLoader classLoader = Utils.getClassLoader(this.configCtx.getAxisConfiguration().getSystemClassLoader(), parentFile, this.configCtx.getAxisConfiguration().isChildFirstClassLoading());
                        Thread.currentThread().setContextClassLoader(classLoader);
                        String className = Utils.getClassNameFromResourceName(file.getName());
                        Class clazz = Loader.loadClass(className);
                        log.info((Object)Messages.getMessage("deployingpojo", serviceHierarchy + className, deploymentFileData.getFile().getAbsolutePath()));
                        WebServiceAnnotation annotation = JSR181Helper.INSTANCE.getWebServiceAnnotation(clazz);
                        AxisService axisService = annotation != null ? this.createAxisService(classLoader, className, deploymentFileData.getFile().toURL()) : this.createAxisServiceUsingAnnogen(className, classLoader, deploymentFileData.getFile().toURL());
                        axisService.setName(serviceHierarchy + axisService.getName());
                        this.configCtx.getAxisConfiguration().addService(axisService);
                    } else if ("jar".equals(extension)) {
                        List<String> classList = Utils.getListOfClasses(deploymentFileData);
                        ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
                        for (String className : classList) {
                            ArrayList<URL> urls = new ArrayList<URL>();
                            urls.add(deploymentFileData.getFile().toURL());
                            urls.add(this.configCtx.getAxisConfiguration().getRepository());
                            String webLocation = DeploymentEngine.getWebLocationString();
                            if (webLocation != null) {
                                urls.add(new File(webLocation).toURL());
                            }
                            ClassLoader classLoader = Utils.createClassLoader(urls, this.configCtx.getAxisConfiguration().getSystemClassLoader(), true, (File)this.configCtx.getAxisConfiguration().getParameterValue("artifactsDIR"), this.configCtx.getAxisConfiguration().isChildFirstClassLoading());
                            Thread.currentThread().setContextClassLoader(classLoader);
                            Class clazz = Loader.loadClass(className);
                            WebServiceAnnotation annotation = JSR181Helper.INSTANCE.getWebServiceAnnotation(clazz);
                            if (annotation == null) continue;
                            AxisService axisService = this.createAxisService(classLoader, className, deploymentFileData.getFile().toURL());
                            axisServiceList.add(axisService);
                        }
                        if (axisServiceList.size() > 0) {
                            AxisServiceGroup serviceGroup = new AxisServiceGroup();
                            serviceGroup.setServiceGroupName(serviceHierarchy + deploymentFileData.getName());
                            Iterator i$ = axisServiceList.iterator();
                            while (i$.hasNext()) {
                                AxisService anAxisServiceList;
                                AxisService axisService = anAxisServiceList = (AxisService)i$.next();
                                axisService.setName(serviceHierarchy + axisService.getName());
                                serviceGroup.addService(axisService);
                            }
                            this.configCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
                        } else {
                            String msg = "Error:\n No annotated classes found in the jar: " + deploymentFileData.getFile().getName() + ". Service deployment failed.";
                            log.error((Object)msg);
                            this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                        }
                    }
                    super.deploy(deploymentFileData);
                }
                catch (Exception e) {
                    log.debug((Object)Messages.getMessage("stroringfaultyservice", e.getMessage()), (Throwable)e);
                    this.storeFaultyService(deploymentFileData, e);
                    Object var16_25 = null;
                    if (threadClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(threadClassLoader);
                    }
                    break block18;
                }
                catch (Throwable t) {
                    log.debug((Object)Messages.getMessage("stroringfaultyservice", t.getMessage()), t);
                    this.storeFaultyService(deploymentFileData, t);
                    Object var16_26 = null;
                    if (threadClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(threadClassLoader);
                    }
                }
                Object var16_24 = null;
                if (threadClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
            catch (Throwable throwable) {
                Object var16_27 = null;
                if (threadClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
                throw throwable;
            }
        }
    }

    private void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    private AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        try {
            Class<?> claxx = Class.forName("org.apache.axis2.jaxws.description.DescriptionFactory");
            Method mthod = claxx.getMethod("createAxisService", Class.class);
            Class pojoClass = Loader.loadClass(classLoader, className);
            axisService = (AxisService)mthod.invoke(claxx, pojoClass);
            if (axisService != null) {
                Iterator<AxisOperation> operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = operations.next();
                    if (axisOperation.getMessageReceiver() != null) continue;
                    try {
                        Class jaxwsMR = Loader.loadClass("org.apache.axis2.jaxws.server.JAXWSMessageReceiver");
                        MessageReceiver jaxwsMRInstance = (MessageReceiver)jaxwsMR.newInstance();
                        axisOperation.setMessageReceiver(jaxwsMRInstance);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Error occurde while loading JAXWSMessageReceiver for " + className));
                    }
                }
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            Utils.fillAxisService(axisService, this.configCtx.getAxisConfiguration(), new ArrayList<String>(), new ArrayList<String>());
        }
        catch (Exception e) {
            log.info((Object)Messages.getMessage("jaxwsjarsmissing", e.getMessage()), (Throwable)e);
            axisService = this.createAxisServiceUsingAnnogen(className, classLoader, serviceLocation);
        }
        return axisService;
    }

    private AxisService createAxisServiceUsingAnnogen(String className, ClassLoader classLoader, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
        MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
        Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
        AxisService axisService = AxisService.createService(className, this.configCtx.getAxisConfiguration(), messageReciverMap, null, null, classLoader);
        axisService.setFileName(serviceLocation);
        return axisService;
    }

    public void setMessageReceivers(AxisService service) {
        Iterator<AxisOperation> iterator = service.getOperations();
        while (iterator.hasNext()) {
            AxisOperation operation = iterator.next();
            String MEP = operation.getMessageExchangePattern();
            if (MEP == null) continue;
            try {
                if ("http://www.w3.org/ns/wsdl/in-only".equals(MEP)) {
                    Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
                    MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
                    operation.setMessageReceiver(messageReceiver);
                    continue;
                }
                Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
                operation.setMessageReceiver(inOutmessageReceiver);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        String serviceHierarchy = Utils.getServiceHierarchy(fileName, this.directory);
        if (serviceHierarchy == null) {
            serviceHierarchy = "";
        }
        if ((fileName = Utils.getShortFileName(fileName)).endsWith(".class")) {
            String className = Utils.getClassNameFromResourceName(fileName);
            className = serviceHierarchy + className;
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(className);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", className));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        } else if (fileName.endsWith(".jar")) {
            fileName = serviceHierarchy + fileName;
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(fileName);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", fileName));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        }
        super.undeploy(fileName);
    }
}

