/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramAcceptorDelegate
extends BaseIoAcceptor
implements IoAcceptor,
DatagramService {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final Object lock = new Object();
    private final IoAcceptor wrapper;
    private final Executor executor;
    private final int id = nextId.getAndIncrement();
    private volatile Selector selector;
    private DatagramAcceptorConfig defaultConfig = new DatagramAcceptorConfig();
    private final Map<SocketAddress, DatagramChannel> channels = new ConcurrentHashMap<SocketAddress, DatagramChannel>();
    private final Queue<RegistrationRequest> registerQueue = new ConcurrentLinkedQueue<RegistrationRequest>();
    private final Queue<CancellationRequest> cancelQueue = new ConcurrentLinkedQueue<CancellationRequest>();
    private final Queue<DatagramSessionImpl> flushingSessions = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private Worker worker;

    public DatagramAcceptorDelegate(IoAcceptor wrapper, Executor executor) {
        this.wrapper = wrapper;
        this.executor = executor;
        this.defaultConfig.getSessionConfig().setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, config);
        Object object = this.lock;
        synchronized (object) {
            this.startupWorker();
            this.registerQueue.add(request);
            this.selector.wakeup();
        }
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
        if (request.exception != null) {
            throw (IOException)new IOException("Failed to bind").initCause(request.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            this.cancelQueue.add(request);
            this.selector.wakeup();
        }
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
        if (request.exception != null) {
            throw new RuntimeException("Failed to unbind", request.exception);
        }
    }

    @Override
    public void unbindAll() {
        ArrayList addresses = new ArrayList(this.channels.keySet());
        for (SocketAddress address : addresses) {
            this.unbind(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        IoSession session;
        IoSessionRecycler sessionRecycler;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        Selector selector = this.selector;
        DatagramChannel ch = this.channels.get(localAddress);
        if (selector == null || ch == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        SelectionKey key = ch.keyFor(selector);
        if (key == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        RegistrationRequest req = (RegistrationRequest)key.attachment();
        IoSessionRecycler ioSessionRecycler = sessionRecycler = this.getSessionRecycler(req);
        synchronized (ioSessionRecycler) {
            session = sessionRecycler.recycle(localAddress, remoteAddress);
            if (session != null) {
                return session;
            }
            DatagramSessionImpl datagramSession = new DatagramSessionImpl(this.wrapper, this, req.config, ch, req.handler, req.address, req.address);
            datagramSession.setRemoteAddress(remoteAddress);
            datagramSession.setSelectionKey(key);
            this.getSessionRecycler(req).put(datagramSession);
            session = datagramSession;
        }
        try {
            this.buildFilterChain(req, session);
            this.getListeners().fireSessionCreated(session);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        return session;
    }

    private IoSessionRecycler getSessionRecycler(RegistrationRequest req) {
        IoSessionRecycler sessionRecycler = req.config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)req.config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return sessionRecycler;
    }

    @Override
    public IoServiceListenerSupport getListeners() {
        return super.getListeners();
    }

    private void buildFilterChain(RegistrationRequest req, IoSession session) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
    }

    @Override
    public DatagramAcceptorConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramAcceptorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker, "DatagramAcceptor-" + this.id));
            }
        }
    }

    @Override
    public void flushSession(DatagramSessionImpl session) {
        Selector selector;
        if (this.scheduleFlush(session) && (selector = this.selector) != null) {
            selector.wakeup();
        }
    }

    @Override
    public void closeSession(DatagramSessionImpl session) {
    }

    private boolean scheduleFlush(DatagramSessionImpl session) {
        if (session.setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    private void processReadySessions(Set<SelectionKey> keys) {
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            DatagramChannel ch = (DatagramChannel)key.channel();
            RegistrationRequest req = (RegistrationRequest)key.attachment();
            try {
                if (key.isReadable()) {
                    this.readSession(ch, req);
                }
                if (!key.isWritable()) continue;
                for (IoSession o : this.getManagedSessions(req.address)) {
                    this.scheduleFlush((DatagramSessionImpl)o);
                }
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
        }
    }

    private void readSession(DatagramChannel channel, RegistrationRequest req) throws Exception {
        ByteBuffer readBuf = ByteBuffer.allocate(((DatagramSessionConfig)req.config.getSessionConfig()).getReceiveBufferSize());
        try {
            SocketAddress remoteAddress = channel.receive(readBuf.buf());
            if (remoteAddress != null) {
                DatagramSessionImpl session = (DatagramSessionImpl)this.newSession(remoteAddress, req.address);
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(newBuf.remaining());
                session.getFilterChain().fireMessageReceived(session, newBuf);
            }
        }
        finally {
            readBuf.release();
        }
    }

    private void flushSessions() {
        DatagramSessionImpl session;
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while ((session = this.flushingSessions.poll()) != null) {
            session.setScheduledForFlush(false);
            try {
                boolean flushedAll = this.flush(session);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty() || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    private boolean flush(DatagramSessionImpl session) throws IOException {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            this.scheduleFlush(session);
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        DatagramChannel ch = session.getChannel();
        Queue<IoFilter.WriteRequest> writeRequestQueue = session.getWriteRequestQueue();
        int writtenBytes = 0;
        int maxWrittenBytes = ((DatagramSessionConfig)session.getConfig()).getSendBufferSize() << 1;
        try {
            IoFilter.WriteRequest req;
            while ((req = writeRequestQueue.peek()) != null) {
                int localWrittenBytes;
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    writeRequestQueue.poll();
                    buf.reset();
                    if (!buf.hasRemaining()) {
                        session.increaseWrittenMessages();
                    }
                    session.getFilterChain().fireMessageSent(session, req);
                    continue;
                }
                SocketAddress destination = req.getDestination();
                if (destination == null) {
                    destination = session.getRemoteAddress();
                }
                if ((localWrittenBytes = ch.send(buf.buf(), destination)) == 0 || (writtenBytes += localWrittenBytes) >= maxWrittenBytes) {
                    key.interestOps(key.interestOps() | 4);
                    return false;
                }
                writeRequestQueue.poll();
                buf.reset();
                if (!buf.hasRemaining()) {
                    session.increaseWrittenMessages();
                }
                session.getFilterChain().fireMessageSent(session, req);
            }
        }
        finally {
            session.increaseWrittenBytes(writtenBytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        RegistrationRequest req;
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((req = this.registerQueue.poll()) != null) {
            RegistrationRequest e2;
            DatagramChannel ch = null;
            try {
                try {
                    ch = DatagramChannel.open();
                    DatagramSessionConfig cfg = req.config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)req.config.getSessionConfig() : this.getDefaultConfig().getSessionConfig();
                    ch.socket().setReuseAddress(cfg.isReuseAddress());
                    ch.socket().setBroadcast(cfg.isBroadcast());
                    ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
                    ch.socket().setSendBufferSize(cfg.getSendBufferSize());
                    if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                        ch.socket().setTrafficClass(cfg.getTrafficClass());
                    }
                    ch.configureBlocking(false);
                    ch.socket().bind(req.address);
                    if (req.address == null || req.address.getPort() == 0) {
                        req.address = (InetSocketAddress)ch.socket().getLocalSocketAddress();
                    }
                    ch.register(selector, 1, req);
                    this.channels.put(req.address, ch);
                    this.getListeners().fireServiceActivated(this, req.address, req.handler, req.config);
                }
                catch (Throwable t) {
                    req.exception = t;
                    RegistrationRequest registrationRequest = req;
                    synchronized (registrationRequest) {
                        req.done = true;
                        req.notify();
                    }
                    if (ch == null || req.exception == null) continue;
                    try {
                        ch.disconnect();
                        ch.close();
                    }
                    catch (Throwable e2) {
                        ExceptionMonitor.getInstance().exceptionCaught(e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                e2 = req;
                synchronized (e2) {
                    req.done = true;
                    req.notify();
                }
                if (ch != null && req.exception != null) {
                    try {
                        ch.disconnect();
                        ch.close();
                    }
                    catch (Throwable e3) {
                        ExceptionMonitor.getInstance().exceptionCaught(e3);
                    }
                }
                throw throwable;
            }
            e2 = req;
            synchronized (e2) {
                req.done = true;
                req.notify();
            }
            if (ch == null || req.exception == null) continue;
            try {
                ch.disconnect();
                ch.close();
            }
            catch (Throwable e2) {
                ExceptionMonitor.getInstance().exceptionCaught(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        CancellationRequest request;
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((request = this.cancelQueue.poll()) != null) {
            CancellationRequest cancellationRequest;
            DatagramChannel ch = this.channels.remove(request.address);
            try {
                try {
                    if (ch == null) {
                        request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    } else {
                        SelectionKey key = ch.keyFor(selector);
                        request.registrationRequest = (RegistrationRequest)key.attachment();
                        key.cancel();
                        selector.wakeup();
                        ch.disconnect();
                        ch.close();
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    cancellationRequest = request;
                    synchronized (cancellationRequest) {
                        request.done = true;
                        request.notify();
                    }
                    if (request.exception != null) continue;
                    this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                    continue;
                }
            }
            catch (Throwable throwable) {
                cancellationRequest = request;
                synchronized (cancellationRequest) {
                    request.done = true;
                    request.notify();
                }
                if (request.exception == null) {
                    this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                }
                throw throwable;
            }
            cancellationRequest = request;
            synchronized (cancellationRequest) {
                request.done = true;
                request.notify();
            }
            if (request.exception != null) continue;
            this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
        }
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl session) {
    }

    static /* synthetic */ Selector access$1(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        return datagramAcceptorDelegate.selector;
    }

    static /* synthetic */ void access$2(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        datagramAcceptorDelegate.registerNew();
    }

    static /* synthetic */ void access$3(DatagramAcceptorDelegate datagramAcceptorDelegate, Set set) {
        datagramAcceptorDelegate.processReadySessions(set);
    }

    static /* synthetic */ void access$4(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        datagramAcceptorDelegate.flushSessions();
    }

    static /* synthetic */ void access$5(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        datagramAcceptorDelegate.cancelKeys();
    }

    static /* synthetic */ Object access$6(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        return datagramAcceptorDelegate.lock;
    }

    static /* synthetic */ Queue access$7(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        return datagramAcceptorDelegate.registerQueue;
    }

    static /* synthetic */ Queue access$8(DatagramAcceptorDelegate datagramAcceptorDelegate) {
        return datagramAcceptorDelegate.cancelQueue;
    }

    static /* synthetic */ void access$9(DatagramAcceptorDelegate datagramAcceptorDelegate, Worker worker) {
        datagramAcceptorDelegate.worker = worker;
    }

    static /* synthetic */ void access$10(DatagramAcceptorDelegate datagramAcceptorDelegate, Selector selector) {
        datagramAcceptorDelegate.selector = selector;
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private InetSocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private Throwable exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoServiceConfig config) {
            this.address = (InetSocketAddress)address;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            selector = DatagramAcceptorDelegate.access$1(DatagramAcceptorDelegate.this);
            block11: while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        nKeys = selector.select();
                        DatagramAcceptorDelegate.access$2(DatagramAcceptorDelegate.this);
                        if (nKeys > 0) {
                            DatagramAcceptorDelegate.access$3(DatagramAcceptorDelegate.this, selector.selectedKeys());
                        }
                        DatagramAcceptorDelegate.access$4(DatagramAcceptorDelegate.this);
                        DatagramAcceptorDelegate.access$5(DatagramAcceptorDelegate.this);
                        if (!selector.keys().isEmpty()) continue;
                        var3_4 = DatagramAcceptorDelegate.access$6(DatagramAcceptorDelegate.this);
                        synchronized (var3_4) {
                            if (selector.keys().isEmpty() && DatagramAcceptorDelegate.access$7(DatagramAcceptorDelegate.this).isEmpty() && DatagramAcceptorDelegate.access$8(DatagramAcceptorDelegate.this).isEmpty()) {
                                block16: {
                                    DatagramAcceptorDelegate.access$9(DatagramAcceptorDelegate.this, null);
                                    try {
                                        try {
                                            selector.close();
                                        }
                                        catch (IOException e) {
                                            ExceptionMonitor.getInstance().exceptionCaught(e);
                                            DatagramAcceptorDelegate.access$10(DatagramAcceptorDelegate.this, null);
                                            break block16;
                                        }
                                    }
                                    catch (Throwable var5_7) {
                                        DatagramAcceptorDelegate.access$10(DatagramAcceptorDelegate.this, null);
                                        throw var5_7;
                                    }
                                    DatagramAcceptorDelegate.access$10(DatagramAcceptorDelegate.this, null);
                                }
                                break block11;
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

