/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;

public class SocketAcceptor
extends BaseIoAcceptor {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final Executor executor;
    private final Object lock = new Object();
    private final int id = nextId.getAndIncrement();
    private final String threadName = "SocketAcceptor-" + this.id;
    private SocketAcceptorConfig defaultConfig = new SocketAcceptorConfig();
    private final Map<SocketAddress, ServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, ServerSocketChannel>();
    private final Queue<RegistrationRequest> registerQueue = new ConcurrentLinkedQueue<RegistrationRequest>();
    private final Queue<CancellationRequest> cancelQueue = new ConcurrentLinkedQueue<CancellationRequest>();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private volatile Selector selector;
    private Worker worker;
    private int processorDistributor = 0;

    public SocketAcceptor() {
        this(1, new NewThreadExecutor());
    }

    public SocketAcceptor(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.defaultConfig.getSessionConfig().setReuseAddress(true);
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        int i = 0;
        while (i < processorCount) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketAcceptorIoProcessor-" + this.id + "." + i, executor);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, config);
        Object object = this.lock;
        synchronized (object) {
            this.startupWorker();
            this.registerQueue.add(request);
            this.selector.wakeup();
        }
        try {
            request.done.await();
        }
        catch (InterruptedException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
        }
        if (request.exception != null) {
            throw request.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker, this.threadName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            this.cancelQueue.add(request);
            this.selector.wakeup();
        }
        try {
            request.done.await();
        }
        catch (InterruptedException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    public void unbindAll() {
        ArrayList addresses = new ArrayList(this.channels.keySet());
        for (SocketAddress address : addresses) {
            this.unbind(address);
        }
    }

    private SocketIoProcessor nextProcessor() {
        if (this.processorDistributor == Integer.MAX_VALUE) {
            this.processorDistributor = Integer.MAX_VALUE % this.processorCount;
        }
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    public SocketAcceptorConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketAcceptorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    private void registerNew() {
        RegistrationRequest req;
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((req = this.registerQueue.poll()) != null) {
            ServerSocketChannel ssc = null;
            try {
                try {
                    ssc = ServerSocketChannel.open();
                    ssc.configureBlocking(false);
                    SocketAcceptorConfig cfg = req.config instanceof SocketAcceptorConfig ? (SocketAcceptorConfig)req.config : this.getDefaultConfig();
                    ssc.socket().setReuseAddress(cfg.isReuseAddress());
                    ssc.socket().setReceiveBufferSize(cfg.getSessionConfig().getReceiveBufferSize());
                    ssc.socket().bind(req.address, cfg.getBacklog());
                    if (req.address == null || req.address.getPort() == 0) {
                        req.address = (InetSocketAddress)ssc.socket().getLocalSocketAddress();
                    }
                    ssc.register(selector, 16, req);
                    this.channels.put(req.address, ssc);
                    this.getListeners().fireServiceActivated(this, req.address, req.handler, req.config);
                }
                catch (IOException e) {
                    req.exception = e;
                    req.done.countDown();
                    if (ssc == null || req.exception == null) continue;
                    try {
                        ssc.close();
                    }
                    catch (IOException e2) {
                        ExceptionMonitor.getInstance().exceptionCaught(e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                req.done.countDown();
                if (ssc != null && req.exception != null) {
                    try {
                        ssc.close();
                    }
                    catch (IOException e) {
                        ExceptionMonitor.getInstance().exceptionCaught(e);
                    }
                }
                throw throwable;
            }
            req.done.countDown();
            if (ssc == null || req.exception == null) continue;
            try {
                ssc.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
        }
    }

    private void cancelKeys() {
        CancellationRequest request;
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((request = this.cancelQueue.poll()) != null) {
            ServerSocketChannel ssc = this.channels.remove(request.address);
            try {
                try {
                    if (ssc == null) {
                        request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    } else {
                        SelectionKey key = ssc.keyFor(selector);
                        request.registrationRequest = (RegistrationRequest)key.attachment();
                        key.cancel();
                        selector.wakeup();
                        ssc.close();
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    request.done.countDown();
                    if (request.exception != null) continue;
                    this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                    continue;
                }
            }
            catch (Throwable throwable) {
                request.done.countDown();
                if (request.exception == null) {
                    this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                }
                throw throwable;
            }
            request.done.countDown();
            if (request.exception != null) continue;
            this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
        }
    }

    static /* synthetic */ Selector access$1(SocketAcceptor socketAcceptor) {
        return socketAcceptor.selector;
    }

    static /* synthetic */ void access$2(SocketAcceptor socketAcceptor) {
        socketAcceptor.registerNew();
    }

    static /* synthetic */ void access$3(SocketAcceptor socketAcceptor) {
        socketAcceptor.cancelKeys();
    }

    static /* synthetic */ Object access$4(SocketAcceptor socketAcceptor) {
        return socketAcceptor.lock;
    }

    static /* synthetic */ Queue access$5(SocketAcceptor socketAcceptor) {
        return socketAcceptor.registerQueue;
    }

    static /* synthetic */ Queue access$6(SocketAcceptor socketAcceptor) {
        return socketAcceptor.cancelQueue;
    }

    static /* synthetic */ void access$7(SocketAcceptor socketAcceptor, Worker worker) {
        socketAcceptor.worker = worker;
    }

    static /* synthetic */ void access$8(SocketAcceptor socketAcceptor, Selector selector) {
        socketAcceptor.selector = selector;
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private final CountDownLatch done = new CountDownLatch(1);
        private RegistrationRequest registrationRequest;
        private volatile RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private InetSocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private final CountDownLatch done = new CountDownLatch(1);
        private volatile IOException exception;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoServiceConfig config) {
            this.address = (InetSocketAddress)address;
            this.handler = handler;
            this.config = config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            selector = SocketAcceptor.access$1(SocketAcceptor.this);
            block11: while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        nKeys = selector.select();
                        SocketAcceptor.access$2(SocketAcceptor.this);
                        if (nKeys > 0) {
                            this.processSessions(selector.selectedKeys());
                        }
                        SocketAcceptor.access$3(SocketAcceptor.this);
                        if (!selector.keys().isEmpty()) continue;
                        var3_4 = SocketAcceptor.access$4(SocketAcceptor.this);
                        synchronized (var3_4) {
                            if (selector.keys().isEmpty() && SocketAcceptor.access$5(SocketAcceptor.this).isEmpty() && SocketAcceptor.access$6(SocketAcceptor.this).isEmpty()) {
                                block16: {
                                    SocketAcceptor.access$7(SocketAcceptor.this, null);
                                    try {
                                        try {
                                            selector.close();
                                        }
                                        catch (IOException e) {
                                            ExceptionMonitor.getInstance().exceptionCaught(e);
                                            SocketAcceptor.access$8(SocketAcceptor.this, null);
                                            break block16;
                                        }
                                    }
                                    catch (Throwable var5_7) {
                                        SocketAcceptor.access$8(SocketAcceptor.this, null);
                                        throw var5_7;
                                    }
                                    SocketAcceptor.access$8(SocketAcceptor.this, null);
                                }
                                break block11;
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }

        private void processSessions(Set<SelectionKey> keys) throws IOException {
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                ServerSocketChannel ssc;
                SocketChannel ch;
                SelectionKey key = it.next();
                it.remove();
                if (!key.isAcceptable() || (ch = (ssc = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                boolean success = false;
                try {
                    try {
                        RegistrationRequest req = (RegistrationRequest)key.attachment();
                        SocketSessionImpl session = new SocketSessionImpl(SocketAcceptor.this, SocketAcceptor.this.nextProcessor(), SocketAcceptor.this.getListeners(), req.config, ch, req.handler, req.address);
                        SocketAcceptor.this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
                        session.getIoProcessor().addNew(session);
                        success = true;
                    }
                    catch (Throwable t) {
                        ExceptionMonitor.getInstance().exceptionCaught(t);
                        if (success) continue;
                        ch.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ch.close();
                    }
                    throw throwable;
                }
                if (success) continue;
                ch.close();
            }
        }
    }
}

