/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.avis.io.XdrCoding;
import org.avis.util.InvalidFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Text {
    private static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private Text() {
    }

    public static String className(Object object) {
        return Text.className(object.getClass());
    }

    public static String className(Class<?> type) {
        String name = type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String shortException(Throwable ex) {
        if (ex.getMessage() == null) {
            return Text.className(ex.getClass());
        }
        return Text.className(ex.getClass()) + ": " + ex.getMessage();
    }

    public static String idFor(Object instance) {
        return Integer.toHexString(System.identityHashCode(instance));
    }

    public static String formatNotification(Map<String, Object> attributes) {
        String[] names = new String[attributes.size()];
        attributes.keySet().toArray(names);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        StringBuilder str = new StringBuilder(names.length * 16);
        boolean first = true;
        for (String name : names) {
            if (!first) {
                str.append('\n');
            }
            first = false;
            Text.appendEscaped(str, name, " :");
            str.append(": ");
            Text.appendValue(str, attributes.get(name));
        }
        return str.toString();
    }

    private static void appendValue(StringBuilder str, Object value) {
        if (value instanceof String) {
            str.append('\"');
            Text.appendEscaped(str, (String)value, '\"');
            str.append('\"');
        } else if (value instanceof Number) {
            str.append(value);
            if (value instanceof Long) {
                str.append('L');
            }
        } else {
            str.append('[');
            Text.appendHexBytes(str, (byte[])value);
            str.append(']');
        }
    }

    public static void appendEscaped(StringBuilder builder, String string, char charToEscape) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == charToEscape) {
                builder.append('\\');
            }
            builder.append(c);
        }
    }

    public static void appendEscaped(StringBuilder builder, String string, String charsToEscape) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (charsToEscape.indexOf(c) != -1) {
                builder.append('\\');
            }
            builder.append(c);
        }
    }

    public static void appendHexBytes(StringBuilder str, byte[] bytes) {
        boolean first = true;
        for (byte b : bytes) {
            if (!first) {
                str.append(' ');
            }
            first = false;
            Text.appendHex(str, b);
        }
    }

    public static void appendHex(StringBuilder str, byte b) {
        str.append(HEX_TABLE[b >>> 4 & 0xF]);
        str.append(HEX_TABLE[b >>> 0 & 0xF]);
    }

    public static byte hexToByte(String byteExpr) throws InvalidFormatException {
        if (byteExpr.length() == 0) {
            throw new InvalidFormatException("Byte value cannot be empty");
        }
        if (byteExpr.length() > 2) {
            throw new InvalidFormatException("Byte value too long: \"" + byteExpr + "\"");
        }
        int value = 0;
        for (int i = 0; i < byteExpr.length(); ++i) {
            value = value << 4 | Text.hexValue(byteExpr.charAt(i));
        }
        return (byte)value;
    }

    public static Object stringToValue(String expr) throws InvalidFormatException {
        char firstChar = expr.charAt(0);
        if (firstChar == '\"' || firstChar == '\'') {
            return Text.quotedStringToString(expr);
        }
        if (firstChar >= '0' && firstChar <= '9') {
            return Text.stringToNumber(expr);
        }
        if (firstChar == '[') {
            return Text.stringToOpaque(expr);
        }
        throw new InvalidFormatException("Unrecognised value expression: \"" + expr + "\"");
    }

    public static Number stringToNumber(String valueExpr) throws InvalidFormatException {
        try {
            if (valueExpr.indexOf(46) != -1) {
                return Double.valueOf(valueExpr);
            }
            if (valueExpr.endsWith("L") || valueExpr.endsWith("l")) {
                return Long.decode(valueExpr.substring(0, valueExpr.length() - 1));
            }
            return Integer.decode(valueExpr);
        }
        catch (NumberFormatException ex) {
            throw new InvalidFormatException("Invalid number: " + valueExpr);
        }
    }

    public static String quotedStringToString(String valueExpr) throws InvalidFormatException {
        if (valueExpr.length() == 0) {
            throw new InvalidFormatException("Empty string");
        }
        char quote = valueExpr.charAt(0);
        if (quote != '\'' && quote != '\"') {
            throw new InvalidFormatException("String must start with a quote");
        }
        int last = Text.findFirstNonEscaped(valueExpr, 1, quote);
        if (last == -1) {
            throw new InvalidFormatException("Missing terminating quote in string");
        }
        if (last != valueExpr.length() - 1) {
            throw new InvalidFormatException("Extra characters following string");
        }
        return Text.stripBackslashes(valueExpr.substring(1, last));
    }

    public static byte[] stringToOpaque(String valueExpr) throws InvalidFormatException {
        if (valueExpr.length() < 2) {
            throw new InvalidFormatException("Opaque value too short");
        }
        if (valueExpr.charAt(0) != '[') {
            throw new InvalidFormatException("Missing '[' at start of opaque");
        }
        int closingBrace = valueExpr.indexOf(93);
        if (closingBrace == -1) {
            throw new InvalidFormatException("Missing closing \"]\"");
        }
        if (closingBrace != valueExpr.length() - 1) {
            throw new InvalidFormatException("Junk at end of opaque value");
        }
        return Text.hexToBytes(valueExpr.substring(1, closingBrace));
    }

    public static byte[] hexToBytes(String string) throws InvalidFormatException {
        if ((string = string.replaceAll("\\s+", "")).length() % 2 != 0) {
            throw new InvalidFormatException("Hex bytes must be a set of hex pairs");
        }
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            bytes[i / 2] = Text.hexToByte(string.substring(i, i + 2));
        }
        return bytes;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder str = new StringBuilder(bytes.length * 3);
        Text.appendHexBytes(str, bytes);
        return str.toString();
    }

    public static byte[] dataToBytes(byte[] expr) throws InvalidFormatException {
        if (expr.length == 0) {
            throw new InvalidFormatException("Expression cannot be empty");
        }
        try {
            switch (expr[0]) {
                case 91: {
                    return Text.stringToOpaque(XdrCoding.fromUTF8(expr, 0, expr.length).trim());
                }
                case 34: {
                    return XdrCoding.toUTF8(Text.quotedStringToString(XdrCoding.fromUTF8(expr, 0, expr.length).trim()));
                }
                case 35: {
                    return Text.slice(expr, 1, expr.length);
                }
            }
            throw new InvalidFormatException("Unknown data block format");
        }
        catch (CharacterCodingException ex) {
            throw new InvalidFormatException("Invalid UTF-8 string");
        }
    }

    public static byte[] slice(byte[] bytes, int start, int end) {
        byte[] slice = new byte[end - start];
        System.arraycopy(bytes, start, slice, 0, slice.length);
        return slice;
    }

    public static int findFirstNonEscaped(String str, char toFind) {
        return Text.findFirstNonEscaped(str, 0, toFind);
    }

    public static int findFirstNonEscaped(String str, int start, char toFind) {
        boolean escaped = false;
        for (int i = start; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == toFind) {
                return i;
            }
            escaped = false;
        }
        return -1;
    }

    public static String stripBackslashes(String text) throws InvalidFormatException {
        if (text.indexOf(92) != -1) {
            StringBuilder buff = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\\') {
                    buff.append(c);
                    continue;
                }
                if (++i < text.length()) {
                    buff.append(text.charAt(i));
                    continue;
                }
                throw new InvalidFormatException("Invalid trailing \\");
            }
            text = buff.toString();
        }
        return text;
    }

    public static String[] split(String text) {
        return Text.split(text, "\\s+");
    }

    public static String[] split(String text, String regex) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return text.split(regex);
    }

    public static String join(Object[] items) {
        return Text.join(items, ", ");
    }

    public static String join(Object[] items, String separator) {
        return Text.join(Arrays.asList(items), separator);
    }

    public static String join(List<?> items, String separator) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (Object item : items) {
            if (!first) {
                str.append(separator);
            }
            first = false;
            str.append(item);
        }
        return str.toString();
    }

    public static String mapToString(Map<?, ?> map) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                str.append(", ");
            }
            first = false;
            str.append('{');
            str.append(entry.getKey()).append(" = ").append(entry.getValue());
            str.append('}');
        }
        return str.toString();
    }

    public static String expandBackslashes(String text) throws InvalidFormatException {
        if (text.indexOf(92) != -1) {
            StringBuilder buff = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\\') {
                    c = text.charAt(++i);
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'a': {
                            c = '\u0007';
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int value = c - 48;
                            int end = Math.min(text.length(), i + 3);
                            while (i + 1 < end && Text.octDigit(text.charAt(i + 1))) {
                                c = text.charAt(++i);
                                value = value * 8 + (c - 48);
                            }
                            c = (char)value;
                            break;
                        }
                        case 'x': {
                            int value = 0;
                            int end = Math.min(text.length(), i + 3);
                            do {
                                c = text.charAt(++i);
                                value = value * 16 + Text.hexValue(c);
                            } while (i + 1 < end && Text.hexDigit(text.charAt(i + 1)));
                            c = (char)value;
                        }
                    }
                }
                buff.append(c);
            }
            text = buff.toString();
        }
        return text;
    }

    private static boolean octDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean hexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static int hexValue(char c) throws InvalidFormatException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new InvalidFormatException("Not a valid hex character: " + c);
    }
}

