/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public final class Streams {
    private Streams() {
    }

    public static BufferedReader bufferedReaderFor(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFrom(InputStream in) throws IOException {
        try {
            int length;
            ByteArrayOutputStream str = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                str.write(buffer, 0, length);
            }
            byte[] byArray = str.toByteArray();
            return byArray;
        }
        finally {
            Streams.close(in);
        }
    }

    public static boolean eof(Reader in) throws IOException {
        in.mark(10);
        if (in.read() == -1) {
            return true;
        }
        in.reset();
        return false;
    }

    public static InputStream fileStream(File file) throws FileNotFoundException {
        return Streams.fileStream(file.getPath());
    }

    public static InputStream fileStream(String filename) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties propertiesFrom(InputStream in) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            Streams.close(in);
        }
    }

    public static String readLine(Reader in) throws IOException {
        int state = 0;
        StringBuilder str = new StringBuilder();
        block19: while (true) {
            in.mark(1);
            int c = in.read();
            switch (c) {
                case -1: {
                    switch (state) {
                        case 0: {
                            return null;
                        }
                    }
                    return str.toString();
                }
                case 13: {
                    switch (state) {
                        case 0: 
                        case 1: {
                            state = 2;
                            continue block19;
                        }
                        case 2: {
                            in.reset();
                        }
                    }
                    return str.toString();
                }
                case 10: {
                    switch (state) {
                        case 0: 
                        case 1: {
                            state = 3;
                            continue block19;
                        }
                        case 3: {
                            in.reset();
                        }
                    }
                    return str.toString();
                }
            }
            switch (state) {
                case 2: 
                case 3: {
                    in.reset();
                    return str.toString();
                }
            }
            state = 1;
            str.append((char)c);
        }
    }

    public static InputStream resourceStream(String resource) throws FileNotFoundException {
        InputStream in = Streams.class.getResourceAsStream(resource);
        if (in == null) {
            throw new FileNotFoundException("Missing resource: " + resource);
        }
        return in;
    }

    public static String stringFrom(InputStream stream) throws IOException {
        return Streams.stringFrom(new InputStreamReader(stream, "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFrom(Reader reader) throws IOException {
        try {
            int length;
            StringBuilder str = new StringBuilder();
            char[] buffer = new char[4096];
            while ((length = reader.read(buffer)) != -1) {
                str.append(buffer, 0, length);
            }
            String string = str.toString();
            return string;
        }
        finally {
            Streams.close(reader);
        }
    }

    public static boolean close(Closeable in) {
        try {
            in.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

