/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    private Collections() {
    }

    public static <E> Set<E> set(E ... items) {
        return java.util.Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(items)));
    }

    public static <E> List<E> list(E ... items) {
        return java.util.Collections.unmodifiableList(Arrays.asList(items));
    }

    public static <E> Map<E, E> map(E ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Items must be a set of pairs");
        }
        HashMap<E, E> map = new HashMap<E, E>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return java.util.Collections.unmodifiableMap(map);
    }

    public static void join(StringBuilder str, Iterable<?> items, char separator) {
        boolean first = true;
        for (Object item : items) {
            if (!first) {
                str.append(separator);
            }
            first = false;
            str.append(item);
        }
    }

    public static <T> Set<T> difference(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty() || set2.isEmpty()) {
            return set1;
        }
        HashSet<T> diff = new HashSet<T>();
        for (T item : set1) {
            if (set2.contains(item)) continue;
            diff.add(item);
        }
        return diff;
    }

    public static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return set2;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet<T> union = new HashSet<T>();
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public static <K, V> Map<K, V> union(Map<K, V> map1, Map<K, V> map2) {
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        HashMap<K, V> union = new HashMap<K, V>();
        union.putAll(map1);
        union.putAll(map2);
        return union;
    }
}

