/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast.nodes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathBitInvert
extends Node {
    private Node child;

    public MathBitInvert(Node child) throws IllegalChildException {
        Class<?> childType = child.evalType();
        if (childType != Object.class && childType != Integer.class && child.evalType() != Long.class) {
            throw new IllegalChildException("~ requires an integer argument", this, child);
        }
        this.child = child;
    }

    @Override
    public String expr() {
        return "~";
    }

    @Override
    public String presentation() {
        return this.name();
    }

    @Override
    public Class<?> evalType() {
        return this.child.evalType();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Collection<Node> children() {
        return Collections.singleton(this.child);
    }

    @Override
    public Node inlineConstants() {
        this.child = this.child.inlineConstants();
        Object result = this.evaluate(EMPTY_NOTIFICATION);
        if (result != null) {
            return new Const(result);
        }
        return this;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        Object result = this.child.evaluate(attrs);
        if (result instanceof Integer) {
            return ~((Integer)result).intValue();
        }
        if (result instanceof Long) {
            return (Long)result ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return BOTTOM;
    }
}

