/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast.nodes;

import java.util.List;
import java.util.Map;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.ParentBiNode;
import org.avis.subscription.ast.nodes.Or;
import org.avis.util.Numbers;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compare
extends ParentBiNode {
    public int inequality;
    public boolean equality;

    public static Node createEquals(List<Node> args) {
        if (args.size() < 2) {
            throw new IllegalArgumentException("Two or more children required");
        }
        if (args.size() == 2) {
            return new Compare(args.get(0), args.get(1), 0, true);
        }
        Node arg0 = args.get(0);
        Or or = new Or();
        for (int i = 1; i < args.size(); ++i) {
            or.addChild(new Compare(arg0, args.get(i), 0, true));
        }
        return or;
    }

    public Compare(Node child1, Node child2, int inequality, boolean equality) {
        this.inequality = inequality;
        this.equality = equality;
        this.init(child1, child2);
    }

    @Override
    protected String validateChild(Node child) {
        Class<?> evalType;
        Class<?> childType = child.evalType();
        if (childType == Object.class) {
            return null;
        }
        if (!(childType == Number.class || childType != Boolean.class && Comparable.class.isAssignableFrom(childType))) {
            return this.expr() + " cannot have expression of type " + Text.className(childType) + " as an argument";
        }
        if (!(this.child1 == null || (evalType = this.child1.evalType()) == Object.class || evalType == childType || Number.class.isAssignableFrom(evalType) && Number.class.isAssignableFrom(childType))) {
            return this.expr() + ": argument (" + child.expr() + ") cannot be compared to " + "(" + this.child1.expr() + ")";
        }
        return null;
    }

    @Override
    public Class<?> evalType() {
        return Boolean.class;
    }

    @Override
    public String expr() {
        StringBuilder str = new StringBuilder();
        if (this.inequality < 0) {
            str.append('<');
        } else if (this.inequality > 0) {
            str.append('>');
        }
        if (this.equality) {
            if (str.length() == 0) {
                str.append("==");
            } else {
                str.append('=');
            }
        }
        return str.toString();
    }

    @Override
    public String presentation() {
        return "Compare: " + this.expr();
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        int compare;
        Class<?> class2;
        Object result1 = this.child1.evaluate(attrs);
        if (!(result1 instanceof Comparable)) {
            return BOTTOM;
        }
        Object result2 = this.child2.evaluate(attrs);
        if (!(result2 instanceof Comparable)) {
            return BOTTOM;
        }
        Class<?> class1 = result1.getClass();
        if (class1 != (class2 = result2.getClass())) {
            if (class1.getSuperclass() == Number.class && class2.getSuperclass() == Number.class) {
                Class<? extends Number> newType = Numbers.highestPrecision(class1, class2);
                if (class1 != newType) {
                    result1 = Numbers.upconvert((Number)result1, class2);
                } else {
                    result2 = Numbers.upconvert((Number)result2, class1);
                }
            } else {
                return BOTTOM;
            }
        }
        if ((compare = ((Comparable)result1).compareTo(result2)) == 0) {
            return this.equality;
        }
        if (compare < 0) {
            return this.inequality < 0;
        }
        return this.inequality > 0;
    }
}

