/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import java.util.Map;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.ParentBiNode;
import org.avis.util.Numbers;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MathParentNode
extends ParentBiNode {
    public MathParentNode(Node child1, Node child2) {
        super(child1, child2);
    }

    @Override
    protected String validateChild(Node child) {
        Class<?> childType = child.evalType();
        if (childType == Object.class) {
            return null;
        }
        if (!Number.class.isAssignableFrom(childType)) {
            return "\"" + this.expr() + "\" needs a number as an argument (was " + Text.className(child.evalType()).toLowerCase() + ")";
        }
        return null;
    }

    @Override
    public Class<?> evalType() {
        return Number.class;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        Class<?> type2;
        Number number1 = this.evaluate(this.child1, attrs);
        if (number1 == null) {
            return null;
        }
        Number number2 = this.evaluate(this.child2, attrs);
        if (number2 == null) {
            return null;
        }
        Class<?> type1 = number1.getClass();
        if (type1 != (type2 = number2.getClass())) {
            Class<? extends Number> newType = Numbers.highestPrecision(type1, type2);
            if (type1 != newType) {
                number1 = Numbers.upconvert(number1, type2);
            } else {
                number2 = Numbers.upconvert(number2, type1);
            }
        }
        try {
            if (number1 instanceof Integer) {
                return this.evaluateInt32((Integer)number1, (Integer)number2);
            }
            if (number1 instanceof Long) {
                return this.evaluateInt64((Long)number1, (Long)number2);
            }
            return this.evaluateReal64((Double)number1, (Double)number2);
        }
        catch (ArithmeticException ex) {
            return null;
        }
    }

    private Number evaluate(Node child, Map<String, Object> attrs) {
        Object result = child.evaluate(attrs);
        if (result == null || !this.validOperand(result)) {
            return null;
        }
        return (Number)result;
    }

    protected boolean validOperand(Object value) {
        return value instanceof Number;
    }

    protected abstract int evaluateInt32(int var1, int var2);

    protected abstract long evaluateInt64(long var1, long var3);

    protected abstract double evaluateReal64(double var1, double var3);
}

