/*
 * Decompiled with CFR 0.152.
 */
package org.avis.security;

import java.util.Set;
import org.avis.security.DualKeyScheme;
import org.avis.security.DualKeySet;
import org.avis.security.Key;
import org.avis.security.KeySet;
import org.avis.security.SecureHash;
import org.avis.security.SingleKeyScheme;
import org.avis.security.SingleKeySet;
import org.avis.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyScheme {
    public static final DualKeyScheme SHA1_DUAL = new DualKeyScheme(1, SecureHash.SHA1);
    public static final SingleKeyScheme SHA1_PRODUCER = new SingleKeyScheme(2, SecureHash.SHA1, true, false);
    public static final SingleKeyScheme SHA1_CONSUMER = new SingleKeyScheme(3, SecureHash.SHA1, false, true);
    private static final Set<KeyScheme> SCHEMES = Collections.set(SHA1_CONSUMER, SHA1_PRODUCER, SHA1_DUAL);
    public final int id;
    public final boolean producer;
    public final boolean consumer;
    public final SecureHash keyHash;
    public final String name;

    KeyScheme(int id, SecureHash keyHash, boolean producer, boolean consumer) {
        this.id = id;
        this.producer = producer;
        this.consumer = consumer;
        this.keyHash = keyHash;
        this.name = this.createName();
    }

    public boolean isDual() {
        return this.producer && this.consumer;
    }

    public Key publicKeyFor(Key privateKey) {
        return new Key(this.keyHash.hash(privateKey.data));
    }

    boolean match(KeySet producerKeys, KeySet consumerKeys) {
        if (this.isDual()) {
            DualKeySet keys1 = (DualKeySet)producerKeys;
            DualKeySet keys2 = (DualKeySet)consumerKeys;
            return this.matchKeys(keys1.producerKeys, keys2.producerKeys) && this.matchKeys(keys2.consumerKeys, keys1.consumerKeys);
        }
        if (this.producer) {
            return this.matchKeys((SingleKeySet)producerKeys, (SingleKeySet)consumerKeys);
        }
        return this.matchKeys((SingleKeySet)consumerKeys, (SingleKeySet)producerKeys);
    }

    private boolean matchKeys(Set<Key> privateKeys, Set<Key> publicKeys) {
        for (Key privateKey : privateKeys) {
            if (!publicKeys.contains(this.publicKeyFor(privateKey))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    private String createName() {
        StringBuilder str = new StringBuilder();
        str.append(this.keyHash.name()).append('-');
        if (this.isDual()) {
            str.append("dual");
        } else if (this.producer) {
            str.append("producer");
        } else {
            str.append("consumer");
        }
        return str.toString();
    }

    public static KeyScheme schemeFor(int id) throws IllegalArgumentException {
        switch (id) {
            case 1: {
                return SHA1_DUAL;
            }
            case 2: {
                return SHA1_PRODUCER;
            }
            case 3: {
                return SHA1_CONSUMER;
            }
        }
        throw new IllegalArgumentException("Invalid key scheme ID: " + id);
    }

    public static Set<KeyScheme> schemes() {
        return SCHEMES;
    }
}

