/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.avis.security.Keys;
import org.avis.subscription.ast.Node;
import org.avis.subscription.parser.ParseException;
import org.avis.subscription.parser.SubscriptionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Subscription {
    private static final AtomicLong idCounter = new AtomicLong();
    public long id;
    public String expr;
    public boolean acceptInsecure;
    public Keys keys;
    private Node ast;

    public Subscription(String expr, Keys keys, boolean acceptInsecure) throws ParseException {
        this.expr = expr;
        this.keys = keys;
        this.acceptInsecure = acceptInsecure;
        this.ast = Subscription.parse(expr);
        this.id = Subscription.nextId();
    }

    public void updateExpression(String subscriptionExpr) throws ParseException {
        this.ast = Subscription.parse(subscriptionExpr);
        this.expr = subscriptionExpr;
    }

    public boolean matches(Map<String, Object> attributes) {
        return this.ast.evaluate(attributes) == Node.TRUE;
    }

    private static Node parse(String expr) throws ParseException {
        return new SubscriptionParser(new StringReader(expr)).parseAndValidate();
    }

    private static long nextId() {
        return idCounter.incrementAndGet();
    }
}

